/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.classreading;

import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.classreading.AnnotationMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedMetadata;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedMethodMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;

public class JdtConnectedAnnotationMetadataReadingVisitor
extends AnnotationMetadataReadingVisitor
implements JdtConnectedMetadata {
    private final IType type;

    public JdtConnectedAnnotationMetadataReadingVisitor(ClassLoader classloader, IType type) {
        super(classloader);
        this.type = type;
    }

    public IJavaElement getJavaElement() {
        return this.type;
    }

    public JavaModelSourceLocation createSourceLocation() throws JavaModelException {
        return new JavaModelSourceLocation((IJavaElement)this.type);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        IMethod method = this.getMethodFromSignature(name, desc);
        return new JdtConnectedMethodMetadataReadingVisitor(name, access, this.getClassName(), this.classLoader, this.methodMetadataSet, method, Type.getReturnType((String)desc).getClassName());
    }

    public boolean isAnnotated(String annotationType) {
        return !ImportResource.class.getName().equals(annotationType) && super.isAnnotated(annotationType);
    }

    private IMethod getMethodFromSignature(String name, String desc) {
        if (System.getProperty("spring-tooling.scanning.verbose", "false").equals("true")) {
            System.out.println("spring-tooling.scanning - findMethodFromSignature - type: " + this.type.getFullyQualifiedName() + " - method: " + name + " - signature: " + desc);
        }
        Type[] parameterTypes = Type.getArgumentTypes((String)desc);
        IMethod method = null;
        method = this.isConstructor(name) ? this.quickCheckForConstructor(parameterTypes) : this.quickCheckForMethod(name, parameterTypes);
        if (method == null) {
            ArrayList<String> parameters = new ArrayList<String>();
            if (parameterTypes != null && parameterTypes.length > 0) {
                Type[] typeArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Type parameterType = typeArray[n2];
                    parameters.add(parameterType.getClassName());
                    ++n2;
                }
            }
            if (this.isConstructor(name)) {
                method = JdtUtils.getConstructor(this.type, parameters.toArray(new String[parameters.size()]));
            } else {
                if (System.getProperty("spring-tooling.scanning.verbose", "false").equals("true")) {
                    System.out.println("spring-tooling.scanning - deep dive to find method - type: " + this.type.getFullyQualifiedName() + " - method: " + name + " - signature: " + desc);
                }
                method = JdtUtils.getMethod(this.type, name, parameters.toArray(new String[parameters.size()]), false);
            }
        }
        return method;
    }

    private boolean isConstructor(String name) {
        return "<init>".equals(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMethod quickCheckForMethod(String name, Type[] parameterTypes) {
        IMethod result = null;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(name) && method.getParameterTypes().length == parameterTypes.length) {
                    if (result != null) return null;
                    result = method;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMethod quickCheckForConstructor(Type[] parameterTypes) {
        IMethod result = null;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                IMethod method = iMethodArray[n2];
                if (method.isConstructor() && method.getParameterTypes().length == parameterTypes.length) {
                    if (result != null) return null;
                    result = method;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }
}

