/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.annotation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.annotation.Annotation;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberValuePair;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtBasedAnnotationMetadata
implements IAnnotationMetadata {
    private final IType type;
    private Map<String, Annotation> classAnnotations = new LinkedHashMap<String, Annotation>();
    private Map<IMethod, Set<Annotation>> methodAnnotations = new LinkedHashMap<IMethod, Set<Annotation>>();
    private Map<IField, Set<Annotation>> fieldAnnotations = new LinkedHashMap<IField, Set<Annotation>>();
    private Set<IType> allImplementedInterfaces;

    public JdtBasedAnnotationMetadata(IType type) {
        this.type = type;
        this.init();
    }

    private void init() {
        try {
            IAnnotation annotation;
            int n;
            int n2;
            IAnnotation[] iAnnotationArray;
            Set<Object> modelAnnotations;
            for (IAnnotation annotation2 : Introspector.getAllAnnotations(this.type)) {
                Annotation processedAnnotation = this.processAnnotation(annotation2);
                if (this.classAnnotations.containsKey(processedAnnotation.getAnnotationClass())) continue;
                this.classAnnotations.put(processedAnnotation.getAnnotationClass(), processedAnnotation);
            }
            for (IMethod method : Introspector.getAllMethods(this.type)) {
                modelAnnotations = new LinkedHashSet<Annotation>();
                iAnnotationArray = method.getAnnotations();
                n2 = iAnnotationArray.length;
                n = 0;
                while (n < n2) {
                    annotation = iAnnotationArray[n];
                    modelAnnotations.add(this.processAnnotation(annotation));
                    ++n;
                }
                if (modelAnnotations.size() <= 0) {
                    modelAnnotations = this.processInterfaceMethods(method);
                }
                if (modelAnnotations.size() <= 0) continue;
                this.methodAnnotations.put(method, modelAnnotations);
            }
            for (IMethod method : Introspector.getAllConstructors(this.type)) {
                modelAnnotations = new LinkedHashSet();
                iAnnotationArray = method.getAnnotations();
                n2 = iAnnotationArray.length;
                n = 0;
                while (n < n2) {
                    annotation = iAnnotationArray[n];
                    modelAnnotations.add(this.processAnnotation(annotation));
                    ++n;
                }
                if (modelAnnotations.size() <= 0) continue;
                this.methodAnnotations.put(method, modelAnnotations);
            }
            for (IField field : Introspector.getAllFields(this.type)) {
                modelAnnotations = new LinkedHashSet();
                iAnnotationArray = field.getAnnotations();
                n2 = iAnnotationArray.length;
                n = 0;
                while (n < n2) {
                    annotation = iAnnotationArray[n];
                    modelAnnotations.add(this.processAnnotation(annotation));
                    ++n;
                }
                if (modelAnnotations.size() <= 0) continue;
                this.fieldAnnotations.put(field, modelAnnotations);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private Annotation processAnnotation(IAnnotation annotation, IType itype) {
        Annotation modelAnnotation;
        if (itype.isBinary()) {
            modelAnnotation = new Annotation(annotation.getElementName());
        } else {
            IType type = itype;
            IJavaElement parent = annotation.getParent();
            while (parent != null && !(parent instanceof IType)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                type = (IType)parent;
            }
            modelAnnotation = new Annotation(JdtUtils.resolveClassName(annotation.getElementName(), type));
        }
        try {
            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
            int n = iMemberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair member = iMemberValuePairArray[n2];
                StringBuilder builder = new StringBuilder();
                if (member.getValue() != null && member.getValue().getClass().isArray()) {
                    Object[] values = (Object[])member.getValue();
                    int i = 0;
                    while (i < values.length) {
                        this.processStringValue(member, builder, values[i].toString());
                        if (i < values.length - 1) {
                            builder.append(", ");
                        }
                        ++i;
                    }
                } else if (member.getValue() != null) {
                    this.processStringValue(member, builder, member.getValue().toString());
                }
                modelAnnotation.addMember(new AnnotationMemberValuePair("value".equals(member.getMemberName()) ? null : member.getMemberName(), builder.toString()));
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return modelAnnotation;
    }

    private Annotation processAnnotation(IAnnotation annotation) {
        return this.processAnnotation(annotation, this.type);
    }

    private Set<Annotation> processInterfaceMethods(IMethod method) throws JavaModelException {
        LinkedHashSet<Annotation> modelAnnotations = new LinkedHashSet<Annotation>();
        Set<IType> interfaces = this.getAllImplementedInterfaces();
        for (IType iface : interfaces) {
            IMethod[] interfaceMethod = iface.findMethods(method);
            if (interfaceMethod == null || interfaceMethod.length <= 0) continue;
            IAnnotation[] iAnnotationArray = interfaceMethod[0].getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                modelAnnotations.add(this.processAnnotation(annotation, iface));
                ++n2;
            }
        }
        return modelAnnotations;
    }

    private Set<IType> getAllImplementedInterfaces() {
        if (this.allImplementedInterfaces == null) {
            this.allImplementedInterfaces = Introspector.getAllImplementedInterfaces(this.type);
        }
        return this.allImplementedInterfaces;
    }

    private void processStringValue(IMemberValuePair member, StringBuilder builder, String value) {
        if (member.getValueKind() == 11) {
            String className = JdtUtils.resolveClassName(value, this.type);
            if (className != null) {
                builder.append(ClassUtils.getShortName((String)className));
            } else {
                builder.append(value);
            }
        } else if (member.getValueKind() == 12 || member.getValueKind() == 13) {
            String tempValue = value;
            int i = tempValue.lastIndexOf(46);
            while (i > 0) {
                String className = JdtUtils.resolveClassName(tempValue = tempValue.substring(0, i), this.type);
                if (className == null) continue;
                builder.append(ClassUtils.getShortName((String)className)).append(value.substring(i));
                break;
            }
            if (builder.length() == 0) {
                builder.append(value);
            }
        } else {
            builder.append(value);
        }
    }

    @Override
    public Map<IMethod, Annotation> getMethodLevelAnnotations(String ... annotationClasses) {
        HashMap<IMethod, Annotation> methodAnnotation = new HashMap<IMethod, Annotation>();
        for (Map.Entry<IMethod, Set<Annotation>> entry : this.methodAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                String[] stringArray = annotationClasses;
                int n = annotationClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    String annotationClass = stringArray[n2];
                    if (annotation.getAnnotationClass().equals(annotationClass)) {
                        methodAnnotation.put(entry.getKey(), annotation);
                    }
                    ++n2;
                }
            }
        }
        return methodAnnotation;
    }

    @Override
    public boolean hasMethodLevelAnnotations(String ... annotationClass) {
        List<String> annoatations = Arrays.asList(annotationClass);
        for (Map.Entry<IMethod, Set<Annotation>> entry : this.methodAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                if (!annoatations.contains(annotation.getAnnotationClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<IField, Annotation> getFieldLevelAnnotations(String ... annotationClasses) {
        HashMap<IField, Annotation> fieldAnnotation = new HashMap<IField, Annotation>();
        for (Map.Entry<IField, Set<Annotation>> entry : this.fieldAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                String[] stringArray = annotationClasses;
                int n = annotationClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    String annotationClass = stringArray[n2];
                    if (annotation.getAnnotationClass().equals(annotationClass)) {
                        fieldAnnotation.put(entry.getKey(), annotation);
                    }
                    ++n2;
                }
            }
        }
        return fieldAnnotation;
    }

    @Override
    public boolean hasFieldLevelAnnotations(String ... annotationClass) {
        List<String> annoatations = Arrays.asList(annotationClass);
        for (Map.Entry<IField, Set<Annotation>> entry : this.fieldAnnotations.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                if (!annoatations.contains(annotation.getAnnotationClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getTypeLevelAnnotationClasses() {
        return this.classAnnotations.keySet();
    }

    @Override
    public Annotation getTypeLevelAnnotation(String annotationClass) {
        return this.classAnnotations.get(annotationClass);
    }

    @Override
    public boolean hasTypeLevelAnnotations(String ... annotationClasses) {
        Set<String> foundAnnoatationClasses = this.getTypeLevelAnnotationClasses();
        String[] stringArray = annotationClasses;
        int n = annotationClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String annotationClass = stringArray[n2];
            if (foundAnnoatationClasses.contains(annotationClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

