/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.ClassUtils;
import org.springframework.ide.eclipse.core.java.ITypeStructureCache;
import org.springframework.ide.eclipse.core.java.TypeStructure;

public class TypeStructureCache
implements ITypeStructureCache {
    private static final char[][] EMPTY_CHAR_ARRAY = new char[0][];
    private IElementChangedListener changedListener = null;
    private Map<IProject, Map<String, TypeStructure>> typeStructuresByProject = new ConcurrentHashMap<IProject, Map<String, TypeStructure>>();
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock r = this.rwl.readLock();
    protected final Lock w = this.rwl.writeLock();

    public void startup() {
        this.changedListener = new TypeRemovingJavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.changedListener);
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.changedListener);
        this.changedListener = null;
        this.typeStructuresByProject = null;
    }

    public void clearStateForProject(IProject project) {
        try {
            this.w.lock();
            this.typeStructuresByProject.remove(project);
        }
        finally {
            this.w.unlock();
        }
    }

    public boolean hasRecordedTypeStructures(IProject project) {
        try {
            this.r.lock();
            boolean bl = this.typeStructuresByProject.containsKey(project);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void recordTypeStructures(IProject project, IResource ... resources) {
        try {
            this.w.lock();
            typeStructures = null;
            if (!this.typeStructuresByProject.containsKey(project)) {
                typeStructures = new ConcurrentHashMap<K, V>();
                this.typeStructuresByProject.put(project, typeStructures);
            } else {
                typeStructures = this.typeStructuresByProject.get(project);
            }
            var7_4 = resources;
            var6_5 = resources.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                block29: {
                    resource = var7_4[var5_6];
                    if (resource.getFileExtension().equals("class") && resource instanceof IFile) {
                        input = null;
                        try {
                            input = ((IFile)resource).getContents();
                            reader = ClassFileReader.read((InputStream)input, (String)resource.getName());
                            typeStructure = new TypeStructure(reader);
                            typeStructures.put(new String(reader.getName()).replace('/', '.'), (Object)typeStructure);
                        }
                        catch (CoreException v0) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException v1) {}
                            }
                            break block29;
                        }
                        catch (ClassFormatException v2) {
                            ** if (input == null) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    input.close();
                                }
                                catch (IOException v3) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block29;
                            }
                        }
                        catch (IOException v4) {
                            ** if (input == null) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    input.close();
                                }
                                catch (IOException v5) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block29;
                            }
                            {
                                catch (Throwable var11_11) {
                                    if (input != null) {
                                        try {
                                            input.close();
                                        }
                                        catch (IOException v6) {}
                                    }
                                    throw var11_11;
                                }
                            }
                        }
                        if (input == null) break block29;
                        try {
                            input.close();
                        }
                        catch (IOException v7) {}
                    }
                }
                ++var5_6;
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasStructuralChanges(IResource resource, int flags) {
        this.r.lock();
        if (!this.hasRecordedTypeStructures(resource.getProject())) {
            return true;
        }
        typeStructures = this.typeStructuresByProject.get(resource.getProject());
        if (resource == null) return true;
        if (resource.getFileExtension() == null) return true;
        if (resource.getFileExtension().equals("java") == false) return true;
        element = JavaCore.create((IResource)resource);
        if (element instanceof ICompilationUnit == false) return true;
        if (((ICompilationUnit)element).isOpen() == false) return true;
        try {
            var9_8 = types = ((ICompilationUnit)element).getAllTypes();
            var8_9 = types.length;
            var7_10 = 0;
            if (true) ** GOTO lbl33
        }
        catch (JavaModelException e) {
            SpringCore.log(e);
            return true;
        }
        catch (MalformedURLException e) {
            SpringCore.log(e);
            return true;
        }
        finally {
            this.r.unlock();
        }
        do {
            if ((typeStructure = typeStructures.get(fqn = (type = var9_8[var7_10]).getFullyQualifiedName())) == null) {
                return true;
            }
            reader = TypeStructureCache.getClassFileReaderForClassName(type.getFullyQualifiedName(), resource.getProject());
            if (reader != null && this.hasStructuralChanges(reader, typeStructure, flags)) {
                return true;
            }
            ++var7_10;
lbl33:
            // 2 sources

        } while (var7_10 < var8_9);
        return false;
    }

    protected void removeRecordedTyeStructures(IProject project, String className) {
        try {
            this.w.lock();
            if (!this.hasRecordedTypeStructures(project)) {
                return;
            }
            String innerClassName = String.valueOf(className) + "$";
            ArrayList<String> typeStructuresToRemove = new ArrayList<String>();
            Map<String, TypeStructure> typeStructures = this.typeStructuresByProject.get(project);
            for (String recordedClassName : typeStructures.keySet()) {
                if (!className.equals(recordedClassName) && !recordedClassName.startsWith(innerClassName)) continue;
                typeStructuresToRemove.add(recordedClassName);
            }
            for (String recordedClassName : typeStructuresToRemove) {
                typeStructures.remove(recordedClassName);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private static ClassFileReader getClassFileReaderForClassName(String className, IProject project) throws JavaModelException, MalformedURLException {
        IJavaProject jp = JavaCore.create((IProject)project);
        File outputDirectory = TypeStructureCache.convertPathToFile(project, jp.getOutputLocation());
        File classFile = new File(outputDirectory, ClassUtils.getClassFileName(className));
        if (classFile.exists() && classFile.canRead()) {
            try {
                return ClassFileReader.read((File)classFile);
            }
            catch (ClassFormatException classFormatException) {
            }
            catch (IOException iOException) {}
        }
        IClasspathEntry[] classpath = jp.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry path = classpath[i];
            if (path.getEntryKind() == 3 && (classFile = new File(outputDirectory = TypeStructureCache.convertPathToFile(project, path.getOutputLocation()), ClassUtils.getClassFileName(className))).exists() && classFile.canRead()) {
                try {
                    return ClassFileReader.read((File)classFile);
                }
                catch (ClassFormatException classFormatException) {
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return null;
    }

    private static File convertPathToFile(IProject project, IPath path) throws MalformedURLException {
        URI uri;
        IResource resource;
        if (path != null && project != null && path.removeFirstSegments(1) != null && (resource = project.findMember(path.removeFirstSegments(1))) != null && (uri = resource.getRawLocationURI()) != null) {
            String scheme = uri.getScheme();
            if ("file".equalsIgnoreCase(scheme)) {
                return TypeStructureCache.toLocalFile(uri);
            }
            IPathVariableManager variableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
            return TypeStructureCache.toLocalFile(variableManager.resolveURI(uri));
        }
        return null;
    }

    private static File toLocalFile(URI locationURI) {
        if (locationURI == null) {
            return null;
        }
        try {
            IFileStore store = EFS.getStore((URI)locationURI);
            return store.toLocalFile(0, null);
        }
        catch (CoreException ex) {
            SpringCore.log("Error while converting URI to local file: " + locationURI.toString(), ex);
            return null;
        }
    }

    private boolean hasStructuralChanges(ClassFileReader reader, TypeStructure existingType, int flags) {
        IBinaryMethod[] existingMs;
        IBinaryField[] existingFs;
        IBinaryAnnotation[] newAnnotations;
        IBinaryAnnotation[] existingAnnotations;
        if (existingType == null) {
            return true;
        }
        if (!TypeStructureCache.modifiersEqual(reader.getModifiers(), existingType.modifiers)) {
            return true;
        }
        if (!CharOperation.equals((char[])reader.getGenericSignature(), (char[])existingType.genericSignature)) {
            return true;
        }
        if (!CharOperation.equals((char[])reader.getSuperclassName(), (char[])existingType.superclassName)) {
            return true;
        }
        if ((flags & 8) != 0 && !TypeStructureCache.annotationsEqual(existingAnnotations = existingType.getAnnotations(), newAnnotations = reader.getAnnotations(), flags)) {
            return true;
        }
        if (reader.getTagBits() != existingType.getTagBits()) {
            return true;
        }
        char[][] existingIfs = existingType.interfaces;
        char[][] newIfsAsChars = reader.getInterfaceNames();
        if (newIfsAsChars == null) {
            newIfsAsChars = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs == null) {
            existingIfs = EMPTY_CHAR_ARRAY;
        }
        if (existingIfs.length != newIfsAsChars.length) {
            return true;
        }
        int i = 0;
        while (i < newIfsAsChars.length) {
            block29: {
                int j = 0;
                while (j < existingIfs.length) {
                    if (!CharOperation.equals((char[])existingIfs[j], (char[])newIfsAsChars[i])) {
                        ++j;
                        continue;
                    }
                    break block29;
                }
                return true;
            }
            ++i;
        }
        IBinaryField[] newFields = reader.getFields();
        if (newFields == null) {
            newFields = TypeStructure.NoField;
        }
        if (newFields.length != (existingFs = existingType.binFields).length) {
            return true;
        }
        int i2 = 0;
        while (i2 < newFields.length) {
            block30: {
                IBinaryField field = newFields[i2];
                char[] fieldName = field.getName();
                int j = 0;
                while (j < existingFs.length) {
                    if (CharOperation.equals((char[])existingFs[j].getName(), (char[])fieldName)) {
                        if (!TypeStructureCache.modifiersEqual(field.getModifiers(), existingFs[j].getModifiers())) {
                            return true;
                        }
                        if (!CharOperation.equals((char[])existingFs[j].getTypeName(), (char[])field.getTypeName())) {
                            return true;
                        }
                        if ((flags & 8) != 0 && !TypeStructureCache.annotationsEqual(field.getAnnotations(), existingFs[j].getAnnotations(), flags)) {
                            return true;
                        }
                        break block30;
                    }
                    ++j;
                }
                return true;
            }
            ++i2;
        }
        IBinaryMethod[] newMethods = reader.getMethods();
        if (newMethods == null) {
            newMethods = TypeStructure.NoMethod;
        }
        if (newMethods.length != (existingMs = existingType.binMethods).length) {
            return true;
        }
        int i3 = 0;
        while (i3 < newMethods.length) {
            block31: {
                IBinaryMethod method = newMethods[i3];
                char[] methodName = method.getSelector();
                int j = 0;
                while (j < existingMs.length) {
                    if (CharOperation.equals((char[])existingMs[j].getSelector(), (char[])methodName) && CharOperation.equals((char[])method.getMethodDescriptor(), (char[])existingMs[j].getMethodDescriptor())) {
                        if (!TypeStructureCache.modifiersEqual(method.getModifiers(), existingMs[j].getModifiers())) {
                            return true;
                        }
                        if ((flags & 8) != 0) {
                            if (!TypeStructureCache.annotationsEqual(method.getAnnotations(), existingMs[j].getAnnotations(), flags)) {
                                return true;
                            }
                            if (!TypeStructureCache.parameterAnnotationsEquals(method, existingMs[j], flags)) {
                                return true;
                            }
                        }
                        break block31;
                    }
                    ++j;
                }
                return true;
            }
            ++i3;
        }
        return false;
    }

    private static boolean parameterAnnotationsEquals(IBinaryMethod newMethod, IBinaryMethod existingMethod, int flags) {
        int existingArgumentCount;
        char[][] argumentNames = newMethod.getArgumentNames();
        char[][] existingArgumentNames = existingMethod.getArgumentNames();
        if (argumentNames == null && existingArgumentNames == null) {
            return true;
        }
        int argumentCount = argumentNames != null ? argumentNames.length : 0;
        int n = existingArgumentCount = existingArgumentNames != null ? existingArgumentNames.length : 0;
        if (argumentCount != existingArgumentCount) {
            return false;
        }
        int i = 0;
        while (i < argumentCount) {
            IBinaryAnnotation[] existingParameterAnnotations;
            IBinaryAnnotation[] parameterAnnotations = newMethod.getParameterAnnotations(i);
            if (!TypeStructureCache.annotationsEqual(parameterAnnotations, existingParameterAnnotations = existingMethod.getParameterAnnotations(i), flags)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean annotationsEqual(IBinaryAnnotation[] existingAnnotations, IBinaryAnnotation[] newAnnotations, int flags) {
        if (existingAnnotations == null) {
            existingAnnotations = TypeStructure.NoAnnotation;
        }
        if (newAnnotations == null) {
            newAnnotations = TypeStructure.NoAnnotation;
        }
        if (existingAnnotations.length != newAnnotations.length) {
            return false;
        }
        int i = 0;
        while (i < newAnnotations.length) {
            block14: {
                int j = 0;
                while (j < existingAnnotations.length) {
                    if (CharOperation.equals((char[])newAnnotations[j].getTypeName(), (char[])existingAnnotations[i].getTypeName())) {
                        if ((flags & 0x10) != 0) {
                            IBinaryElementValuePair[] newParameters = newAnnotations[j].getElementValuePairs();
                            IBinaryElementValuePair[] existingParameters = existingAnnotations[j].getElementValuePairs();
                            if (newParameters == null) {
                                newParameters = TypeStructure.NoElement;
                            }
                            if (existingParameters == null) {
                                existingParameters = TypeStructure.NoElement;
                            }
                            if (existingParameters.length != newParameters.length) {
                                return false;
                            }
                            int k = 0;
                            while (k < newParameters.length) {
                                int l = 0;
                                while (l < existingParameters.length) {
                                    char[] newName = newParameters[l].getName();
                                    char[] existingName = existingParameters[l].getName();
                                    Object newValue = newParameters[l].getValue();
                                    Object existingValue = existingParameters[l].getValue();
                                    if (!CharOperation.equals((char[])newName, (char[])existingName)) {
                                        return false;
                                    }
                                    if (!TypeStructureCache.parameterValuesEquals(flags, newValue, existingValue)) {
                                        return false;
                                    }
                                    ++l;
                                }
                                ++k;
                            }
                        }
                        break block14;
                    }
                    ++j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parameterValuesEquals(int flags, Object newValue, Object existingValue) {
        if (newValue.getClass().isArray() && existingValue.getClass().isArray()) {
            Object[] newValueArray = (Object[])newValue;
            Object[] existingValueArray = (Object[])existingValue;
            if (newValueArray.length != existingValueArray.length) {
                return false;
            }
            int i = 0;
            while (i < newValueArray.length) {
                if (!TypeStructureCache.parameterValuesEquals(flags, newValueArray[i], existingValueArray[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        } else {
            if (newValue instanceof ClassSignature) {
                if (!(existingValue instanceof ClassSignature)) return false;
                if (CharOperation.equals((char[])((ClassSignature)newValue).getTypeName(), (char[])((ClassSignature)existingValue).getTypeName())) return true;
                return false;
            }
            if (newValue instanceof Constant) {
                if (!(existingValue instanceof Constant)) return false;
                if (((Constant)newValue).hasSameValue((Constant)existingValue)) return true;
                return false;
            }
            if (newValue instanceof EnumConstantSignature) {
                if (!(existingValue instanceof EnumConstantSignature)) return false;
                if (CharOperation.equals((char[])((EnumConstantSignature)newValue).getTypeName(), (char[])((EnumConstantSignature)existingValue).getTypeName()) && CharOperation.equals((char[])((EnumConstantSignature)newValue).getEnumConstantName(), (char[])((EnumConstantSignature)existingValue).getEnumConstantName())) return true;
                return false;
            }
            if (!(newValue instanceof IBinaryAnnotation)) return true;
            if (!(existingValue instanceof EnumConstantSignature)) return false;
            if (TypeStructureCache.annotationsEqual(new IBinaryAnnotation[]{(IBinaryAnnotation)newValue}, new IBinaryAnnotation[]{(IBinaryAnnotation)existingValue}, flags)) return true;
            return false;
        }
    }

    private static boolean modifiersEqual(int eclipseModifiers, int resolvedTypeModifiers) {
        return (eclipseModifiers &= 0xFFFF) == (resolvedTypeModifiers &= 0xFFFF);
    }

    private class TypeRemovingJavaElementChangeListener
    implements IElementChangedListener {
        private TypeRemovingJavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            Object obj;
            if (event.getType() == 1 && (obj = event.getSource()) instanceof IJavaElementDelta) {
                IJavaElementDelta delta = (IJavaElementDelta)obj;
                this.iterateChildren(new IJavaElementDelta[]{delta}, new IJavaProject[1]);
            }
        }

        private void iterateChildren(IJavaElementDelta[] deltas, IJavaProject[] javaProject) {
            IJavaElementDelta[] iJavaElementDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta[] removedDeltas;
                IJavaElementDelta delta = iJavaElementDeltaArray[n2];
                if (delta.getElement() instanceof IJavaProject) {
                    javaProject[0] = (IJavaProject)delta.getElement();
                }
                IJavaElementDelta[] iJavaElementDeltaArray2 = removedDeltas = delta.getRemovedChildren();
                int n3 = removedDeltas.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElementDelta removedDelta = iJavaElementDeltaArray2[n4];
                    IJavaElement je = removedDelta.getElement();
                    if (je instanceof ICompilationUnit) {
                        StringBuilder sb = new StringBuilder();
                        this.guessClassName(je, sb);
                        if (javaProject[0] != null) {
                            TypeStructureCache.this.removeRecordedTyeStructures(javaProject[0].getProject(), sb.toString());
                        }
                    }
                    ++n4;
                }
                this.iterateChildren(delta.getAffectedChildren(), javaProject);
                ++n2;
            }
        }

        private void guessClassName(IJavaElement cu, StringBuilder sb) {
            if (cu instanceof IPackageFragment) {
                if (cu.getElementName().length() > 0) {
                    sb.insert(0, String.valueOf(cu.getElementName()) + ".");
                }
            } else if (cu != null) {
                if (cu instanceof ICompilationUnit) {
                    int ix = cu.getElementName().lastIndexOf(46);
                    String name = cu.getElementName().substring(0, ix);
                    sb.insert(0, name);
                } else {
                    sb.insert(0, cu.getElementName());
                }
                this.guessClassName(cu.getParent(), sb);
            }
        }
    }
}

