/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.xbean.classloader.NonLockingJarFileClassLoader;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClassLoaderCache {
    private static final String FILE_SCHEME = "file";
    private static final int CACHE_SIZE = 12;
    private static final Enumeration<URL> EMPTY_ENUMERATION = Collections.enumeration(new ArrayList());
    private static final List<ClassLoaderCacheEntry> CLASSLOADER_CACHE = new ArrayList<ClassLoaderCacheEntry>(12);
    private static final String DEBUG_OPTION = "org.springframework.ide.eclipse.core/java/classloader/debug";
    private static final boolean DEBUG_CLASSLOADER = SpringCore.isDebug("org.springframework.ide.eclipse.core/java/classloader/debug");
    private static ClassLoader cachedParentClassLoader = null;
    private static Preferences.IPropertyChangeListener propertyChangeListener = null;
    private static IResourceChangeListener resourceChangeListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader addClassLoaderToCache(IProject project, List<URL> urls, ClassLoader parentClassLoader) {
        List<ClassLoaderCacheEntry> list = CLASSLOADER_CACHE;
        synchronized (list) {
            int nEntries = CLASSLOADER_CACHE.size();
            if (nEntries >= 12) {
                ClassLoaderCacheEntry oldest = null;
                ArrayList<ClassLoaderCacheEntry> obsoleteClassLoaders = new ArrayList<ClassLoaderCacheEntry>(12);
                int i = 0;
                while (i < nEntries) {
                    ClassLoaderCacheEntry entry = CLASSLOADER_CACHE.get(i);
                    IProject curr = entry.getProject();
                    if (!(curr.exists() && curr.isAccessible() && curr.isOpen())) {
                        obsoleteClassLoaders.add(entry);
                    } else if (oldest == null || entry.getLastAccess() < oldest.getLastAccess()) {
                        oldest = entry;
                    }
                    ++i;
                }
                if (!obsoleteClassLoaders.isEmpty()) {
                    i = 0;
                    while (i < obsoleteClassLoaders.size()) {
                        ProjectClassLoaderCache.removeClassLoaderEntryFromCache((ClassLoaderCacheEntry)obsoleteClassLoaders.get(i));
                        ++i;
                    }
                } else if (oldest != null) {
                    ProjectClassLoaderCache.removeClassLoaderEntryFromCache(oldest);
                }
            }
            ClassLoaderCacheEntry newEntry = new ClassLoaderCacheEntry(project, urls, parentClassLoader);
            CLASSLOADER_CACHE.add(newEntry);
            return newEntry.getClassLoader();
        }
    }

    private static void addClassPathUrls(IProject project, List<URL> paths, Set<IProject> resolvedProjects) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (resolvedProjects.contains(project)) {
            return;
        }
        resolvedProjects.add(project);
        try {
            if (JdtUtils.isJavaProject((IResource)project)) {
                IJavaProject jp = JavaCore.create((IProject)project);
                IClasspathEntry[] classpath = jp.getResolvedClasspath(true);
                int i = 0;
                while (i < classpath.length) {
                    IClasspathEntry path = classpath[i];
                    if (path.getEntryKind() == 1) {
                        IPath entryPath = path.getPath();
                        File file = entryPath.toFile();
                        if (file.exists()) {
                            paths.add(file.toURI().toURL());
                        } else {
                            String projectName = entryPath.segment(0);
                            IProject pathProject = root.getProject(projectName);
                            ProjectClassLoaderCache.covertPathToUrl(pathProject, paths, entryPath);
                        }
                    } else if (path.getEntryKind() == 3) {
                        IPath sourcePath = path.getPath();
                        ProjectClassLoaderCache.covertPathToUrl(project, paths, sourcePath);
                        IPath sourceOutputPath = path.getOutputLocation();
                        ProjectClassLoaderCache.covertPathToUrl(project, paths, sourceOutputPath);
                    }
                    ++i;
                }
                for (IJavaProject p : JdtUtils.getAllDependingJavaProjects(jp)) {
                    ProjectClassLoaderCache.addClassPathUrls(p.getProject(), paths, resolvedProjects);
                }
                IPath outputPath = jp.getOutputLocation();
                ProjectClassLoaderCache.covertPathToUrl(project, paths, outputPath);
            } else {
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    ProjectClassLoaderCache.addClassPathUrls(p, paths, resolvedProjects);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
    }

    private static void addUri(List<URL> paths, URI uri) throws MalformedURLException {
        File file = new File(uri);
        if (file.isDirectory()) {
            paths.add(new URL(String.valueOf(uri.toString()) + File.separator));
        } else {
            paths.add(uri.toURL());
        }
    }

    private static void covertPathToUrl(IProject project, List<URL> paths, IPath path) throws MalformedURLException {
        URI uri;
        if (path != null && project != null && path.removeFirstSegments(1) != null && project.findMember(path.removeFirstSegments(1)) != null && (uri = project.findMember(path.removeFirstSegments(1)).getRawLocationURI()) != null) {
            String scheme = uri.getScheme();
            if (FILE_SCHEME.equalsIgnoreCase(scheme)) {
                ProjectClassLoaderCache.addUri(paths, uri);
            } else if ("sourcecontrol".equals(scheme)) {
                IPath sourceControlPath = project.findMember(path.removeFirstSegments(1)).getLocation();
                File sourceControlFile = sourceControlPath.toFile();
                if (sourceControlFile.exists()) {
                    ProjectClassLoaderCache.addUri(paths, sourceControlFile.toURI());
                }
            } else {
                IPathVariableManager variableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
                ProjectClassLoaderCache.addUri(paths, variableManager.resolveURI(uri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader findClassLoaderInCache(IProject project, ClassLoader parentClassLoader) {
        List<ClassLoaderCacheEntry> list = CLASSLOADER_CACHE;
        synchronized (list) {
            int i = CLASSLOADER_CACHE.size() - 1;
            while (i >= 0) {
                ClassLoaderCacheEntry entry = CLASSLOADER_CACHE.get(i);
                IProject curr = entry.getProject();
                if (!(curr != null && curr.exists() && curr.isAccessible() && curr.isOpen())) {
                    ProjectClassLoaderCache.removeClassLoaderEntryFromCache(entry);
                    if (DEBUG_CLASSLOADER) {
                        System.out.println(String.format("> removing classloader for '%s' : total %s", entry.getProject(), CLASSLOADER_CACHE.size()));
                    }
                } else if (entry.matches(project, parentClassLoader)) {
                    entry.markAsAccessed();
                    return entry.getClassLoader();
                }
                --i;
            }
        }
        return null;
    }

    public static List<URL> getClassPathUrls(IProject project, ClassLoader parentClassLoader) {
        ArrayList<URL> paths = new ArrayList<URL>();
        HashSet<IProject> resolvedProjects = new HashSet<IProject>();
        ProjectClassLoaderCache.addClassPathUrls(project, paths, resolvedProjects);
        return paths;
    }

    private static void registerListenersIfRequired() {
        if (propertyChangeListener == null) {
            propertyChangeListener = new EnablementPropertyChangeListener();
            SpringCore.getDefault().getPluginPreferences().addPropertyChangeListener(propertyChangeListener);
        }
        if (resourceChangeListener == null) {
            resourceChangeListener = new SourceAndOutputLocationResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeClassLoaderEntryFromCache(ClassLoaderCacheEntry entry) {
        List<ClassLoaderCacheEntry> list = CLASSLOADER_CACHE;
        synchronized (list) {
            if (DEBUG_CLASSLOADER) {
                System.out.println(String.format("> removing classloader for '%s' : total %s", entry.getProject().getName(), CLASSLOADER_CACHE.size()));
            }
            entry.dispose();
            CLASSLOADER_CACHE.remove(entry);
        }
    }

    public static boolean shouldFilter(String name) {
        if ("commons-logging.properties".equals(name)) {
            return true;
        }
        if (name != null && name.startsWith("META-INF/services/")) {
            return name.indexOf(47, 18) == -1;
        }
        return false;
    }

    private static boolean useNonLockingClassLoader() {
        return SpringCore.getDefault().getPluginPreferences().getBoolean("org.springframework.ide.eclipse.core.useNonLockingClassLoader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ClassLoader getClassLoader(IProject project, ClassLoader parentClassLoader) {
        Class<ProjectClassLoaderCache> clazz = ProjectClassLoaderCache.class;
        synchronized (ProjectClassLoaderCache.class) {
            if (parentClassLoader == null && cachedParentClassLoader == null) {
                ArrayList<URL> paths = new ArrayList<URL>();
                Enumeration libs = SpringCore.getDefault().getBundle().getEntryPaths("/lib/");
                while (libs.hasMoreElements()) {
                    String lib = (String)libs.nextElement();
                    if (lib.contains("xbean-nonlocking-classloader")) continue;
                    paths.add(SpringCore.getDefault().getBundle().getEntry(lib));
                }
                paths.addAll(JdtUtils.getBundleClassPath("org.aspectj.runtime"));
                paths.addAll(JdtUtils.getBundleClassPath("org.aspectj.weaver"));
                paths.addAll(JdtUtils.getBundleClassPath("org.objectweb.asm"));
                paths.addAll(JdtUtils.getBundleClassPath("org.aopalliance"));
                cachedParentClassLoader = new URLClassLoader(paths.toArray(new URL[paths.size()]));
            }
            if (project == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return cachedParentClassLoader;
            }
            ProjectClassLoaderCache.registerListenersIfRequired();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ClassLoader classLoader = ProjectClassLoaderCache.findClassLoaderInCache(project, parentClassLoader);
            if (classLoader == null) {
                List<URL> urls = ProjectClassLoaderCache.getClassPathUrls(project, parentClassLoader);
                classLoader = ProjectClassLoaderCache.addClassLoaderToCache(project, urls, parentClassLoader);
                if (DEBUG_CLASSLOADER) {
                    System.out.println(String.format("> creating new classloader for '%s' with parent '%s' : total %s", project.getName(), parentClassLoader, CLASSLOADER_CACHE.size()));
                }
            }
            return classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeClassLoaderEntryFromCache(IProject project) {
        List<ClassLoaderCacheEntry> list = CLASSLOADER_CACHE;
        synchronized (list) {
            if (DEBUG_CLASSLOADER) {
                System.out.println(String.format("> removing classloader for '%s' : total %s", project.getName(), CLASSLOADER_CACHE.size()));
            }
            for (ClassLoaderCacheEntry entry : new ArrayList<ClassLoaderCacheEntry>(CLASSLOADER_CACHE)) {
                if (!project.equals((Object)entry.getProject())) continue;
                entry.dispose();
                CLASSLOADER_CACHE.remove(entry);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassLoaderCacheEntry
    implements IElementChangedListener {
        private URL[] directories;
        private ClassLoader jarClassLoader;
        private long lastAccess;
        private ClassLoader parentClassLoader;
        private IProject project;
        private URL[] urls;

        public ClassLoaderCacheEntry(IProject project, List<URL> urls, ClassLoader parentClassLoader) {
            this.project = project;
            this.urls = urls.toArray(new URL[urls.size()]);
            this.parentClassLoader = parentClassLoader;
            this.markAsAccessed();
            JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        }

        public void dispose() {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            this.urls = null;
            this.jarClassLoader = null;
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaProject javaProject = JdtUtils.getJavaProject(this.project);
            if (javaProject != null) {
                IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta delta = iJavaElementDeltaArray[n2];
                    if (((delta.getFlags() & 0x200000) != 0 || (delta.getFlags() & 0x20000) != 0) && (javaProject.equals(delta.getElement()) || javaProject.isOnClasspath(delta.getElement()))) {
                        ProjectClassLoaderCache.removeClassLoaderEntryFromCache(this);
                    }
                    ++n2;
                }
            }
        }

        public ClassLoader getClassLoader() {
            ClassLoader parent = this.getJarClassLoader();
            if (ProjectClassLoaderCache.useNonLockingClassLoader()) {
                return new FilteringNonLockingJarFileClassLoader(String.format("ClassLoader for '%s'", this.project.getName()), this.directories, parent);
            }
            return new FilteringURLClassLoader(this.directories, parent);
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        public IProject getProject() {
            return this.project;
        }

        public void markAsAccessed() {
            this.lastAccess = System.currentTimeMillis();
        }

        public boolean matches(IProject project, ClassLoader parentClassLoader) {
            return this.project.equals((Object)project) && (parentClassLoader == null && this.parentClassLoader == null || parentClassLoader != null && parentClassLoader.equals(this.parentClassLoader));
        }

        private synchronized ClassLoader getJarClassLoader() {
            if (this.jarClassLoader == null) {
                LinkedHashSet<URL> jars = new LinkedHashSet<URL>();
                ArrayList<URL> dirs = new ArrayList<URL>();
                URL[] uRLArray = this.urls;
                int n = this.urls.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    if (this.shouldLoadFromParent(url)) {
                        jars.add(url);
                    } else {
                        dirs.add(url);
                    }
                    ++n2;
                }
                this.jarClassLoader = this.parentClassLoader != null ? (ProjectClassLoaderCache.useNonLockingClassLoader() ? new FilteringNonLockingJarFileClassLoader(String.format("ClassLoader for '%s'", this.project.getName()), jars.toArray(new URL[jars.size()]), this.parentClassLoader) : new FilteringURLClassLoader(jars.toArray(new URL[jars.size()]), this.parentClassLoader)) : (ProjectClassLoaderCache.useNonLockingClassLoader() ? new FilteringNonLockingJarFileClassLoader(String.format("ClassLoader for '%s'", this.project.getName()), jars.toArray(new URL[jars.size()]), cachedParentClassLoader) : new FilteringURLClassLoader(jars.toArray(new URL[jars.size()]), cachedParentClassLoader));
                this.directories = dirs.toArray(new URL[dirs.size()]);
            }
            return this.jarClassLoader;
        }

        private boolean shouldLoadFromParent(URL url) {
            String path = url.getPath();
            if (path.endsWith(".jar") || path.endsWith(".zip")) {
                return true;
            }
            return path.contains("/org.eclipse.osgi/bundles/");
        }
    }

    static class EnablementPropertyChangeListener
    implements Preferences.IPropertyChangeListener {
        EnablementPropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if ("org.springframework.ide.eclipse.core.useNonLockingClassLoader".equals(event.getProperty())) {
                List list = CLASSLOADER_CACHE;
                synchronized (list) {
                    CLASSLOADER_CACHE.clear();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilteringNonLockingJarFileClassLoader
    extends NonLockingJarFileClassLoader {
        public FilteringNonLockingJarFileClassLoader(String name, URL[] urls, ClassLoader parent) {
            super(name, urls, parent);
        }

        public URL findResource(String resourceName) {
            if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
                return null;
            }
            return super.findResource(resourceName);
        }

        public Enumeration<URL> findResources(String resourceName) throws IOException {
            if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
                return EMPTY_ENUMERATION;
            }
            return super.findResources(resourceName);
        }

        public URL getResource(String name) {
            if (ProjectClassLoaderCache.shouldFilter(name)) {
                return null;
            }
            return super.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            if (ProjectClassLoaderCache.shouldFilter(name)) {
                return null;
            }
            return super.getResourceAsStream(name);
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            if (ProjectClassLoaderCache.shouldFilter(name)) {
                return EMPTY_ENUMERATION;
            }
            return super.getResources(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilteringURLClassLoader
    extends URLClassLoader {
        public FilteringURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public URL findResource(String resourceName) {
            if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
                return null;
            }
            return super.findResource(resourceName);
        }

        @Override
        public Enumeration<URL> findResources(String resourceName) throws IOException {
            if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
                return EMPTY_ENUMERATION;
            }
            return super.findResources(resourceName);
        }

        @Override
        public URL getResource(String name) {
            if (ProjectClassLoaderCache.shouldFilter(name)) {
                return null;
            }
            return super.getResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            if (ProjectClassLoaderCache.shouldFilter(name)) {
                return null;
            }
            return super.getResourceAsStream(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (ProjectClassLoaderCache.shouldFilter(name)) {
                return EMPTY_ENUMERATION;
            }
            return super.getResources(name);
        }
    }

    static class SourceAndOutputLocationResourceChangeListener
    implements IResourceChangeListener {
        private static final int VISITOR_FLAGS = 5;

        SourceAndOutputLocationResourceChangeListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getSource() instanceof IWorkspace) {
                int eventType = event.getType();
                switch (eventType) {
                    case 1: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) return;
                        try {
                            delta.accept(this.getVisitor(), 5);
                            return;
                        }
                        catch (CoreException e) {
                            SpringCore.log("Error while traversing resource change delta", e);
                        }
                    }
                    default: {
                        return;
                    }
                }
            } else {
                if (!(event.getSource() instanceof IProject)) return;
                int eventType = event.getType();
                switch (eventType) {
                    case 1: {
                        IResourceDelta delta = event.getDelta();
                        if (delta == null) return;
                        try {
                            delta.accept(this.getVisitor(), 5);
                            return;
                        }
                        catch (CoreException e) {
                            SpringCore.log("Error while traversing resource change delta", e);
                        }
                    }
                }
            }
        }

        protected IResourceDeltaVisitor getVisitor() {
            return new SourceAndOutputLocationResourceVisitor();
        }

        protected class SourceAndOutputLocationResourceVisitor
        implements IResourceDeltaVisitor {
            protected SourceAndOutputLocationResourceVisitor() {
            }

            public final boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                switch (delta.getKind()) {
                    case 1: {
                        return this.resourceAdded(resource);
                    }
                }
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected boolean resourceAdded(IResource resource) {
                if (!(resource instanceof IFolder)) return true;
                if (!JdtUtils.isJavaProject(resource)) return true;
                try {
                    IJavaProject javaProject = JdtUtils.getJavaProject(resource);
                    if (javaProject == null) {
                        return false;
                    }
                    if (javaProject.getOutputLocation() != null && javaProject.getOutputLocation().equals((Object)resource.getFullPath())) {
                        ProjectClassLoaderCache.removeClassLoaderEntryFromCache(resource.getProject());
                        return false;
                    }
                    IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return true;
                        }
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (resource.getFullPath() != null && resource.getFullPath().equals((Object)entry.getPath())) {
                            ProjectClassLoaderCache.removeClassLoaderEntryFromCache(resource.getProject());
                            return false;
                        }
                        if (resource.getFullPath() != null && resource.getFullPath().equals((Object)entry.getOutputLocation())) {
                            ProjectClassLoaderCache.removeClassLoaderEntryFromCache(resource.getProject());
                            return false;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    SpringCore.log("Error traversing resource change delta", e);
                }
                return true;
            }
        }
    }
}

