/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.ajdt.core.AspectJCore;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtWeavingTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjdtUtils {
    private static final String AJDT_CLASS = "org.eclipse.contribution.jdt.IsWovenTester";
    private static final boolean IS_JDT_WEAVING_PRESENT = AjdtUtils.isJdtWeavingPresent();

    public static IType getAjdtType(IProject project, String className) {
        if (IS_JDT_WEAVING_PRESENT && JdtWeavingTester.isJdtWeavingActive()) {
            return null;
        }
        if (project != null && className != null) {
            try {
                List ajcus = AJCompilationUnitManager.INSTANCE.getCachedCUs(project);
                if (ajcus != null) {
                    for (AJCompilationUnit ajcu : ajcus) {
                        IType[] types;
                        IType[] iTypeArray = types = ajcu.getAllTypes();
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type = iTypeArray[n2];
                            if (className.equals(type.getFullyQualifiedName())) {
                                return type;
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
        return null;
    }

    public static IJavaElement getByHandle(String handle) {
        return AspectJCore.create((String)handle);
    }

    public static Set<IMethod> getDeclaredMethods(IType type) throws JavaModelException {
        HashSet<IMethod> methods = new HashSet<IMethod>();
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)type);
        if (model.hasModel()) {
            List elements = model.getRelationshipsForElement((IJavaElement)type, AJRelationshipManager.ASPECT_DECLARATIONS);
            for (IJavaElement element : elements) {
                if (!(element instanceof IntertypeElement)) continue;
                methods.add((IMethod)element);
            }
        }
        return methods;
    }

    public static boolean isJdtWeavingPresent() {
        try {
            Class.forName(AJDT_CLASS);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isTypeAjdtElement(IType type) {
        return type instanceof IAspectJElement;
    }
}

