/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model.validation.rules;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.ide.eclipse.core.internal.model.validation.SpringValidationContext;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringClasspathRule
implements IValidationRule<ISpringProject, SpringValidationContext> {
    @Override
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof ISpringProject;
    }

    @Override
    public void validate(ISpringProject element, SpringValidationContext context, IProgressMonitor monitor) {
        IType type;
        if (JdtUtils.isJavaProject((IResource)element.getProject()) && (type = JdtUtils.getJavaType(element.getProject(), BeanFactory.class.getName())) == null) {
            context.warning(element, "NO_SPRING_ON_CLASSPATH", "Spring appears to be missing from the project's Build Path", new ValidationProblemAttribute[0]);
        }
    }
}

