/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.ide.eclipse.core.PersistablePreferenceObjectSupport;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleDefinition
extends PersistablePreferenceObjectSupport {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabledByDefault";
    private static final String ENABLEMENT_PREFIX = "validator.rule.enable.";
    private static final String PROPERTY_PREFIX = "validator.rule.property.";
    private static final String MESSAGE_PREFIX = "validator.rule.message.";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String MESSAGE_ELEMENT = "message";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String SEVERITY_ATTRIBUTE = "severity";
    private String description;
    private String id;
    private String name;
    private IValidationRule rule;
    private String validatorId;
    private Map<String, String> propertyValues;
    private Map<String, String> originalPropertyValues;
    private Map<String, String> propertyDescriptions;
    private Map<String, Integer> originalMessageSeverities;
    private Map<String, Integer> messageSeverities;
    private Map<String, String> messageDescriptions;
    private boolean rulePropertiesInitialized;

    public ValidationRuleDefinition(String validatorID, IConfigurationElement element) throws CoreException {
        this.validatorId = validatorID;
        this.init(element);
    }

    public ValidationRuleDefinition(String validatorId, String id, String name, String description) {
        this.validatorId = validatorId;
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected String getPreferenceId() {
        return ENABLEMENT_PREFIX + this.id;
    }

    public IValidationRule getRule() {
        if (this.propertyValues.size() > 0 && !this.rulePropertiesInitialized) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)this.rule);
            for (Map.Entry<String, String> entry : this.propertyValues.entrySet()) {
                try {
                    wrapper.setPropertyValue(entry.getKey(), (Object)entry.getValue());
                }
                catch (BeansException e) {
                    SpringCore.log(e);
                }
            }
            this.rulePropertiesInitialized = true;
        }
        return this.rule;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    private void init(IConfigurationElement element) throws CoreException {
        IConfigurationElement[] messageDataElements;
        IConfigurationElement[] configurationDataElements;
        Object executable = element.createExecutableExtension(CLASS_ATTRIBUTE);
        if (executable instanceof IValidationRule) {
            this.rule = (IValidationRule)executable;
        }
        this.id = String.valueOf(element.getContributor().getName()) + "." + element.getAttribute(ID_ATTRIBUTE) + "-" + this.validatorId;
        this.name = element.getAttribute(NAME_ATTRIBUTE);
        this.description = element.getAttribute(DESCRIPTION_ATTRIBUTE);
        String enabledByDefault = element.getAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE);
        if (enabledByDefault != null) {
            this.setEnabledByDefault(Boolean.valueOf(enabledByDefault));
        } else {
            this.setEnabledByDefault(true);
        }
        this.propertyValues = new HashMap<String, String>();
        this.propertyDescriptions = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = configurationDataElements = element.getChildren(PROPERTY_ELEMENT);
        int n = configurationDataElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationDataElement = iConfigurationElementArray[n2];
            String propertyName = configurationDataElement.getAttribute(NAME_ATTRIBUTE);
            this.propertyValues.put(propertyName, configurationDataElement.getAttribute(VALUE_ATTRIBUTE));
            String desc = configurationDataElement.getAttribute(DESCRIPTION_ATTRIBUTE);
            if (StringUtils.hasText((String)desc)) {
                this.propertyDescriptions.put(propertyName, desc);
            }
            ++n2;
        }
        this.originalPropertyValues = new HashMap<String, String>(this.propertyValues);
        this.rulePropertiesInitialized = false;
        this.messageSeverities = new HashMap<String, Integer>();
        this.messageDescriptions = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray2 = messageDataElements = element.getChildren(MESSAGE_ELEMENT);
        int n3 = messageDataElements.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement messageDataElement = iConfigurationElementArray2[n];
            String messageId = messageDataElement.getAttribute(ID_ATTRIBUTE);
            String label = messageDataElement.getAttribute(LABEL_ATTRIBUTE);
            String severity = messageDataElement.getAttribute(SEVERITY_ATTRIBUTE);
            if ("ERROR".equals(severity)) {
                this.messageSeverities.put(messageId, 2);
            } else if ("WARNING".equals(severity)) {
                this.messageSeverities.put(messageId, 1);
            } else if ("INFO".equals(severity)) {
                this.messageSeverities.put(messageId, 0);
            } else {
                this.messageSeverities.put(messageId, -1);
            }
            this.messageDescriptions.put(messageId, label);
            ++n;
        }
        this.originalMessageSeverities = new HashMap<String, Integer>(this.messageSeverities);
    }

    public Map<String, String> getPropertyValues() {
        return new HashMap<String, String>(this.propertyValues);
    }

    public Map<String, Integer> getMessageSeverities() {
        return new HashMap<String, Integer>(this.messageSeverities);
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.rule.getClass().getName() + ")";
    }

    @Override
    public boolean isEnabled(IProject project) {
        this.readSpecificConfiguration(project);
        return super.isEnabled(project);
    }

    protected void readSpecificConfiguration(IProject project) {
        if (project != null && this.hasProjectSpecificOptions(project)) {
            String value;
            for (Map.Entry<String, String> entry : this.originalPropertyValues.entrySet()) {
                value = SpringCorePreferences.getProjectPreferences(project).getString(PROPERTY_PREFIX + entry.getKey(), entry.getValue());
                this.propertyValues.put(entry.getKey(), value);
            }
            for (Map.Entry<String, Object> entry : this.originalMessageSeverities.entrySet()) {
                value = SpringCorePreferences.getProjectPreferences(project).getString(MESSAGE_PREFIX + entry.getKey(), Integer.toString((Integer)entry.getValue()));
                this.messageSeverities.put(entry.getKey(), Integer.valueOf(value));
            }
        } else {
            String value;
            for (Map.Entry<String, String> entry : this.originalPropertyValues.entrySet()) {
                value = SpringCore.getDefault().getPluginPreferences().getString(PROPERTY_PREFIX + entry.getKey());
                if (!StringUtils.hasText((String)value)) continue;
                this.propertyValues.put(entry.getKey(), value);
            }
            for (Map.Entry<String, Object> entry : this.originalMessageSeverities.entrySet()) {
                value = SpringCore.getDefault().getPluginPreferences().getString(MESSAGE_PREFIX + entry.getKey());
                if (!StringUtils.hasText((String)value)) continue;
                this.messageSeverities.put(entry.getKey(), Integer.valueOf(value));
            }
        }
        this.rulePropertiesInitialized = false;
    }

    public void setSpecificConfiguration(Map<String, String> newPropertyValues, Map<String, Integer> newMessageSeverities, IProject project) {
        if (project != null && this.hasProjectSpecificOptions(project)) {
            for (Map.Entry<String, String> entry : newPropertyValues.entrySet()) {
                SpringCorePreferences.getProjectPreferences(project).putString(PROPERTY_PREFIX + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : newMessageSeverities.entrySet()) {
                SpringCorePreferences.getProjectPreferences(project).putString(MESSAGE_PREFIX + entry.getKey(), Integer.toString((Integer)entry.getValue()));
            }
        } else {
            for (Map.Entry<String, String> entry : newPropertyValues.entrySet()) {
                SpringCore.getDefault().getPluginPreferences().setValue(PROPERTY_PREFIX + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : newMessageSeverities.entrySet()) {
                SpringCore.getDefault().getPluginPreferences().setValue(MESSAGE_PREFIX + entry.getKey(), Integer.toString((Integer)entry.getValue()));
            }
        }
    }

    public String getPropertyDescription(String propertyName) {
        if (this.propertyDescriptions.containsKey(propertyName)) {
            return this.propertyDescriptions.get(propertyName);
        }
        return propertyName;
    }

    public String getMessageLabel(String messageId) {
        if (this.messageDescriptions.containsKey(messageId)) {
            return this.messageDescriptions.get(messageId);
        }
        return messageId;
    }
}

