/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.beans.ui.search.BeansSearchPlugin;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchMessages;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.AbstractBeansQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanChildQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanClassQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanNameQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanPropertyQuery;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanReferenceQuery;

public class BeansSearchPage
extends DialogPage
implements ISearchPage {
    public static final String EXTENSION_POINT_ID = "org.springframework.ide.eclipse.beans.ui.search.searchPage";
    public static final int SEARCH_FOR_BEAN_NAME = 0;
    public static final int SEARCH_FOR_BEAN_REFERENCE = 1;
    public static final int SEARCH_FOR_BEAN_CLASS = 2;
    public static final int SEARCH_FOR_BEAN_CHILD = 3;
    public static final int SEARCH_FOR_BEAN_PROPERTY = 4;
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "BeansSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_REG_EX_SEARCH = "REG_EX_SEARCH";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List<SearchData> previousSearchPatterns = new ArrayList<SearchData>();
    private boolean firstTime = true;
    private IDialogSettings dialogSettings;
    private boolean isCaseSensitive;
    private boolean isRegExSearch;
    private Combo expressionCombo;
    private ISearchPageContainer searchContainer;
    private Button regExCheckbox;
    private CLabel statusLabel;
    private Button caseSensitiveCheckbox;
    private Button[] searchForButtons;
    private String[] searchForText = new String[]{BeansSearchMessages.SearchPage_searchFor_name, BeansSearchMessages.SearchPage_searchFor_reference, BeansSearchMessages.SearchPage_searchFor_class, BeansSearchMessages.SearchPage_searchFor_child, BeansSearchMessages.SearchPage_searchFor_property};

    public BeansSearchPage() {
    }

    public BeansSearchPage(String title) {
        super(title);
    }

    public BeansSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = this.previousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = this.previousSearchPatterns.get(i).getPattern();
            ++i;
        }
        return patterns;
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.searchForButtons.length) {
            if (this.searchForButtons[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String getPattern() {
        return this.expressionCombo.getText();
    }

    private SearchData findInPrevious(String pattern) {
        for (SearchData element : this.previousSearchPatterns) {
            if (!pattern.equals(element.getPattern())) continue;
            return element;
        }
        return null;
    }

    private SearchData getPatternData() {
        String pattern = this.getPattern();
        SearchData match = this.findInPrevious(pattern);
        if (match != null) {
            this.previousSearchPatterns.remove(match);
        }
        match = new SearchData(this.getSearchFor(), pattern, this.caseSensitiveCheckbox.getSelection(), this.regExCheckbox.getSelection(), this.searchContainer.getSelectedScope(), this.searchContainer.getSelectedWorkingSets());
        this.previousSearchPatterns.add(0, match);
        return match;
    }

    public void setContainer(ISearchPageContainer container) {
        this.searchContainer = container;
    }

    public void setVisible(boolean visible) {
        if (visible && this.expressionCombo != null) {
            if (this.firstTime) {
                this.firstTime = false;
                this.expressionCombo.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.expressionCombo.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    public boolean performAction() {
        BeansSearchScope scope;
        SearchData data = this.getPatternData();
        switch (this.searchContainer.getSelectedScope()) {
            case 1: {
                scope = BeansSearchScope.newSearchScope(this.searchContainer.getSelection(), false);
                break;
            }
            case 2: {
                scope = BeansSearchScope.newSearchScope(this.searchContainer.getSelectedWorkingSets());
                break;
            }
            case 3: {
                scope = BeansSearchScope.newSearchScope(this.searchContainer.getSelection(), true);
                break;
            }
            default: {
                scope = BeansSearchScope.newSearchScope();
            }
        }
        AbstractBeansQuery query = null;
        switch (data.getSearchFor()) {
            case 0: {
                query = new BeanNameQuery(scope, data.getPattern(), data.isCaseSensitive(), data.isRegExp());
                break;
            }
            case 1: {
                query = new BeanReferenceQuery(scope, data.getPattern(), data.isCaseSensitive(), data.isRegExp());
                break;
            }
            case 2: {
                query = new BeanClassQuery(scope, data.getPattern(), this.isCaseSensitive, this.isRegExSearch);
                break;
            }
            case 3: {
                query = new BeanChildQuery(scope, data.getPattern(), this.isCaseSensitive, this.isRegExSearch);
                break;
            }
            case 4: {
                query = new BeanPropertyQuery(scope, data.getPattern(), this.isCaseSensitive, this.isRegExSearch);
            }
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground(query);
        return true;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = BeansSearchPlugin.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(PAGE_NAME);
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.isCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        this.isRegExSearch = s.getBoolean(STORE_REG_EX_SEARCH);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchData.create(histSettings)) != null) {
                    this.previousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.isCaseSensitive);
        s.put(STORE_REG_EX_SEARCH, this.isRegExSearch);
        int historySize = Math.min(this.previousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchData data = this.previousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expressionComposite = this.createExpression(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    private Control createExpression(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        Label label = new Label(group, 16384);
        label.setText(BeansSearchMessages.SearchPage_expression);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.expressionCombo = new Combo(group, 2052);
        this.expressionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeansSearchPage.this.handlePatternSelected();
                BeansSearchPage.this.updateOKStatus();
            }
        });
        this.expressionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeansSearchPage.this.doPatternModified();
                BeansSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.expressionCombo.setLayoutData((Object)data);
        this.caseSensitiveCheckbox = new Button(group, 32);
        this.caseSensitiveCheckbox.setText(BeansSearchMessages.SearchPage_caseSensitive);
        this.caseSensitiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeansSearchPage.this.isCaseSensitive = BeansSearchPage.this.caseSensitiveCheckbox.getSelection();
            }
        });
        this.caseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.statusLabel = new CLabel(group, 16384);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.statusLabel.setFont(group.getFont());
        this.statusLabel.setAlignment(16384);
        this.statusLabel.setText(BeansSearchMessages.SearchPage_expressionHint);
        this.regExCheckbox = new Button(group, 32);
        this.regExCheckbox.setText(BeansSearchMessages.SearchPage_regularExpression);
        this.regExCheckbox.setSelection(this.isRegExSearch);
        this.regExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeansSearchPage.this.isRegExSearch = BeansSearchPage.this.regExCheckbox.getSelection();
                BeansSearchPage.this.updateOKStatus();
                BeansSearchPage.this.writeConfiguration();
            }
        });
        this.regExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.regExCheckbox.setFont(group.getFont());
        return group;
    }

    final void updateOKStatus() {
        boolean isValid = this.isValidSearchPattern();
        this.searchContainer.setPerformActionEnabled(isValid);
    }

    private boolean isValidSearchPattern() {
        return this.getPattern().length() != 0;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private void doPatternModified() {
    }

    private void handlePatternSelected() {
        int selectionIndex = this.expressionCombo.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.previousSearchPatterns.size()) {
            return;
        }
        SearchData data = this.previousSearchPatterns.get(selectionIndex);
        this.setSearchFor(data.getSearchFor());
        this.expressionCombo.setText(data.getPattern());
        this.isCaseSensitive = data.isCaseSensitive();
        this.caseSensitiveCheckbox.setSelection(data.isCaseSensitive());
        this.regExCheckbox.setSelection(data.isRegExp());
        if (data.getWorkingSets() != null) {
            this.searchContainer.setSelectedWorkingSets(data.getWorkingSets());
        } else {
            this.searchContainer.setSelectedScope(data.getScope());
        }
    }

    private void setSearchFor(int searchFor) {
        int i = 0;
        while (i < this.searchForButtons.length) {
            this.searchForButtons[i].setSelection(searchFor == i);
            ++i;
        }
    }

    private Control createSearchFor(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(BeansSearchMessages.SearchPage_searchFor);
        group.setLayout((Layout)new GridLayout(2, true));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BeansSearchPage.this.doPatternModified();
            }
        };
        this.searchForButtons = new Button[this.searchForText.length];
        int i = 0;
        while (i < this.searchForText.length) {
            Button button = new Button((Composite)group, 16);
            button.setText(this.searchForText[i]);
            button.setSelection(i == 2);
            button.setLayoutData((Object)new GridData());
            button.addSelectionListener((SelectionListener)selectionListener);
            this.searchForButtons[i] = button;
            ++i;
        }
        return group;
    }

    private void initSelections() {
        SearchData initData = null;
        if (initData == null) {
            initData = this.getDefaultInitValues();
        }
        this.expressionCombo.setText(initData.getPattern());
        this.caseSensitiveCheckbox.setSelection(initData.isCaseSensitive());
        this.regExCheckbox.setSelection(initData.isRegExp());
        this.setSearchFor(initData.getSearchFor());
    }

    private SearchData getDefaultInitValues() {
        if (!this.previousSearchPatterns.isEmpty()) {
            return this.previousSearchPatterns.get(0);
        }
        return new SearchData(0, "", this.isCaseSensitive, false);
    }

    private static class SearchData {
        private int searchFor;
        private String pattern;
        private boolean isCaseSensitive;
        private boolean isRegExp;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchData(int searchFor, String pattern, boolean isCaseSensitive, boolean isRegExp) {
            this(searchFor, pattern, isCaseSensitive, isRegExp, 0, null);
        }

        public SearchData(int searchFor, String pattern, boolean isCaseSensitive, boolean isRegExp, int scope, IWorkingSet[] workingSets) {
            this.searchFor = searchFor;
            this.pattern = pattern;
            this.isCaseSensitive = isCaseSensitive;
            this.isRegExp = isRegExp;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public boolean isRegExp() {
            return this.isRegExp;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public int getScope() {
            return this.scope;
        }

        public void store(IDialogSettings settings) {
            settings.put("searchFor", this.searchFor);
            settings.put("pattern", this.pattern);
            settings.put("isCaseSensitive", this.isCaseSensitive);
            settings.put("isRegExp", this.isRegExp);
            settings.put("scope", this.scope);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getId();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }

        public static SearchData create(IDialogSettings settings) {
            String pattern = settings.get("pattern");
            if (pattern.length() == 0) {
                return null;
            }
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            try {
                int searchFor = settings.getInt("searchFor");
                int scope = settings.getInt("scope");
                boolean isCaseSensitive = settings.getBoolean("isCaseSensitive");
                boolean isRegExp = settings.getBoolean("isRegExp");
                return new SearchData(searchFor, pattern, isCaseSensitive, isRegExp, scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

