/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.ISVNResourceVisitor;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.AddIgnoredPatternCommand;
import org.tigris.subversion.subclipse.core.resources.BaseFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResource;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;

public class LocalFolder
extends LocalResource
implements ISVNLocalFolder {
    public LocalFolder(IContainer container) {
        super((IResource)container);
    }

    public ISVNRemoteResource getBaseResource() throws SVNException {
        if (!this.isManaged()) {
            return null;
        }
        return new BaseFolder(this.resource, this.getStatusFromCache());
    }

    public ISVNResource[] members(IProgressMonitor monitor, int flags) throws SVNException {
        IResource[] resources;
        if (!this.resource.exists()) {
            return new ISVNLocalResource[0];
        }
        boolean ignoreHiddenChanges = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_hidden_changes");
        ArrayList<ISVNLocalResource> result = new ArrayList<ISVNLocalResource>();
        try {
            boolean isHiddenSupported = true;
            if (!ignoreHiddenChanges) {
                try {
                    isHiddenSupported = Util.isHiddenSupported();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    isHiddenSupported = false;
                }
            }
            resources = ignoreHiddenChanges || !isHiddenSupported ? ((IContainer)this.resource).members(true) : ((IContainer)this.resource).members(9);
        }
        catch (CoreException e) {
            throw SVNException.wrapException(e);
        }
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        boolean includeUnmanaged = (flags & 8) != 0 || (flags & 0x1C) == 0;
        boolean includeIgnored = (flags & 4) != 0;
        boolean includeExisting = (flags & 0x20) != 0 || (flags & 0x60) == 0;
        boolean includePhantoms = (flags & 0x40) != 0 || (flags & 0x60) == 0;
        int i = 0;
        while (i < resources.length) {
            if (includeFiles && resources[i].getType() == 1 || includeFolders && resources[i].getType() == 2) {
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resources[i]);
                boolean isManaged = svnResource.isManaged();
                boolean isIgnored = svnResource.isIgnored();
                if (isManaged && includeManaged || isIgnored && includeIgnored || !isManaged && !isIgnored && includeUnmanaged) {
                    boolean exists = svnResource.exists();
                    if ((includeExisting && exists || includePhantoms && !exists) && (!ignoreHiddenChanges || !Util.isHidden(resources[i], false))) {
                        result.add(svnResource);
                    }
                }
            }
            ++i;
        }
        return result.toArray(new ISVNLocalResource[result.size()]);
    }

    public boolean isFolder() {
        return true;
    }

    public void refreshStatus() throws SVNException {
        this.refreshStatus(false);
    }

    public void refreshStatus(boolean recursive) throws SVNException {
        SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus((IResource)((IContainer)this.resource), recursive);
    }

    public boolean isDirty() throws SVNException {
        if (this.getStatusFromCache().isDirty()) {
            return true;
        }
        ISVNLocalResource[] children = (ISVNLocalResource[])this.members((IProgressMonitor)new NullProgressMonitor(), 123);
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirty() || children[i].getStatusFromCache().isMissing() || children[i].exists() && !children[i].isManaged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void acceptChildren(ISVNResourceVisitor visitor) throws SVNException {
        ISVNLocalResource[] subFiles = (ISVNLocalResource[])this.members(null, 1);
        int i = 0;
        while (i < subFiles.length) {
            subFiles[i].accept(visitor);
            ++i;
        }
        ISVNLocalResource[] subFolders = (ISVNLocalResource[])this.members(null, 2);
        int i2 = 0;
        while (i2 < subFolders.length) {
            subFolders[i2].accept(visitor);
            ++i2;
        }
    }

    public void accept(ISVNResourceVisitor visitor) throws SVNException {
        visitor.visitFolder(this);
    }

    public IFolder[] getSVNFolders(IProgressMonitor monitor, final boolean unmanage) throws SVNException {
        final ArrayList svnFolders = new ArrayList();
        SVNProviderPlugin.run(new ISVNRunnable(){

            public void run(IProgressMonitor pm) throws SVNException {
                pm = Policy.monitorFor(pm);
                pm.beginTask(null, 100);
                ISVNResource[] members = LocalFolder.this.members(Policy.subMonitorFor(pm, 20), 18);
                ArrayList<IContainer> dirs = new ArrayList<IContainer>();
                ISVNResource[] iSVNResourceArray = members;
                int n = 0;
                int n2 = iSVNResourceArray.length;
                while (n < n2) {
                    ISVNResource member = iSVNResourceArray[n];
                    dirs.add((IContainer)((ISVNLocalResource)member).getIResource());
                    ++n;
                }
                dirs.add((IContainer)LocalFolder.this.getIResource());
                IProgressMonitor monitorDel = Policy.subMonitorFor(pm, 80);
                monitorDel.beginTask(null, dirs.size());
                for (IContainer container : dirs) {
                    monitorDel.worked(1);
                    this.recursiveGetSVNFolders(container, monitorDel, unmanage);
                }
                monitorDel.done();
                pm.done();
            }

            private void recursiveGetSVNFolders(IContainer container, IProgressMonitor pm, boolean unmanage2) {
                block11: {
                    block10: {
                        if (!container.isLinked()) break block10;
                        pm.done();
                        return;
                    }
                    try {
                        try {
                            IResource[] members;
                            pm.beginTask(null, 10);
                            pm.subTask(container.getFullPath().toOSString());
                            IResource[] iResourceArray = members = container.members(true);
                            int n = 0;
                            int n2 = iResourceArray.length;
                            while (n < n2) {
                                IResource member = iResourceArray[n];
                                pm.worked(1);
                                if (member.getType() != 1) {
                                    this.recursiveGetSVNFolders((IContainer)member, pm, unmanage2);
                                }
                                ++n;
                            }
                            IFolder svnFolder = container.getFolder((IPath)new Path(SVNProviderPlugin.getPlugin().getAdminDirectoryName()));
                            if (!svnFolder.exists()) break block11;
                            svnFolders.add(svnFolder);
                            if (!unmanage2) break block11;
                            try {
                                svnFolder.delete(true, null);
                            }
                            catch (CoreException coreException) {
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        pm.done();
                    }
                }
            }
        }, Policy.subMonitorFor(monitor, 99));
        IFolder[] folderArray = new IFolder[svnFolders.size()];
        svnFolders.toArray(folderArray);
        return folderArray;
    }

    public void unmanage(IProgressMonitor monitor) throws SVNException {
        this.getSVNFolders(monitor, true);
    }

    public void setIgnoredAs(String pattern) throws SVNException {
        AddIgnoredPatternCommand command = new AddIgnoredPatternCommand(this, pattern);
        command.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void revert() throws SVNException {
        super.revert(true);
    }

    public void resolve() {
    }

    public LocalResourceStatus getStatus() throws SVNException {
        if (this.getIResource().isTeamPrivateMember() && SVNProviderPlugin.getPlugin().isAdminDirectory(this.getIResource().getName())) {
            return LocalResourceStatus.NONE;
        }
        if (this.getIResource() instanceof IWorkspaceRoot) {
            return LocalResourceStatus.NONE;
        }
        return super.getStatus();
    }

    public LocalResourceStatus getStatusFromCache() throws SVNException {
        if (this.getIResource().isTeamPrivateMember() && SVNProviderPlugin.getPlugin().isAdminDirectory(this.getIResource().getName())) {
            return LocalResourceStatus.NONE;
        }
        if (this.getIResource() instanceof IWorkspaceRoot) {
            return LocalResourceStatus.NONE;
        }
        return super.getStatusFromCache();
    }
}

