/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class UpdateResourcesCommand
implements ISVNCommand {
    private SVNWorkspaceRoot root;
    private IResource[] resources;
    private SVNRevision revision;
    private int depth = 0;
    private boolean setDepth = false;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private Set<IResource> updatedResources = new LinkedHashSet<IResource>();
    private ISVNConflictResolver conflictResolver;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public UpdateResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, SVNRevision revision) {
        this.root = root;
        this.resources = resources;
        this.revision = revision;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        if (this.conflictResolver != null) {
            svnClient.addConflictResolutionCallback(this.conflictResolver);
        }
        try {
            try {
                monitor.beginTask(null, 100 * this.resources.length);
                svnClient.addNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(monitor, svnClient));
                if (this.resources.length == 1) {
                    monitor.subTask(this.resources[0].getName());
                    svnClient.update(this.resources[0].getLocation().toFile(), this.revision, this.depth, this.setDepth, this.ignoreExternals, this.force);
                    this.updatedResources.add(this.resources[0]);
                    monitor.worked(100);
                } else {
                    File[] files = new File[this.resources.length];
                    int i = 0;
                    while (i < this.resources.length) {
                        files[i] = this.resources[i].getLocation().toFile();
                        this.updatedResources.add(this.resources[i]);
                        ++i;
                    }
                    svnClient.update(files, this.revision, this.depth, this.setDepth, this.ignoreExternals, this.force);
                    monitor.worked(100);
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            Set<IResource> operationResources = this.operationResourceCollector.getOperationResources();
            OperationManager.getInstance().endOperation(true, operationResources);
            if (this.conflictResolver != null) {
                svnClient.addConflictResolutionCallback(null);
            }
            svnClient.removeNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
            this.root.getRepository().returnSVNClient(svnClient);
            monitor.done();
        }
    }

    public void setConflictResolver(ISVNConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

