/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import tern.server.protocol.TernFile;
import tern.server.protocol.TernQuery;

public class TernDoc
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private static final String FILES_FIELD_NAME = "files";
    private static final String QUERY_FIELD_NAME = "query";

    public TernDoc() {
        this(null);
    }

    public TernDoc(TernQuery query) {
        this.setQuery(query);
    }

    public void setQuery(TernQuery query) {
        if (query != null) {
            super.set(QUERY_FIELD_NAME, (JsonValue)query);
        } else {
            super.remove(QUERY_FIELD_NAME);
        }
    }

    public TernQuery getQuery() {
        return (TernQuery)super.get(QUERY_FIELD_NAME);
    }

    public void addFile(String name, String text, boolean isHTML, Integer offset) {
        this.addFile(new TernFile(name, text, isHTML, offset));
    }

    public void addFile(TernFile file) {
        this.getFiles().add((JsonValue)file);
    }

    public JsonArray getFiles() {
        JsonArray files = (JsonArray)super.get(FILES_FIELD_NAME);
        if (files == null) {
            files = new JsonArray();
            super.add(FILES_FIELD_NAME, (JsonValue)files);
        }
        return files;
    }

    public boolean hasFiles() {
        JsonArray files = (JsonArray)super.get(FILES_FIELD_NAME);
        return files != null && files.size() > 0;
    }

    public void cleanFiles() {
        super.remove(FILES_FIELD_NAME);
    }
}

