/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataManager;
import tern.server.ITernDef;
import tern.server.ModuleType;

public enum TernDef implements ITernDef
{
    browser("tern/defs/browser.json"),
    chai("tern/defs/chai.json"),
    ecma5("tern/defs/ecma5.json"),
    jquery("tern/defs/jquery.json"),
    underscore("tern/defs/underscore.json");

    private final String name;
    private final String type;
    private final String version;
    private final String path;
    private TernModuleMetadata metadata;

    private TernDef(String path) {
        this(null, null, null, path);
    }

    private TernDef(String name, String type, String version, String path) {
        this.name = name != null ? name : this.name();
        this.type = type != null ? type : this.name();
        this.version = version;
        this.path = path;
        this.metadata = null;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.name();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ModuleType getModuleType() {
        return ModuleType.Def;
    }

    public static ITernDef getTernDef(String name) {
        TernDef[] defs = TernDef.values();
        TernDef def = null;
        int i = 0;
        while (i < defs.length) {
            def = defs[i];
            if (def.getName().equals(name)) {
                return def;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TernModuleMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = TernModuleMetadataManager.getInstance().getMetadata(this.getType());
        }
        return this.metadata;
    }
}

