/*
 * Decompiled with CFR 0.152.
 */
package tern.angular.protocol;

import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import tern.angular.AngularType;
import tern.angular.modules.Directive;
import tern.angular.modules.IDirectiveProvider;
import tern.angular.protocol.TernAngularQuery;
import tern.angular.protocol.TernAngularScope;

public class HTMLTernAngularHelper {
    public static void populateScope(Node element, IDirectiveProvider provider, Object project, TernAngularQuery query) {
        TernAngularScope scope = query.getScope();
        HTMLTernAngularHelper.populateScope(element, scope, provider, project, query.getFirstAngularType());
    }

    public static void populateScope(Node element, TernAngularScope scope, IDirectiveProvider provider, Object project, AngularType angularType) {
        switch (angularType) {
            case module: {
                break;
            }
            case controller: {
                HTMLTernAngularHelper.populateScope(scope, element, provider, project, false);
                break;
            }
            case directive: 
            case model: 
            case repeat_expression: 
            case unknown: {
                HTMLTernAngularHelper.populateScope(scope, element, provider, project, true);
            }
        }
    }

    private static void populateScope(TernAngularScope scope, Node element, IDirectiveProvider provider, Object project, boolean populateController) {
        Node parent;
        if (element == null || element.getNodeType() == 9) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            Attr node = null;
            int i = 0;
            while (i < attributes.getLength()) {
                node = (Attr)attributes.item(i);
                Directive directive = provider.getAngularDirective(project, node);
                if (directive != null) {
                    switch (directive.getType()) {
                        case module: {
                            String module = node.getValue();
                            scope.setModule(module);
                            return;
                        }
                        case controller: {
                            if (!populateController) break;
                            String controller = node.getValue();
                            scope.addController(controller);
                            break;
                        }
                        case model: {
                            String model = node.getValue();
                            scope.addModel(model);
                            break;
                        }
                        case repeat_expression: {
                            String expression = node.getValue();
                            scope.addRepeat(expression);
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        if ((parent = element.getPreviousSibling()) == null) {
            parent = element.getParentNode();
        }
        HTMLTernAngularHelper.populateScope(scope, parent, provider, project, populateController);
    }
}

