/*
 * Decompiled with CFR 0.152.
 */
package tern;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import tern.DirtyableJsonArray;
import tern.DirtyableJsonObject;
import tern.ITernProject;
import tern.TernFileManager;
import tern.server.ITernDef;
import tern.server.ITernPlugin;
import tern.server.protocol.JsonHelper;
import tern.utils.IOUtils;

public class TernProject<T>
extends DirtyableJsonObject
implements ITernProject<T> {
    private static final long serialVersionUID = 1L;
    public static final String TERN_PROJECT = ".tern-project";
    private static final String PLUGINS_FIELD_NAME = "plugins";
    private static final String LIBS_FIELD_NAME = "libs";
    private final File projectDir;
    private DirtyableJsonArray patterns;
    private boolean dirty;
    private TernFileManager<T> fileManager;

    public TernProject(File projectDir) {
        super(null);
        this.projectDir = projectDir;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public void addLib(ITernDef lib) {
        this.addLib(lib.getName());
    }

    @Override
    public void addLib(String lib) {
        if (!this.hasLib(lib)) {
            this.getLibs().add(lib);
        }
    }

    @Override
    public boolean hasLib(String lib) {
        JsonArray libs = this.getLibs();
        if (libs != null) {
            for (JsonValue l : libs) {
                if (!l.isString() || !l.asString().equals(lib)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasLib(ITernDef lib) {
        return this.hasLib(lib.getName());
    }

    @Override
    public JsonArray getLibs() {
        JsonArray libs = (JsonArray)super.get(LIBS_FIELD_NAME);
        if (!(libs instanceof DirtyableJsonArray)) {
            if (libs == null) {
                libs = new DirtyableJsonArray(this);
                this.add(LIBS_FIELD_NAME, (JsonValue)libs);
            } else {
                libs = new DirtyableJsonArray(libs, this);
                this.set(LIBS_FIELD_NAME, (JsonValue)libs);
            }
        }
        return libs;
    }

    @Override
    public void clearLibs() {
        this.remove(LIBS_FIELD_NAME);
    }

    @Override
    public void addPlugin(ITernPlugin plugin) {
        this.addPlugin(plugin, null);
    }

    @Override
    public void addPlugin(ITernPlugin plugin, JsonObject options) {
        JsonObject plugins = this.getPlugins();
        if (options == null) {
            options = new JsonObject();
        }
        if (!this.hasPlugin(plugin)) {
            plugins.add(plugin.getName(), (JsonValue)options);
        } else if (!JsonHelper.isSameJson(plugins.get(plugin.getName()), options)) {
            plugins.set(plugin.getName(), (JsonValue)options);
        }
    }

    @Override
    public boolean hasPlugin(ITernPlugin plugin) {
        return this.hasPlugin(plugin.getName());
    }

    @Override
    public boolean hasPlugin(String plugin) {
        JsonObject plugins = (JsonObject)super.get(PLUGINS_FIELD_NAME);
        return plugins == null ? false : plugins.get(plugin) != null;
    }

    @Override
    public JsonObject getPlugins() {
        JsonObject plugins = (JsonObject)super.get(PLUGINS_FIELD_NAME);
        if (!(plugins instanceof DirtyableJsonObject)) {
            if (plugins == null) {
                plugins = new DirtyableJsonObject(this);
                this.add(PLUGINS_FIELD_NAME, (JsonValue)plugins);
            } else {
                plugins = new DirtyableJsonObject(plugins, this);
                this.set(PLUGINS_FIELD_NAME, (JsonValue)plugins);
            }
        }
        return plugins;
    }

    @Override
    public void clearPlugins() {
        this.remove(PLUGINS_FIELD_NAME);
    }

    public void addLoadEagerlyPattern(String pattern) {
        if (this.patterns == null) {
            this.patterns = new DirtyableJsonArray(this);
            this.add("loadEagerly", (JsonValue)this.patterns);
        }
        this.patterns.add(pattern);
    }

    @Override
    public void save() throws IOException {
        this.projectDir.mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(this.projectDir, TERN_PROJECT));
            super.writeTo((Writer)writer);
        }
        catch (Throwable throwable) {
            if (writer != null) {
                IOUtils.closeQuietly(writer);
            }
            throw throwable;
        }
        if (writer != null) {
            IOUtils.closeQuietly(writer);
        }
        this.dirty = false;
    }

    @Override
    public void saveIfNeeded() throws IOException {
        if (this.isDirty()) {
            this.save();
        }
    }

    public void load() throws IOException {
        File file = new File(this.projectDir, TERN_PROJECT);
        if (file.exists()) {
            try {
                JsonHelper.readFrom(new FileReader(file), this);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        this.dirty = false;
    }

    public void setFileManager(TernFileManager<T> fileManager) {
        this.fileManager = fileManager;
    }

    @Override
    public TernFileManager<T> getFileManager() {
        return this.fileManager;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

