/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.matcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherContentProvider;
import org.springframework.ide.eclipse.aop.ui.matcher.internal.PointcutMatcherLabelProvider;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class PointcutMatcherResultPage
extends AbstractTextSearchViewPage {
    private PointcutMatcherContentProvider provider;

    public PointcutMatcherResultPage() {
        this.setID(PointcutMatcherResultPage.class.getName());
    }

    protected void clear() {
        this.provider.clear();
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new PointcutMatcherLabelProvider(this));
        viewer.setContentProvider((IContentProvider)this.getContentProvider());
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new PointcutMatcherLabelProvider(this));
        viewer.setContentProvider((IContentProvider)this.getContentProvider());
    }

    protected void elementsChanged(Object[] objects) {
        if (this.provider != null) {
            this.provider.elementsChanged(objects);
        }
    }

    private PointcutMatcherContentProvider getContentProvider() {
        if (this.provider == null) {
            this.provider = new PointcutMatcherContentProvider(this);
        }
        return this.provider;
    }

    protected void handleOpen(OpenEvent event) {
        Viewer viewer = event.getViewer();
        ISelection sel = event.getSelection();
        if (viewer instanceof TreeViewer && sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Object element = selection.getFirstElement();
            if (this.getDisplayedMatches(element).length != 0) {
                super.handleOpen(event);
            } else {
                this.showElement(true, element);
            }
        }
    }

    private void showElement(boolean activate, Object element) {
        if (element instanceof IAopReference) {
            SpringUIUtils.openInEditor((IJavaElement)((IAopReference)element).getTarget());
        } else if (element instanceof IResourceModelElement) {
            BeansUIUtils.openInEditor((IResourceModelElement)((IResourceModelElement)element), (boolean)activate);
        } else if (element instanceof IFile) {
            SpringUIUtils.openInEditor((IFile)((IFile)element), (int)1, (boolean)activate);
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        Object element = match.getElement();
        this.showElement(activate, element);
    }
}

