/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.util;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.IndexedString;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.util.AbstractCellPainterBuilder;
import net.sourceforge.pmd.eclipse.util.FontBuilder;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class StyledTextBuilder
extends AbstractCellPainterBuilder {
    private Display display = Display.getCurrent();
    private TextLayout layout = new TextLayout((Device)this.display);
    private final TextStyle style;

    public StyledTextBuilder(FontBuilder theBuilder) {
        this.style = theBuilder.style(this.display);
    }

    private Font adjust(TreeItem tItem, RuleFieldAccessor getter, Tree tree) {
        Object value = this.valueFor(tItem, getter);
        IndexedString is = (IndexedString)value;
        String text = value == null ? "" : is.string;
        Rule rule = this.ruleFrom(tItem);
        if (rule != null) {
            this.style.font = this.fontFor((Control)tree, rule);
        }
        this.layout.setText(text);
        if (StringUtil.isEmpty((String)text)) {
            this.layout.setStyle(this.style, 0, 0);
        } else {
            int i = 0;
            while (i < is.indexSpans.size()) {
                this.layout.setStyle(this.style, is.indexSpans.get(i)[0], is.indexSpans.get(i)[1] - 1);
                ++i;
            }
        }
        return this.style.font;
    }

    @Override
    public void addPainterFor(final Tree tree, final int columnIndex, final RuleFieldAccessor getter, Map<Integer, List<Listener>> listenersByEventCode) {
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.index != columnIndex) {
                    return;
                }
                Font font = StyledTextBuilder.this.adjust((TreeItem)event.item, getter, tree);
                event.gc.setFont(font);
                StyledTextBuilder.this.layout.setFont(font);
                int descent = event.gc.getFontMetrics().getDescent();
                StyledTextBuilder.this.layout.draw(event.gc, event.x, event.y + descent);
            }
        };
        Listener measureListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.index != columnIndex) {
                    return;
                }
                StyledTextBuilder.this.adjust((TreeItem)event.item, getter, tree);
                Rectangle textLayoutBounds = StyledTextBuilder.this.layout.getBounds();
                event.width = textLayoutBounds.width + 2;
                event.height = textLayoutBounds.height + 2;
            }
        };
        StyledTextBuilder.addListener((Control)tree, 42, paintListener, listenersByEventCode);
        StyledTextBuilder.addListener((Control)tree, 41, measureListener, listenersByEventCode);
    }
}

