/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CPDViewLabelProvider2
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        TreeNode node = (TreeNode)element;
        Object value = node.getValue();
        switch (columnIndex) {
            case 0: {
                if (value instanceof Match || !(value instanceof TokenEntry)) break;
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER");
            }
        }
        return image;
    }

    private int lineCountFor(TreeNode node) {
        Object source = node.getValue();
        if (source instanceof Match) {
            return node.getChildren().length;
        }
        return -1;
    }

    public static String pathFor(TokenEntry entry) {
        IPath path = Path.fromOSString((String)entry.getTokenSrcID());
        IContainer resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
        if (resource != null) {
            return resource.getProjectRelativePath().removeFileExtension().toString().replace('/', '.');
        }
        return "?";
    }

    public static TokenEntry[] entriesFor(Match match) {
        Set entrySet = match.getMarkSet();
        Object[] entries = new TokenEntry[entrySet.size()];
        entries = entrySet.toArray(entries);
        Arrays.sort(entries);
        return entries;
    }

    public static String[] sourcesFor(Match match) {
        TokenEntry[] entries = CPDViewLabelProvider2.entriesFor(match);
        String[] classNames = new String[entries.length];
        int i = 0;
        TokenEntry[] tokenEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            TokenEntry entry = tokenEntryArray[n2];
            classNames[i++] = CPDViewLabelProvider2.pathFor(entry);
            ++n2;
        }
        return classNames;
    }

    public static Map<String, TokenEntry> entriesByClassnameFor(Match match) {
        TokenEntry[] entries = CPDViewLabelProvider2.entriesFor(match);
        HashMap<String, TokenEntry> entriesByName = new HashMap<String, TokenEntry>(entries.length);
        TokenEntry[] tokenEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            TokenEntry entry = tokenEntryArray[n2];
            entriesByName.put(CPDViewLabelProvider2.pathFor(entry), entry);
            ++n2;
        }
        return entriesByName;
    }

    public String getColumnText(Object element, int columnIndex) {
        TreeNode node = (TreeNode)element;
        Object value = node.getValue();
        String result = "";
        switch (columnIndex) {
            case 0: {
                int count = this.lineCountFor(node);
                if (count <= 0) break;
                result = Integer.toString(count);
                break;
            }
            case 1: {
                if (value instanceof String && (result = String.valueOf(value)).endsWith("\r")) {
                    result = result.substring(0, result.length() - 1);
                }
                boolean cfr_ignored_0 = value instanceof Match;
            }
        }
        return result;
    }
}

