/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTUtil;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.Comment;

public class NodeImageDeriver {
    public final Class<?> target;
    private static NodeImageDeriver compilationUnitDeriver = new NodeImageDeriver((Class)ASTCompilationUnit.class){

        @Override
        public String deriveFrom(Node node) {
            NodeImageDeriver.dumpComments((ASTCompilationUnit)node);
            return "Comments: " + ((ASTCompilationUnit)node).getComments().size();
        }
    };
    private static NodeImageDeriver importDeriver = new NodeImageDeriver((Class)ASTImportDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ((ASTImportDeclaration)node).getImportedName();
        }
    };
    private static NodeImageDeriver methodDeclarationDeriver = new NodeImageDeriver((Class)ASTMethodDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getMethodLabel((ASTMethodDeclaration)node, true);
        }
    };
    private static NodeImageDeriver throwStatementDeriver = new NodeImageDeriver((Class)ASTThrowStatement.class){

        @Override
        public String deriveFrom(Node node) {
            return ((ASTThrowStatement)node).getFirstClassOrInterfaceTypeImage();
        }
    };
    private static NodeImageDeriver fieldDeclarationDeriver = new NodeImageDeriver((Class)ASTFieldDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getFieldLabel((ASTFieldDeclaration)node);
        }
    };
    private static NodeImageDeriver localVariableDeclarationDeriver = new NodeImageDeriver((Class)ASTLocalVariableDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getLocalVarDeclarationLabel((ASTLocalVariableDeclaration)node);
        }
    };
    private static NodeImageDeriver annotationDeriver = new NodeImageDeriver((Class)ASTAnnotation.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getAnnotationLabel((ASTAnnotation)node);
        }
    };
    private static final NodeImageDeriver[] AllDerivers = new NodeImageDeriver[]{importDeriver, methodDeclarationDeriver, localVariableDeclarationDeriver, fieldDeclarationDeriver, annotationDeriver, compilationUnitDeriver, throwStatementDeriver};
    private static final Map<Class<?>, NodeImageDeriver> DeriversByType = new HashMap(AllDerivers.length);

    static {
        NodeImageDeriver[] nodeImageDeriverArray = AllDerivers;
        int n = AllDerivers.length;
        int n2 = 0;
        while (n2 < n) {
            NodeImageDeriver deriver = nodeImageDeriverArray[n2];
            DeriversByType.put(deriver.target, deriver);
            ++n2;
        }
    }

    public NodeImageDeriver(Class<?> theASTClass) {
        this.target = theASTClass;
    }

    public String deriveFrom(Node node) {
        return null;
    }

    private static void dumpComments(ASTCompilationUnit node) {
        for (Comment comment : node.getComments()) {
            System.out.println(comment.getClass().getName());
            System.out.println(comment.getImage());
        }
    }

    public static String derivedTextFor(Node node) {
        NodeImageDeriver deriver = DeriversByType.get(node.getClass());
        return deriver == null ? null : deriver.deriveFrom(node);
    }
}

