/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractViolationSelectionAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TableViewer;

public class RemoveViolationAction
extends AbstractViolationSelectionAction {
    public RemoveViolationAction(TableViewer viewer) {
        super(viewer);
    }

    @Override
    protected String textId() {
        return "view.action.remove_violation";
    }

    @Override
    protected String imageId() {
        return "icons/btn_remvio.gif";
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.remove_violation";
    }

    public void run() {
        final IMarker[] markers = this.getSelectedViolations();
        if (markers == null) {
            return;
        }
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        marker.delete();
                        ++n2;
                    }
                }
            }, null);
        }
        catch (CoreException ce) {
            RemoveViolationAction.logErrorByKey("message.error.core_exception", ce);
        }
    }
}

