/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.preferences.br.EditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.BooleanEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.CharacterEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.DoubleEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.EnumerationEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.FileEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.FloatEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.IntegerEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MethodEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MultiEnumerationEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MultiIntegerEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MultiMethodEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MultiStringEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.MultiTypeEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.StringEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.TypeEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.Configuration;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.FormArranger;
import net.sourceforge.pmd.lang.rule.XPathRule;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PerRulePropertyPanelManager
extends AbstractRulePanelManager
implements SizeChangeListener {
    private FormArranger formArranger;
    private Composite composite;
    private ScrolledComposite sComposite;
    private int widgetRowCount;
    private List<String> unreferencedVariables;
    private static final int MaxWidgetHeight = 30;
    public static final String ID = "perRuleProperties";
    public static final Map<Class<?>, EditorFactory> editorFactoriesByPropertyType;

    static {
        HashMap<Class<File>, AbstractEditorFactory> factoriesByPropertyType = new HashMap<Class<File>, AbstractEditorFactory>();
        factoriesByPropertyType.put(Boolean.class, BooleanEditorFactory.instance);
        factoriesByPropertyType.put(String.class, StringEditorFactory.instance);
        factoriesByPropertyType.put(Integer.class, IntegerEditorFactory.instance);
        factoriesByPropertyType.put(Float.class, FloatEditorFactory.instance);
        factoriesByPropertyType.put(Double.class, DoubleEditorFactory.instance);
        factoriesByPropertyType.put(Object.class, EnumerationEditorFactory.instance);
        factoriesByPropertyType.put(Character.class, CharacterEditorFactory.instance);
        factoriesByPropertyType.put(Class.class, TypeEditorFactory.instance);
        factoriesByPropertyType.put(Class[].class, MultiTypeEditorFactory.instance);
        factoriesByPropertyType.put(Method.class, MethodEditorFactory.instance);
        factoriesByPropertyType.put(Method[].class, MultiMethodEditorFactory.instance);
        factoriesByPropertyType.put(String[].class, MultiStringEditorFactory.instance);
        factoriesByPropertyType.put(Integer[].class, MultiIntegerEditorFactory.instance);
        factoriesByPropertyType.put(Object[].class, MultiEnumerationEditorFactory.instance);
        factoriesByPropertyType.put(File.class, FileEditorFactory.instance);
        editorFactoriesByPropertyType = Collections.unmodifiableMap(factoriesByPropertyType);
    }

    public PerRulePropertyPanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(ID, theTitle, theMode, theListener);
    }

    @Override
    protected boolean canManageMultipleRules() {
        return false;
    }

    @Override
    protected boolean canWorkWith(Rule rule) {
        for (PropertyDescriptor desc : rule.getPropertyDescriptors()) {
            if (!desc.equals(XPathRule.XPATH_DESCRIPTOR)) continue;
            return true;
        }
        return !Configuration.filteredPropertiesOf((PropertySource)rule).isEmpty();
    }

    @Override
    protected void clearControls() {
        this.formArranger.clearChildren();
    }

    @Override
    public void loadValues() {
        this.formArranger.loadValues();
    }

    @Override
    public void showControls(boolean flag) {
        this.clearControls();
    }

    private ValueChangeListener chainedListener() {
        return FormArranger.chain(this.changeListener, new ValueChangeListener(){

            @Override
            public void changed(RuleSelection rule, PropertyDescriptor<?> desc, Object newValue) {
                PerRulePropertyPanelManager.this.updateUI();
            }

            @Override
            public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
                PerRulePropertyPanelManager.this.updateUI();
            }
        });
    }

    @Override
    public Control setupOn(Composite parent) {
        this.sComposite = new ScrolledComposite(parent, 2816);
        this.composite = new Composite((Composite)this.sComposite, 0);
        this.sComposite.setContent((Control)this.composite);
        this.sComposite.setExpandHorizontal(true);
        this.sComposite.setExpandVertical(true);
        this.formArranger = new FormArranger(this.composite, editorFactoriesByPropertyType, this.chainedListener(), this);
        return this.sComposite;
    }

    @Override
    public void addedRows(int rowCountDelta) {
        this.widgetRowCount += rowCountDelta;
        this.adjustMinimumHeight();
    }

    private void adjustMinimumHeight() {
        this.sComposite.setMinSize(this.composite.computeSize(500, this.widgetRowCount * 30));
    }

    @Override
    protected void adapt() {
        this.widgetRowCount = this.formArranger.arrangeFor((PropertySource)this.soleRule());
        this.validate();
        if (this.widgetRowCount < 0) {
            return;
        }
        this.adjustMinimumHeight();
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        this.unreferencedVariables = this.formArranger.updateDeleteButtons();
        return true;
    }

    @Override
    protected List<String> fieldWarnings() {
        String dysfunctionReason;
        Rule soleRule;
        ArrayList<String> warnings = new ArrayList<String>(2);
        if (this.rules != null && !this.canManageMultipleRules() && (soleRule = this.soleRule()) != null && (dysfunctionReason = soleRule.dysfunctionReason()) != null) {
            warnings.add(dysfunctionReason);
        }
        if (this.unreferencedVariables == null || this.unreferencedVariables.isEmpty()) {
            return warnings;
        }
        warnings.add("Unreferences variables: " + this.unreferencedVariables);
        return warnings;
    }
}

