/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class StringEditorFactory
extends AbstractEditorFactory {
    public static final StringEditorFactory instance = new StringEditorFactory();

    protected StringEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return new StringProperty(name, description, otherData == null ? "" : (String)this.valueFrom(otherData[1]), 0.0f);
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return ((Text)valueControl).getText();
    }

    protected void fillWidget(Text textWidget, PropertyDescriptor<?> desc, PropertySource source) {
        String val = (String)this.valueFor(source, desc);
        textWidget.setText(val == null ? "" : val);
        this.adjustRendering(source, desc, (Control)textWidget);
    }

    private static StringProperty stringPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (StringProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (StringProperty)desc;
    }

    private void setValue(PropertySource source, StringProperty desc, String value) {
        if (!source.hasDescriptor((PropertyDescriptor)desc)) {
            return;
        }
        source.setProperty((PropertyDescriptor)desc, (Object)value);
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        this.fillWidget(text, desc, source);
        final StringProperty sp = StringEditorFactory.stringPropertyFrom(desc);
        text.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                String newValue = text.getText().trim();
                String existingValue = (String)StringEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)sp);
                if (StringUtil.areSemanticEquals((String)existingValue, (String)newValue)) {
                    return;
                }
                StringEditorFactory.this.setValue(source, sp, newValue);
                StringEditorFactory.this.fillWidget(text, desc, source);
                listener.changed(source, desc, (Object)newValue);
            }
        });
        return text;
    }
}

