/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.NumericPropertyDescriptor;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractRealNumberEditor;
import net.sourceforge.pmd.lang.rule.properties.FloatProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class FloatEditorFactory
extends AbstractRealNumberEditor {
    public static final FloatEditorFactory instance = new FloatEditorFactory();

    private FloatEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return new FloatProperty(name, description, Float.valueOf(this.defaultIn(otherData).floatValue()), Float.valueOf(this.minimumIn(otherData).floatValue()), Float.valueOf(this.maximumIn(otherData).floatValue()), 0.0f);
    }

    private static FloatProperty floatPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (FloatProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (FloatProperty)desc;
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return new Float((double)((Spinner)valueControl).getSelection() / scale);
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final FloatProperty fp = FloatEditorFactory.floatPropertyFrom(desc);
        final Spinner spinner = this.newSpinnerFor(parent, source, (NumericPropertyDescriptor<?>)fp);
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Float newValue = new Float((double)spinner.getSelection() / scale);
                if (newValue.equals(FloatEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)fp))) {
                    return;
                }
                source.setProperty((PropertyDescriptor)fp, (Object)newValue);
                listener.changed(source, (PropertyDescriptor<?>)fp, (Object)newValue);
                FloatEditorFactory.this.adjustRendering(source, desc, (Control)spinner);
            }
        });
        return spinner;
    }
}

