/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.Comparator;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.ItemColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.ItemFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.ItemFieldAccessorAdapter;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueFormatter;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.util.Util;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public interface MarkerColumnsUI {
    public static final Comparator<RulePriority> compPriority = new Comparator<RulePriority>(){

        @Override
        public int compare(RulePriority a, RulePriority b) {
            return a.compareTo((Enum)b);
        }
    };
    public static final ItemFieldAccessor<RulePriority, IMarker> priorityAcc = new ItemFieldAccessorAdapter<RulePriority, IMarker>(compPriority){

        @Override
        public RulePriority valueFor(IMarker marker) {
            int prio = MarkerUtil.rulePriorityFor(marker, 1);
            return RulePriority.valueOf((int)prio);
        }
    };
    public static final ItemFieldAccessor<Image, IMarker> priorityImgAcc = new ItemFieldAccessorAdapter<Image, IMarker>(null){
        final Display display = Display.getCurrent();

        @Override
        public Image imageFor(IMarker marker) {
            RulePriority rp = priorityAcc.valueFor(marker);
            return PriorityDescriptorCache.instance.descriptorFor(rp).getImage(this.display);
        }
    };
    public static final ItemFieldAccessor<Integer, IMarker> lineNoAcc = new ItemFieldAccessorAdapter<Integer, IMarker>(Util.compInt){

        @Override
        public Integer valueFor(IMarker marker) {
            return marker.getAttribute("lineNumber", 0);
        }
    };
    public static final ItemFieldAccessor<Long, IMarker> createdAcc = new ItemFieldAccessorAdapter<Long, IMarker>(Util.compLong){

        @Override
        public Long valueFor(IMarker marker) {
            return MarkerUtil.createdOn(marker, -1L);
        }
    };
    public static final ItemFieldAccessor<Boolean, IMarker> doneAcc = new ItemFieldAccessorAdapter<Boolean, IMarker>(Util.compBool){

        @Override
        public Boolean valueFor(IMarker marker) {
            return MarkerUtil.doneState(marker, false);
        }
    };
    public static final ItemFieldAccessor<String, IMarker> ruleNameAcc = new ItemFieldAccessorAdapter<String, IMarker>(Util.compStr){

        @Override
        public String valueFor(IMarker marker) {
            return MarkerUtil.ruleNameFor(marker);
        }
    };
    public static final ItemFieldAccessor<String, IMarker> messageAcc = new ItemFieldAccessorAdapter<String, IMarker>(Util.compStr){

        @Override
        public String valueFor(IMarker marker) {
            return MarkerUtil.messageFor(marker, "??");
        }
    };
    public static final ItemColumnDescriptor<Image, IMarker> priority = new ItemColumnDescriptor<Image, IMarker>("tPriority", "Priority", 0x1000000, 20, false, priorityImgAcc);
    public static final ItemColumnDescriptor<Boolean, IMarker> done = new ItemColumnDescriptor<Boolean, IMarker>("tDone", "done", 16384, 50, false, doneAcc);
    public static final ItemColumnDescriptor<Long, IMarker> created = new ItemColumnDescriptor<Long, IMarker>("tCreated", "created", 16384, 130, true, createdAcc, ValueFormatter.TimeFormatters);
    public static final ItemColumnDescriptor<String, IMarker> ruleName = new ItemColumnDescriptor<String, IMarker>("tRuleName", "Rule", 16384, 190, true, ruleNameAcc);
    public static final ItemColumnDescriptor<String, IMarker> message = new ItemColumnDescriptor<String, IMarker>("tMsg", "view.outline.column_message", 16384, 260, true, messageAcc);
    public static final ItemColumnDescriptor<Integer, IMarker> lineNumber = new ItemColumnDescriptor<Integer, IMarker>("tLineNo", "view.outline.column_line", 16384, 50, false, lineNoAcc);
}

