/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.Comparator;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.ui.BasicTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.ColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.ItemColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.ItemFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.AbstractTableManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BasicTableManager<T>
extends AbstractTableManager<T> {
    protected TableViewer tableViewer;
    private static final int DefaultTableStyle = 68354;

    public static int columnIndexAt(TableItem item, int xPosition) {
        TableColumn[] cols = item.getParent().getColumns();
        Rectangle bounds = null;
        int i = 0;
        while (i < cols.length) {
            bounds = item.getBounds(i);
            if (bounds.x < xPosition && xPosition < bounds.x + bounds.width) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public BasicTableManager(String theWidgetId, IPreferences thePreferences, ColumnDescriptor[] theColumns) {
        super(theWidgetId, thePreferences, theColumns);
    }

    @Override
    protected String idFor(Object column) {
        return ((TableColumn)column).getToolTipText();
    }

    @Override
    protected AbstractTableManager.ColumnWidthAdapter columnAdapterFor(ColumnDescriptor desc) {
        TableColumn column = this.columnFor(desc);
        return BasicTableManager.adapterFor(column);
    }

    private TableColumn columnFor(ColumnDescriptor desc) {
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.getData("descriptor") == desc) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    private TableColumn columnFor(String tooltipText) {
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (String.valueOf(column.getToolTipText()).equals(tooltipText)) {
                return column;
            }
            ++n2;
        }
        return null;
    }

    private ViewerSorter createSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ItemFieldAccessor acc = (ItemFieldAccessor)BasicTableManager.this.columnSorter;
                Comparator comp = acc.comparator();
                if (comp == null) {
                    return 0;
                }
                Object v1 = acc.valueFor(e1);
                Object v2 = acc.valueFor(e2);
                if (v1 == null) {
                    return v2 == null ? 0 : -1;
                }
                if (v2 == null) {
                    return v1 == null ? 0 : 1;
                }
                int result = comp.compare(v1, v2);
                return BasicTableManager.this.sortDescending ? 0 - result : result;
            }
        };
    }

    @Override
    protected void redrawTable(String sortColumnLabel, int sortDir) {
        Table table = this.tableViewer.getTable();
        this.tableViewer.setComparator((ViewerComparator)this.createSorter());
        TableColumn sortColumn = this.columnFor(sortColumnLabel);
        table.setSortColumn(sortColumn);
        table.setSortDirection(sortDir);
    }

    public TableViewer buildTableViewer(Composite parent) {
        return this.buildTableViewer(parent, 68354);
    }

    public TableViewer buildTableViewer(Composite parent, int tableStyle) {
        this.tableViewer = new TableViewer(parent, tableStyle);
        this.tableViewer.setUseHashlookup(true);
        final Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                BasicTableManager.this.selectedItems(selection.toArray());
            }
        });
        this.addDeleteListener((Control)table);
        table.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TableItem item = table.getItem(point);
                if (item != null) {
                    int columnIndex = BasicTableManager.columnIndexAt(item, event.x);
                    BasicTableManager.this.updateTooltipFor(item, columnIndex);
                }
            }
        });
        this.setupMenusFor((Control)table);
        return this.tableViewer;
    }

    public void setupColumns(ItemColumnDescriptor[] columnDescs) {
        TableColumn[] columns;
        Table table = this.tableViewer.getTable();
        int i = 0;
        while (i < columnDescs.length) {
            columnDescs[i].buildTableColumn(table, this);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BasicTableLabelProvider(columnDescs));
        TableColumn[] tableColumnArray = columns = table.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    protected void updateTooltipFor(TableItem item, int columnIndex) {
    }

    protected void selectedItems(Object[] items) {
    }

    @Override
    protected void removeSelectedItems() {
    }

    @Override
    protected int headerHeightFor(Control control) {
        return ((Table)control).getHeaderHeight();
    }

    @Override
    protected void setMenu(Control control, Menu menu) {
        ((Table)control).setMenu(menu);
    }

    @Override
    protected Rectangle clientAreaFor(Control control) {
        return ((Table)control).getClientArea();
    }

    @Override
    protected void saveItemSelections() {
    }
}

