/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.util.Comparator;
import net.sourceforge.pmd.Rule;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class RuleTableViewerSorter
extends ViewerSorter {
    public static final Comparator<Rule> RULE_DEFAULT_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule r1, Rule r2) {
            int cmp = RULE_RULESET_NAME_COMPARATOR.compare(r1, r2);
            if (cmp == 0) {
                cmp = RULE_NAME_COMPARATOR.compare(r1, r2);
            }
            return cmp;
        }
    };
    public static final Comparator<Rule> RULE_LANGUAGE_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule r1, Rule r2) {
            return r1.getLanguage().compareTo((Enum)r2.getLanguage());
        }
    };
    public static final Comparator<Rule> RULE_RULESET_NAME_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule r1, Rule r2) {
            return RuleTableViewerSorter.compareStrings(r1.getRuleSetName(), r2.getRuleSetName());
        }
    };
    public static final Comparator<Rule> RULE_NAME_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule r1, Rule r2) {
            return RuleTableViewerSorter.compareStrings(r1.getName(), r2.getName());
        }
    };
    public static final Comparator<Rule> RULE_SINCE_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule r1, Rule r2) {
            return RuleTableViewerSorter.compareStrings(r1.getSince(), r2.getSince());
        }
    };
    public static final Comparator<Rule> RULE_PRIORITY_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule r1, Rule r2) {
            return r1.getPriority().getPriority() - r2.getPriority().getPriority();
        }
    };
    public static final Comparator<Rule> RULE_DESCRIPTION_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule r1, Rule r2) {
            return RuleTableViewerSorter.compareStrings(r1.getDescription(), r2.getDescription());
        }
    };
    private Comparator<Rule> comparator;
    private boolean sortDescending = false;

    public RuleTableViewerSorter(Comparator<Rule> comparator) {
        this.comparator = comparator;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public void setSortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
    }

    public Comparator<Rule> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<Rule> comparator) {
        if (this.comparator != comparator) {
            this.comparator = comparator;
        } else {
            this.sortDescending = !this.sortDescending;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = this.comparator.compare((Rule)e1, (Rule)e2);
        return this.sortDescending ? 0 - result : result;
    }

    private static int compareStrings(String s1, String s2) {
        String str1 = s1 == null ? "" : s1.trim().toUpperCase();
        String str2 = s2 == null ? "" : s2.trim().toUpperCase();
        return str1.compareTo(str2);
    }
}

