/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import net.sourceforge.pmd.eclipse.ui.preferences.PMDPreferencePage;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleProperty;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class RulePropertyCellModifier
implements ICellModifier {
    private static final Logger log = Logger.getLogger(RulePropertyCellModifier.class);
    private TableViewer tableViewer;

    public RulePropertyCellModifier(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public boolean canModify(Object element, String property) {
        return property.equalsIgnoreCase("value");
    }

    public Object getValue(Object element, String property) {
        String result = null;
        if (element instanceof RuleProperty) {
            RuleProperty ruleProperty = (RuleProperty)element;
            if (property.equalsIgnoreCase("property")) {
                result = ruleProperty.getProperty();
                log.debug((Object)("Interrogation de la propri\u00e9t\u00e9 : " + result));
            } else if (property.equalsIgnoreCase("value")) {
                result = ruleProperty.getValue();
                log.debug((Object)("Interrogation de la valeur de la propri\u00e9t\u00e9 : " + result));
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        if (item.getData() instanceof RuleProperty) {
            RuleProperty ruleProperty = (RuleProperty)item.getData();
            if (property.equalsIgnoreCase("value")) {
                ruleProperty.setValue((String)value);
                this.tableViewer.update((Object)ruleProperty, new String[]{"value"});
                PMDPreferencePage.getActiveInstance().setModified(true);
                log.debug((Object)("modification de la valeur de la propri\u00e9t\u00e9 : " + value));
            }
        }
    }
}

