/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.editors.StyleExtractor;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxData;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxManager;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.util.FontBuilder;
import net.sourceforge.pmd.lang.Language;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class PageBuilder {
    private List<int[]> headingSpans = new ArrayList<int[]>();
    private List<int[]> codeSpans = new ArrayList<int[]>();
    private Map<int[], String> linksBySpan = new HashMap<int[], String>();
    private StringBuilder buffer = new StringBuilder(500);
    private Color headingColor;
    private int indentDepth;
    private TextStyle codeStyle;
    private StyleExtractor codeStyleExtractor;
    private static final char CR = '\n';
    private static final Color BACKGROUND = Display.getCurrent().getSystemColor(1);
    private static final Comparator<StyleRange> StyleComparator = new Comparator<StyleRange>(){

        @Override
        public int compare(StyleRange sr1, StyleRange sr2) {
            return sr1.start - sr2.start;
        }
    };

    public static StyleRange[] sort(List<StyleRange> ranges) {
        StyleRange[] styles = ranges.toArray(new StyleRange[ranges.size()]);
        Arrays.sort(styles, StyleComparator);
        return styles;
    }

    public PageBuilder(int textIndent, int headingColorIndex, FontBuilder codeFontBuilder) {
        this.indentDepth = textIndent;
        Display display = Display.getCurrent();
        this.headingColor = display.getSystemColor(headingColorIndex);
        this.codeStyle = codeFontBuilder.style(display);
        SyntaxData syntax = SyntaxManager.getSyntaxData("java");
        this.codeStyleExtractor = new StyleExtractor(syntax);
    }

    public void indentDepth(int aDepth) {
        this.indentDepth = aDepth;
    }

    public int indentDepth() {
        return this.indentDepth;
    }

    public boolean hasLinks() {
        return !this.linksBySpan.isEmpty();
    }

    public void clear() {
        this.buffer.setLength(0);
        if (this.headingSpans != null) {
            this.headingSpans.clear();
        }
        if (this.codeSpans != null) {
            this.codeSpans.clear();
        }
        if (this.linksBySpan != null) {
            this.linksBySpan.clear();
        }
    }

    public void setLanguage(Language language) {
        SyntaxData syntax = SyntaxManager.getSyntaxData(language.getTerseName());
        this.codeStyleExtractor.syntax(syntax);
    }

    public void addText(String text) {
        int i = 0;
        while (i < this.indentDepth) {
            this.buffer.append(' ');
            ++i;
        }
        this.buffer.append(text).append('\n');
    }

    public void addRawText(String text) {
        this.buffer.append(text);
    }

    public void addHeading(String headingKey) {
        String heading = SWTUtil.stringFor(headingKey);
        int length = this.buffer.length();
        if (length > 0) {
            this.buffer.append('\n');
        }
        this.headingSpans.add(new int[]{++length, length + heading.length()});
        this.buffer.append(heading).append('\n');
    }

    public void addCode(String code) {
        int length = this.buffer.length();
        this.codeSpans.add(new int[]{length, length + code.length()});
        this.buffer.append(code);
    }

    public void addLink(String text, String link) {
        int length = this.buffer.length();
        this.linksBySpan.put(new int[]{length, length + text.length()}, link);
        this.buffer.append(text);
    }

    private String linkAt(int textIndex) {
        for (Map.Entry<int[], String> entry : this.linksBySpan.entrySet()) {
            int[] span = entry.getKey();
            if (span[0] > textIndex || textIndex > span[1]) continue;
            return entry.getValue();
        }
        return null;
    }

    public void showOn(StyledText widget) {
        String text = this.buffer.toString();
        widget.setText(text);
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        int[] span = null;
        int i = 0;
        while (i < this.headingSpans.size()) {
            span = this.headingSpans.get(i);
            ranges.add(new StyleRange(span[0], span[1] - span[0], this.headingColor, BACKGROUND, 1));
            ++i;
        }
        for (int[] spn : this.linksBySpan.keySet()) {
            StyleRange style = new StyleRange(spn[0], spn[1] - spn[0], this.headingColor, BACKGROUND, 4);
            style.underline = true;
            ranges.add(style);
        }
        String crStr = Character.toString('\n');
        StyleRange sr = null;
        int i2 = 0;
        while (i2 < this.codeSpans.size()) {
            span = this.codeSpans.get(i2);
            sr = new StyleRange(this.codeStyle);
            sr.start = span[0];
            sr.length = span[1] - span[0];
            List<StyleRange> colorRanges = this.codeStyleExtractor.stylesFor(text, sr.start, sr.length, crStr);
            for (StyleRange range : colorRanges) {
                ranges.add(range);
            }
            ++i2;
        }
        StyleRange[] styles = PageBuilder.sort(ranges);
        widget.setStyleRanges(styles);
    }

    public void addLinkHandler(final StyledText widget) {
        widget.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int offset = widget.getOffsetAtLocation(new Point(event.x, event.y));
                    String link = PageBuilder.this.linkAt(offset);
                    if (link != null) {
                        PageBuilder.launchBrowser(link);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        });
    }

    private static void launchBrowser(String link) {
        try {
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            browser.openURL(new URL(link));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

