/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.core.ext.RuleSetsExtensionProcessor;
import net.sourceforge.pmd.eclipse.core.impl.RuleSetManagerImpl;
import net.sourceforge.pmd.eclipse.plugin.FileChangeReviewer;
import net.sourceforge.pmd.eclipse.runtime.cmd.JavaProjectClassLoader;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesFactory;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferencesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.IPropertiesFactory;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.properties.impl.PropertiesFactoryImpl;
import net.sourceforge.pmd.eclipse.runtime.writer.IAstWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.impl.WriterFactoryImpl;
import net.sourceforge.pmd.eclipse.ui.RuleLabelDecorator;
import net.sourceforge.pmd.eclipse.ui.ShapePainter;
import net.sourceforge.pmd.eclipse.ui.nls.StringTable;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PMDPlugin
extends AbstractUIPlugin {
    private static File pluginFolder;
    private FileChangeReviewer changeReviewer;
    private Map<RGB, Color> coloursByRGB = new HashMap<RGB, Color>();
    public static final String PLUGIN_ID = "net.sourceforge.pmd.eclipse.plugin";
    private static Map<IProject, IJavaProject> JavaProjectsByIProject;
    private static PMDPlugin plugin;
    public static String VERSION;
    private static final Integer[] priorityValues;
    private static final Logger log;
    private StringTable stringTable;
    public static final String ROOT_LOG_ID = "net.sourceforge.pmd";
    private static final String PMD_ECLIPSE_APPENDER_NAME = "PMDEclipseAppender";
    private IPreferencesFactory preferencesFactory = new PreferencesFactoryImpl();
    private IPropertiesFactory propertiesFactory = new PropertiesFactoryImpl();
    private final IRuleSetManager ruleSetManager = new RuleSetManagerImpl();

    static {
        JavaProjectsByIProject = new HashMap<IProject, IJavaProject>();
        VERSION = "unknown";
        priorityValues = new Integer[]{1, 2, 3, 4, 5};
        log = Logger.getLogger(PMDPlugin.class);
    }

    public Color colorFor(RGB rgb) {
        Color color = this.coloursByRGB.get(rgb);
        if (color != null) {
            return color;
        }
        color = new Color(null, rgb.red, rgb.green, rgb.blue);
        this.coloursByRGB.put(rgb, color);
        return color;
    }

    public static void setJavaClassLoader(PMDConfiguration config, IProject project) {
        IPreferences preferences = PMDPlugin.getDefault().loadPreferences();
        try {
            if (preferences.isProjectBuildPathEnabled() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                config.setClassLoader((ClassLoader)new JavaProjectClassLoader(config.getClass().getClassLoader(), project));
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static LanguageVersion javaVersionFor(IProject project) {
        IJavaProject jProject = JavaProjectsByIProject.get(project);
        if (jProject == null) {
            jProject = JavaCore.create((IProject)project);
            JavaProjectsByIProject.put(project, jProject);
        }
        if (jProject.exists()) {
            String compilerCompliance = jProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            return Language.JAVA.getVersion(compilerCompliance);
        }
        return null;
    }

    public static IClasspathEntry buildSourceClassPathEntryFor(IProject project) {
        IJavaProject jProject = JavaProjectsByIProject.get(project);
        if (jProject == null) {
            jProject = JavaCore.create((IProject)project);
            JavaProjectsByIProject.put(project, jProject);
        }
        if (jProject.exists()) {
            try {
                if (jProject.getRawClasspath() != null) {
                    IClasspathEntry[] iClasspathEntryArray = jProject.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 3) {
                            return entry;
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                log.error((Object)"Couldn't determine source classpath", (Throwable)e);
            }
        }
        return null;
    }

    private void disposeResources() {
        PMDPlugin.disposeAll(this.coloursByRGB.values());
    }

    public static void disposeAll(Collection<Color> colors) {
        for (Color color : colors) {
            color.dispose();
        }
    }

    public static File getPluginFolder() {
        if (pluginFolder == null) {
            URL url = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
            try {
                url = FileLocator.resolve((URL)url);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            pluginFolder = new File(url.getPath());
        }
        return pluginFolder;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerStandardRuleSets();
        IPreferences prefs = this.loadPreferences();
        this.configureLogs(prefs);
        this.registerAdditionalRuleSets();
        this.fileChangeListenerEnabled(prefs.isCheckAfterSaveEnabled());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent arg0) {
                if (arg0.getType() == 4 && arg0.getResource() instanceof IProject) {
                    PMDPlugin.this.getPropertiesManager().removeProjectProperties((IProject)arg0.getResource());
                }
            }
        });
        VERSION = (String)context.getBundle().getHeaders().get("Bundle-Version");
    }

    public void fileChangeListenerEnabled(boolean flag) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (flag) {
            if (this.changeReviewer == null) {
                this.changeReviewer = new FileChangeReviewer();
            }
            workspace.addResourceChangeListener((IResourceChangeListener)this.changeReviewer);
        } else if (this.changeReviewer != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this.changeReviewer);
            this.changeReviewer = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.fileChangeListenerEnabled(false);
        plugin = null;
        this.disposeResources();
        ShapePainter.disposeAll();
        ResourceManager.dispose();
        super.stop(context);
    }

    public static PMDPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image getImage(String key, String iconPath) {
        ImageDescriptor descriptor;
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key);
        if (image == null && (descriptor = PMDPlugin.getImageDescriptor(iconPath)) != null) {
            registry.put(key, descriptor);
            image = registry.get(key);
        }
        return image;
    }

    public void logError(String message, Throwable t) {
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, String.valueOf(message) + t.getMessage(), t));
        if (log != null) {
            log.error((Object)message, t);
        }
    }

    public void logError(IStatus status) {
        this.getLog().log(status);
        if (log != null) {
            log.error((Object)status.getMessage(), status.getException());
        }
    }

    public void showError(final String message, final Throwable t) {
        this.logError(message, t);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String errTitle = PMDPlugin.this.getStringTable().getString("message.error.title");
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)errTitle, (String)(String.valueOf(message) + String.valueOf(t)));
            }
        });
    }

    public void showUserError(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String errTitle = PMDPlugin.this.getStringTable().getString("message.error.title");
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)errTitle, (String)message);
            }
        });
    }

    public StringTable getStringTable() {
        if (this.stringTable == null) {
            this.stringTable = new StringTable();
        }
        return this.stringTable;
    }

    public Integer[] getPriorityValues() {
        return priorityValues;
    }

    public IPreferences loadPreferences() {
        return this.getPreferencesManager().loadPreferences();
    }

    public IPreferencesManager getPreferencesManager() {
        return this.preferencesFactory.getPreferencesManager();
    }

    public IProjectPropertiesManager getPropertiesManager() {
        return this.propertiesFactory.getProjectPropertiesManager();
    }

    public IProjectProperties loadProjectProperties(IProject project) throws PropertiesException {
        return this.getPropertiesManager().loadProjectProperties(project);
    }

    public void logInformation(String message) {
        this.getLog().log((IStatus)new Status(1, this.getBundle().getSymbolicName(), 0, message, null));
    }

    public IAstWriter getAstWriter() {
        return new WriterFactoryImpl().getAstWriter();
    }

    public IRuleSetWriter getRuleSetWriter() {
        return new WriterFactoryImpl().getRuleSetWriter();
    }

    public void applyLogPreferences(IPreferences preferences) {
        Logger log = Logger.getLogger((String)ROOT_LOG_ID);
        log.setLevel(preferences.getLogLevel());
        RollingFileAppender appender = (RollingFileAppender)log.getAppender(PMD_ECLIPSE_APPENDER_NAME);
        if (appender == null) {
            this.configureLogs(preferences);
        } else if (!appender.getFile().equals(preferences.getLogFileName())) {
            appender.setFile(preferences.getLogFileName());
            appender.activateOptions();
        }
    }

    private void configureLogs(IPreferences preferences) {
        try {
            PatternLayout layout = new PatternLayout("%d{yyyy/MM/dd HH:mm:ss,SSS} %-5p %-32c{1} %m%n");
            RollingFileAppender appender = new RollingFileAppender((Layout)layout, preferences.getLogFileName());
            appender.setName(PMD_ECLIPSE_APPENDER_NAME);
            appender.setMaxBackupIndex(1);
            appender.setMaxFileSize("10MB");
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)layout));
            Logger.getRootLogger().setLevel(Level.WARN);
            Logger.getRootLogger().setAdditivity(false);
            Logger.getLogger((String)ROOT_LOG_ID).addAppender((Appender)appender);
            Logger.getLogger((String)ROOT_LOG_ID).setLevel(preferences.getLogLevel());
            Logger.getLogger((String)ROOT_LOG_ID).setAdditivity(false);
        }
        catch (IOException e) {
            this.logError("IO Exception when configuring logging.", e);
        }
    }

    public final IRuleSetManager getRuleSetManager() {
        return this.ruleSetManager;
    }

    public final void log(int severity, String message, Throwable t) {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            this.getLog().log((IStatus)new Status(severity, bundle.getSymbolicName(), 0, message, t));
        }
    }

    private void registerStandardRuleSets() {
        RuleSetFactory factory = new RuleSetFactory();
        try {
            Iterator iterator = factory.getRegisteredRuleSets();
            IRuleSetManager manager = this.getRuleSetManager();
            while (iterator.hasNext()) {
                RuleSet ruleSet = (RuleSet)iterator.next();
                manager.registerRuleSet(ruleSet);
                manager.registerDefaultRuleSet(ruleSet);
            }
        }
        catch (RuleSetNotFoundException e) {
            this.log(2, "Problem getting all registered PMD RuleSets", e);
        }
    }

    private void registerAdditionalRuleSets() {
        try {
            RuleSetsExtensionProcessor processor = new RuleSetsExtensionProcessor(this.getRuleSetManager());
            processor.process();
        }
        catch (CoreException e) {
            this.log(4, "Error when processing RuleSets extensions", e);
        }
    }

    public RuleLabelDecorator ruleLabelDecorator() {
        IDecoratorManager mgr = this.getWorkbench().getDecoratorManager();
        return (RuleLabelDecorator)mgr.getBaseLabelProvider("net.sourceforge.pmd.eclipse.plugin.RuleLabelDecorator");
    }

    public void changedFiles(Collection<IFile> changedFiles) {
        RuleLabelDecorator rld = this.ruleLabelDecorator();
        if (rld == null) {
            return;
        }
        HashSet<IResource> withParents = new HashSet<IResource>(changedFiles.size() * 2);
        withParents.addAll(changedFiles);
        for (IFile file : changedFiles) {
            IContainer parent = file.getParent();
            while (parent != null) {
                withParents.add((IResource)parent);
                parent = parent.getParent();
            }
        }
        rld.changed(withParents);
    }

    private void addFilesTo(IResource resource, Collection<IResource> allKids) {
        if (resource instanceof IFile) {
            allKids.add(resource);
            return;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            IResource[] kids = null;
            try {
                kids = folder.members();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.addKids(allKids, kids);
            allKids.add((IResource)folder);
            return;
        }
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            IResource[] kids = null;
            try {
                kids = project.members();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.addKids(allKids, kids);
            allKids.add((IResource)project);
            return;
        }
    }

    private void addKids(Collection<IResource> allKids, IResource[] kids) {
        if (kids == null) {
            return;
        }
        IResource[] iResourceArray = kids;
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            IResource irc = iResourceArray[n2];
            if (irc instanceof IFile) {
                allKids.add(irc);
            } else if (irc instanceof IFolder) {
                this.addFilesTo(irc, allKids);
            }
            ++n2;
        }
    }

    public void removedMarkersIn(IResource resource) {
        RuleLabelDecorator decorator = this.ruleLabelDecorator();
        if (decorator == null) {
            return;
        }
        ArrayList<IResource> changes = new ArrayList<IResource>();
        this.addFilesTo(resource, changes);
        decorator.changed(changes);
    }
}

