/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.rulesets.vo;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.RuleSet;
import net.sourceforge.pmd.util.StringUtil;

public class RuleSets {
    private RuleSet defaultRuleSet;
    private List<RuleSet> ruleSetsList = new ArrayList<RuleSet>();

    public RuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    public void setDefaultRuleSet(RuleSet defaultRuleSet) {
        if (defaultRuleSet == null) {
            throw new IllegalArgumentException("default rule set cannot be null");
        }
        if (!this.ruleSetsList.contains(defaultRuleSet)) {
            throw new IllegalArgumentException("The rule set " + defaultRuleSet.getName() + " must belong to the rule set list to be set as default.");
        }
        this.defaultRuleSet = defaultRuleSet;
    }

    public List<RuleSet> getRuleSets() {
        return this.ruleSetsList;
    }

    public void setRuleSets(List<RuleSet> ruleSets) {
        if (ruleSets == null || ruleSets.isEmpty()) {
            throw new IllegalArgumentException("The rule set list should not be null or empty");
        }
        this.ruleSetsList = ruleSets;
    }

    public String getDefaultRuleSetName() {
        return this.defaultRuleSet.getName();
    }

    public void setDefaultRuleSetName(String ruleSetName) {
        if (StringUtil.isEmpty((String)ruleSetName)) {
            throw new IllegalArgumentException("The default ruleset name must not be null or empty");
        }
        for (RuleSet ruleSet2 : this.ruleSetsList) {
            RuleSet ruleSet = ruleSet2;
            if (!ruleSet.getName().equals(ruleSetName)) continue;
            this.setDefaultRuleSet(ruleSet);
            break;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("RuleSets defaultRuleSet=");
        buffer.append(this.defaultRuleSet.getName());
        buffer.append(" ruleSetsList=");
        for (RuleSet ruleSet : this.ruleSetsList) {
            buffer.append(ruleSet);
        }
        return buffer.toString();
    }
}

