/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.rulesets.vo;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.pmd.eclipse.core.rulesets.vo.Rule;
import net.sourceforge.pmd.util.StringUtil;

public class RuleSet {
    public static final String LANGUAGE_JAVA = "JAVA";
    public static final String LANGUAGE_JSP = "JSP";
    private String name = "";
    private String description = "";
    private String language = "JAVA";
    private final net.sourceforge.pmd.RuleSet pmdRuleSet = new net.sourceforge.pmd.RuleSet();
    private final Collection<Rule> rules = new ArrayList<Rule>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description cannot be null");
        }
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        this.name = name;
    }

    public Collection<Rule> getRules() {
        return this.rules;
    }

    public void addRule(Rule rule) {
        if (rule == null) {
            throw new IllegalArgumentException("rule cannot be null");
        }
        this.rules.add(rule);
        this.pmdRuleSet.addRule(rule.getPmdRule());
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (!LANGUAGE_JAVA.equals(language) && !LANGUAGE_JSP.equals(language)) {
            throw new IllegalArgumentException("language must be one of the LANGUAGE_xxx constant and found " + language);
        }
        this.language = language;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof RuleSet) {
            RuleSet rs = (RuleSet)arg0;
            return this.name.equals(rs.name) && this.rules.equals(rs.rules) && this.language.equals(rs.language);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + this.rules.hashCode() * 21 * 21 + this.language.hashCode() * 13 * 13;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("RuleSet name=" + this.name + " description=" + " language=" + this.language + " rules=");
        for (Rule rule : this.rules) {
            buffer.append(' ').append(rule);
        }
        return buffer.toString();
    }

    public net.sourceforge.pmd.RuleSet getPmdRuleSet() {
        return this.pmdRuleSet;
    }
}

