/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractTransitionableTo;
import org.springframework.ide.eclipse.webflow.core.internal.model.Secured;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ISecured;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransitionableFrom
extends AbstractTransitionableTo
implements ITransitionableFrom {
    private List<ITransition> outputTransitions = new ArrayList<ITransition>();
    private ISecured secured;

    @Override
    public ISecured getSecured() {
        return this.secured;
    }

    @Override
    public void setSecured(ISecured secured) {
        this.secured = secured;
    }

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        NodeList children;
        super.init(node, parent);
        this.outputTransitions = new ArrayList<ITransition>();
        if (node != null && (children = node.getChildNodes()) != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("transition".equals(child.getLocalName())) {
                    StateTransition trans = new StateTransition((IWebflowState)parent);
                    trans.init(child, this);
                    this.outputTransitions.add(trans);
                } else if ("secured".equals(child.getLocalName())) {
                    Secured secured = new Secured();
                    secured.init(child, this);
                    this.secured = secured;
                }
                ++i;
            }
        }
    }

    @Override
    public List<ITransition> getOutputTransitions() {
        return this.outputTransitions;
    }

    @Override
    public void addOutputTransition(ITransition transitions) {
        this.outputTransitions.add(transitions);
        if (this.getNode() != null) {
            this.getNode().appendChild((Node)transitions.getNode());
        }
        super.fireStructureChange("outputs", transitions);
    }

    @Override
    public void removeOutputTransition(ITransition transitions) {
        this.outputTransitions.remove(transitions);
        if (this.getNode() != null) {
            this.getNode().removeChild((Node)transitions.getNode());
        }
        super.fireStructureChange("outputs", transitions);
    }
}

