/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractState
extends AbstractModelElement
implements IState {
    protected IEntryActions entryActions = null;
    protected IExitActions exitActions = null;
    protected List<IExceptionHandler> exceptionHandler = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        NodeList children;
        super.init(node, parent);
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
        this.entryActions = null;
        this.exitActions = null;
        if (node != null && (children = node.getChildNodes()) != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("entry-actions".equals(child.getLocalName())) {
                    this.entryActions = new EntryActions();
                    ((EntryActions)this.entryActions).init(child, this);
                } else if ("exit-actions".equals(child.getLocalName())) {
                    this.exitActions = new ExitActions();
                    ((ExitActions)this.exitActions).init(child, this);
                } else if ("on-entry".equals(child.getLocalName())) {
                    this.entryActions = new EntryActions();
                    ((EntryActions)this.entryActions).init(child, this);
                } else if ("on-exit".equals(child.getLocalName())) {
                    this.exitActions = new ExitActions();
                    ((ExitActions)this.exitActions).init(child, this);
                } else if ("exception-handler".equals(child.getLocalName())) {
                    ExceptionHandler handler = new ExceptionHandler();
                    handler.init(child, this);
                    this.exceptionHandler.add(handler);
                }
                ++i;
            }
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    @Override
    public String getId() {
        return this.getAttribute("id");
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    @Override
    public IEntryActions getEntryActions() {
        return this.entryActions;
    }

    @Override
    public IExitActions getExitActions() {
        return this.exitActions;
    }

    @Override
    public void setEntryActions(IEntryActions entryActions) {
        if (this.entryActions != null) {
            this.getNode().removeChild((Node)this.entryActions.getNode());
        }
        this.entryActions = entryActions;
        if (entryActions != null) {
            WebflowModelXmlUtils.insertNode((Node)entryActions.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    @Override
    public void setExitActions(IExitActions exitActions) {
        if (this.exitActions != null) {
            this.getNode().removeChild((Node)this.exitActions.getNode());
        }
        this.exitActions = exitActions;
        if (exitActions != null) {
            WebflowModelXmlUtils.insertNode((Node)exitActions.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    @Override
    public List<IExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandler;
    }

    @Override
    public void addExceptionHandler(IExceptionHandler action) {
        if (!this.exceptionHandler.contains(action)) {
            this.exceptionHandler.add(action);
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.getNode());
            super.firePropertyChange("add_children", new Integer(this.exceptionHandler.indexOf(action)), action);
        }
    }

    @Override
    public void addExceptionHandler(IExceptionHandler action, int i) {
        if (!this.exceptionHandler.contains(action)) {
            this.exceptionHandler.add(i, action);
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.getNode());
            super.firePropertyChange("add_children", new Integer(this.exceptionHandler.indexOf(action)), action);
        }
    }

    @Override
    public void removeExceptionHandler(IExceptionHandler action) {
        if (this.exceptionHandler.contains(action)) {
            this.exceptionHandler.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.firePropertyChange("add_children", new Integer(this.exceptionHandler.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllExceptionHandler() {
        for (IExceptionHandler action : this.exceptionHandler) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
    }

    @Override
    public String getParent() {
        return this.getAttribute("parent");
    }

    @Override
    public void setParent(String parent) {
        this.setAttribute("parent", parent);
    }
}

