/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.metadata.model.IClassMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberValuePair;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationMetadata
implements IClassMetadata,
IAdaptable,
Serializable {
    private static final Set<IMethodMetadata> EMPTY_METHOD_METADATA = Collections.emptySet();
    private static final long serialVersionUID = -8338005903818492219L;
    private String beanId;
    private String handle;
    private IModelSourceLocation location;
    private Object value;
    private Set<IMethodMetadata> methodMetadata;

    public AbstractAnnotationMetadata(IBean bean, String handle, Object value, IModelSourceLocation location) {
        this(bean, handle, value, location, EMPTY_METHOD_METADATA);
    }

    public AbstractAnnotationMetadata(IBean bean, String handle, Object value, IModelSourceLocation location, Set<IMethodMetadata> methodMetadata) {
        this.handle = handle;
        this.value = value;
        this.beanId = bean.getElementID();
        this.location = location;
        this.methodMetadata = methodMetadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractAnnotationMetadata)) {
            return false;
        }
        AbstractAnnotationMetadata that = (AbstractAnnotationMetadata)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.handle, (Object)that.handle)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.beanId, (Object)that.beanId)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.location, (Object)that.location);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IBean.class) {
            return this.getBean();
        }
        return null;
    }

    public IBean getBean() {
        return (IBean)BeansCorePlugin.getModel().getElement(this.beanId);
    }

    public String getClassHandle() {
        return this.handle;
    }

    @Override
    public IModelSourceLocation getElementSourceLocation() {
        return this.location;
    }

    @Override
    public String getHandleIdentifier() {
        return this.beanId;
    }

    @Override
    public String getKey() {
        return this.handle;
    }

    @Override
    public Set<IMethodMetadata> getMethodMetaData() {
        return this.methodMetadata;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getValueAsText() {
        if (this.getValue() instanceof Set) {
            StringBuilder buf = new StringBuilder();
            for (AnnotationMemberValuePair pair : (Set)this.getValue()) {
                if (pair.getName() != null) {
                    buf.append(pair.getName());
                    buf.append(" = ");
                }
                buf.append(pair.getValue());
                buf.append(", ");
            }
            if (buf.length() > 0) {
                return String.valueOf(buf.substring(0, buf.length() - 2)) + " - ";
            }
            return "";
        }
        return "";
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.value);
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.handle);
        hashCode += ObjectUtils.nullSafeHashCode((Object)this.beanId);
        return 12 * (hashCode += ObjectUtils.nullSafeHashCode((Object)this.location));
    }
}

