/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.internal.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansTypeHierachyState;
import org.springframework.ide.eclipse.beans.core.metadata.BeansMetadataPlugin;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanMetadataBuilderJob;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.java.TypeStructureState;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.project.IProjectBuilder;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.IProjectContributorStateAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetadataProjectBuilder
implements IProjectBuilder,
IProjectContributorStateAware {
    private IProjectContributorState context = null;
    private Map<IBeansConfig, Set<IBean>> affectedBeans = new HashMap<IBeansConfig, Set<IBean>>();

    public void build(Set<IResource> affectedResources, int kind, IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Resolving Spring Meta Data");
        if (affectedResources.size() > 0) {
            BeanMetadataBuilderJob job = new BeanMetadataBuilderJob(this.affectedBeans);
            job.schedule();
        }
        monitor.done();
    }

    public void cleanup(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (BeansCoreUtils.isBeansConfig((IResource)resource) && resource instanceof IFile) {
            IBeansConfig beansConfig = BeansCorePlugin.getModel().getConfig((IFile)resource);
            for (IBean bean : beansConfig.getBeans()) {
                BeansMetadataPlugin.getMetadataModel().clearBeanMetadata(bean);
                BeansMetadataPlugin.getMetadataModel().clearBeanProperties(bean);
            }
        }
    }

    public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        HashSet<IResource> resources = new HashSet<IResource>();
        if (kind != 6 && resource instanceof IFile && resource.getName().endsWith(".java")) {
            TypeStructureState structureState = (TypeStructureState)this.context.get(TypeStructureState.class);
            BeansTypeHierachyState hierachyState = (BeansTypeHierachyState)this.context.get(BeansTypeHierachyState.class);
            if (structureState == null || structureState.hasStructuralChanges(resource, 24)) {
                for (IBean bean : hierachyState.getBeansByContainingTypes(resource)) {
                    IBeansConfig beansConfig = BeansModelUtils.getConfig((IModelElement)bean);
                    resources.add(beansConfig.getElementResource());
                    if (this.affectedBeans.containsKey(beansConfig)) {
                        this.affectedBeans.get(beansConfig).add(bean);
                        continue;
                    }
                    LinkedHashSet<IBean> beans = new LinkedHashSet<IBean>();
                    beans.add(bean);
                    this.affectedBeans.put(beansConfig, beans);
                }
            }
        } else if (BeansCoreUtils.isBeansConfig((IResource)resource, (boolean)true)) {
            IBeansConfig beansConfig = (IBeansConfig)BeansModelUtils.getResourceModelElement((Object)resource);
            if (beansConfig instanceof IImportedBeansConfig) {
                beansConfig = (IBeansConfig)BeansModelUtils.getParentOfClass((IModelElement)beansConfig, IBeansConfig.class);
            }
            for (IBeansImport beansImport : beansConfig.getImports()) {
                for (IImportedBeansConfig importedBeansConfig : beansImport.getImportedBeansConfigs()) {
                    resources.add(importedBeansConfig.getElementResource());
                    this.addBeans((IBeansConfig)importedBeansConfig);
                }
            }
            resources.add(beansConfig.getElementResource());
            this.addBeans(beansConfig);
        }
        return resources;
    }

    private void addBeans(IBeansConfig beansConfig) {
        if (this.affectedBeans.containsKey(beansConfig)) {
            this.affectedBeans.get(beansConfig).addAll(BeansModelUtils.getBeans((IModelElement)beansConfig));
        } else {
            Set beans = BeansModelUtils.getBeans((IModelElement)beansConfig);
            this.affectedBeans.put(beansConfig, beans);
        }
    }

    public void setProjectContributorState(IProjectContributorState context) {
        this.context = context;
    }
}

