/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.web.rss;

import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueCollector;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.rss.JiraRssHandler;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class JiraRssReader {
    private final JiraClient client;
    private final IssueCollector collector;

    public JiraRssReader(JiraClient client, IssueCollector collector) {
        this.client = client;
        this.collector = collector;
    }

    public void readRssFeed(InputStream feed, String baseUrl, IProgressMonitor monitor) throws JiraException, IOException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(new JiraRssHandler(this.client, this.collector, baseUrl));
            InputSource inputSource = new InputSource(feed);
            inputSource.setEncoding(this.client.getCharacterEncoding(monitor));
            reader.parse(inputSource);
            this.collector.done();
        }
        catch (SAXException e) {
            throw new JiraException("Error parsing server response: " + e.getMessage(), e);
        }
    }
}

