/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.soap;

import com.atlassian.connector.eclipse.internal.jira.core.model.Comment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.Group;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraConfiguration;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.NamedFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.ProjectRole;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.model.User;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraTimeFormat;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteComment;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteComponent;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteConfiguration;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteCustomFieldValue;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteFieldValue;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteFilter;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteGroup;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteIssueType;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemotePriority;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteProject;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteProjectRole;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteResolution;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteSecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteStatus;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteUser;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteVersion;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteWorklog;
import java.util.Calendar;
import java.util.Date;

public class JiraSoapConverter {
    protected static Priority[] convert(RemotePriority[] remotePriorities) {
        Priority[] priorities = new Priority[remotePriorities.length];
        int i = 0;
        while (i < remotePriorities.length) {
            priorities[i] = JiraSoapConverter.convert(remotePriorities[i]);
            ++i;
        }
        return priorities;
    }

    protected static Priority convert(RemotePriority remotePriority) {
        Priority priority = new Priority(remotePriority.getId());
        priority.setColour(remotePriority.getColor());
        priority.setDescription(remotePriority.getDescription());
        priority.setIcon(remotePriority.getIcon());
        priority.setName(remotePriority.getName());
        return priority;
    }

    protected static JiraWorkLog[] convert(RemoteWorklog[] remoteWorklogs) {
        JiraWorkLog[] worklogs = new JiraWorkLog[remoteWorklogs.length];
        int i = 0;
        while (i < remoteWorklogs.length) {
            worklogs[i] = JiraSoapConverter.convert(remoteWorklogs[i]);
            ++i;
        }
        return worklogs;
    }

    protected static JiraWorkLog convert(RemoteWorklog remoteWorklog) {
        JiraWorkLog worklog = new JiraWorkLog();
        worklog.setAuthor(remoteWorklog.getAuthor());
        worklog.setComment(remoteWorklog.getComment());
        worklog.setCreated(JiraSoapConverter.convert(remoteWorklog.getCreated()));
        worklog.setId(remoteWorklog.getId());
        worklog.setRoleLevelId(remoteWorklog.getRoleLevelId());
        worklog.setStartDate(JiraSoapConverter.convert(remoteWorklog.getStartDate()));
        worklog.setTimeSpent(remoteWorklog.getTimeSpentInSeconds());
        worklog.setUpdateAuthor(remoteWorklog.getUpdateAuthor());
        worklog.setAuthor(worklog.getAuthor());
        return worklog;
    }

    protected static RemoteWorklog convert(JiraWorkLog worklog, JiraTimeFormat formatter) {
        RemoteWorklog remoteWorklog = new RemoteWorklog();
        remoteWorklog.setAuthor(worklog.getAuthor());
        remoteWorklog.setComment(worklog.getComment());
        remoteWorklog.setCreated(JiraSoapConverter.convert(worklog.getCreated()));
        remoteWorklog.setId(worklog.getId());
        remoteWorklog.setRoleLevelId(worklog.getRoleLevelId());
        remoteWorklog.setStartDate(JiraSoapConverter.convert(worklog.getStartDate()));
        remoteWorklog.setTimeSpentInSeconds(worklog.getTimeSpent());
        remoteWorklog.setTimeSpent(formatter.format(worklog.getTimeSpent()));
        remoteWorklog.setUpdateAuthor(worklog.getUpdateAuthor());
        remoteWorklog.setAuthor(worklog.getAuthor());
        return remoteWorklog;
    }

    protected static Date convert(Calendar calendar) {
        return calendar != null ? calendar.getTime() : null;
    }

    protected static Calendar convert(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        return null;
    }

    protected static JiraStatus[] convert(RemoteStatus[] remoteStatuses) {
        JiraStatus[] statuses = new JiraStatus[remoteStatuses.length];
        int i = 0;
        while (i < remoteStatuses.length) {
            statuses[i] = JiraSoapConverter.convert(remoteStatuses[i]);
            ++i;
        }
        return statuses;
    }

    protected static JiraStatus convert(RemoteStatus remoteStatus) {
        return new JiraStatus(remoteStatus.getId(), remoteStatus.getName(), remoteStatus.getDescription(), remoteStatus.getIcon());
    }

    protected static Version[] convert(RemoteVersion[] remoteVersions) {
        Version[] versions = new Version[remoteVersions.length];
        int i = 0;
        while (i < remoteVersions.length) {
            versions[i] = JiraSoapConverter.convert(remoteVersions[i]);
            ++i;
        }
        return versions;
    }

    protected static Version convert(RemoteVersion remoteVersion) {
        Version version = new Version(remoteVersion.getId(), remoteVersion.getName());
        version.setArchived(remoteVersion.isArchived());
        version.setReleased(remoteVersion.isReleased());
        version.setReleaseDate(remoteVersion.getReleaseDate() != null ? remoteVersion.getReleaseDate().getTime() : null);
        version.setSequence(remoteVersion.getSequence());
        return version;
    }

    protected static Resolution[] convert(RemoteResolution[] remoteResolutions) {
        Resolution[] resolutions = new Resolution[remoteResolutions.length];
        int i = 0;
        while (i < remoteResolutions.length) {
            resolutions[i] = JiraSoapConverter.convert(remoteResolutions[i]);
            ++i;
        }
        return resolutions;
    }

    protected static Resolution convert(RemoteResolution remoteResolution) {
        return new Resolution(remoteResolution.getId(), remoteResolution.getName(), remoteResolution.getDescription(), remoteResolution.getIcon());
    }

    protected static IssueType[] convert(RemoteIssueType[] remoteIssueTypes) {
        IssueType[] issueTypes = new IssueType[remoteIssueTypes.length];
        int i = 0;
        while (i < remoteIssueTypes.length) {
            issueTypes[i] = JiraSoapConverter.convert(remoteIssueTypes[i]);
            ++i;
        }
        return issueTypes;
    }

    protected static IssueType convert(RemoteIssueType remoteIssueType) {
        return new IssueType(remoteIssueType.getId(), remoteIssueType.getName(), remoteIssueType.getDescription(), remoteIssueType.getIcon());
    }

    protected static Project[] convert(RemoteProject[] remoteProjects) {
        Project[] projects = new Project[remoteProjects.length];
        int i = 0;
        while (i < remoteProjects.length) {
            projects[i] = JiraSoapConverter.convert(remoteProjects[i]);
            ++i;
        }
        return projects;
    }

    protected static Project convert(RemoteProject remoteProject) {
        Project project = new Project();
        project.setDescription(remoteProject.getDescription());
        project.setId(remoteProject.getId());
        project.setKey(remoteProject.getKey());
        project.setLead(remoteProject.getLead());
        project.setName(remoteProject.getName());
        project.setProjectUrl(remoteProject.getProjectUrl());
        project.setUrl(remoteProject.getUrl());
        return project;
    }

    public static RemoteProject convert(Project project) {
        RemoteProject remoteProject = new RemoteProject();
        remoteProject.setDescription(project.getDescription());
        remoteProject.setId(project.getId());
        remoteProject.setKey(project.getKey());
        remoteProject.setLead(project.getLead());
        remoteProject.setName(project.getName());
        remoteProject.setProjectUrl(project.getProjectUrl());
        remoteProject.setUrl(project.getUrl());
        return remoteProject;
    }

    public static ProjectRole[] convert(RemoteProjectRole[] remoteProjectRoles) {
        ProjectRole[] projectRoles = new ProjectRole[remoteProjectRoles.length];
        int i = 0;
        while (i < remoteProjectRoles.length) {
            projectRoles[i] = JiraSoapConverter.convert(remoteProjectRoles[i]);
            ++i;
        }
        return projectRoles;
    }

    private static ProjectRole convert(RemoteProjectRole remoteProjectRole) {
        ProjectRole projectRole = new ProjectRole();
        projectRole.setDescription(remoteProjectRole.getDescription());
        projectRole.setId(remoteProjectRole.getId());
        projectRole.setName(remoteProjectRole.getName());
        return projectRole;
    }

    public static RemoteProjectRole convert(ProjectRole projectRole) {
        RemoteProjectRole remoteProjectRole = new RemoteProjectRole();
        remoteProjectRole.setDescription(projectRole.getDescription());
        remoteProjectRole.setId(projectRole.getId());
        remoteProjectRole.setName(projectRole.getName());
        return remoteProjectRole;
    }

    protected static Component[] convert(RemoteComponent[] remoteComponents) {
        Component[] components = new Component[remoteComponents.length];
        int i = 0;
        while (i < remoteComponents.length) {
            components[i] = JiraSoapConverter.convert(remoteComponents[i]);
            ++i;
        }
        return components;
    }

    protected static Component convert(RemoteComponent remoteComponent) {
        Component component = new Component();
        component.setId(remoteComponent.getId());
        component.setName(remoteComponent.getName());
        return component;
    }

    protected static User[] convert(RemoteUser[] remoteUsers) {
        User[] users = new User[remoteUsers.length];
        int i = 0;
        while (i < remoteUsers.length) {
            users[i] = JiraSoapConverter.convert(remoteUsers[i]);
            ++i;
        }
        return users;
    }

    protected static User convert(RemoteUser remoteUser) {
        User user = new User();
        user.setEmail(remoteUser.getEmail());
        user.setFullName(remoteUser.getFullname());
        user.setName(remoteUser.getName());
        return user;
    }

    protected static Group[] convert(RemoteGroup[] remoteGroups) {
        Group[] groups = new Group[remoteGroups.length];
        int i = 0;
        while (i < remoteGroups.length) {
            groups[i] = JiraSoapConverter.convert(remoteGroups[i]);
            ++i;
        }
        return groups;
    }

    protected static Group convert(RemoteGroup remoteGroup) {
        Group group = new Group();
        group.setName(remoteGroup.getName());
        group.setUsers(JiraSoapConverter.convert(remoteGroup.getUsers()));
        return group;
    }

    protected static ServerInfo convert(RemoteServerInfo remoteServerInfo, ServerInfo serverInfo) {
        serverInfo.setBaseUrl(remoteServerInfo.getBaseUrl());
        serverInfo.setBuildDate(remoteServerInfo.getBuildDate().getTime());
        serverInfo.setBuildNumber(remoteServerInfo.getBuildNumber());
        serverInfo.setEdition(remoteServerInfo.getEdition());
        serverInfo.setVersion(remoteServerInfo.getVersion());
        return serverInfo;
    }

    public static NamedFilter[] convert(RemoteFilter[] savedFilters) {
        NamedFilter[] namedFilters = new NamedFilter[savedFilters.length];
        int i = 0;
        while (i < savedFilters.length) {
            RemoteFilter savedFilter = savedFilters[i];
            NamedFilter filter = new NamedFilter();
            filter.setId(savedFilter.getId());
            filter.setName(savedFilter.getName());
            filter.setAuthor(savedFilter.getAuthor());
            filter.setDescription(savedFilter.getDescription());
            namedFilters[i] = filter;
            ++i;
        }
        return namedFilters;
    }

    public static Comment[] convert(RemoteComment[] remoteComments) {
        Comment[] comments = new Comment[remoteComments.length];
        int i = 0;
        while (i < remoteComments.length) {
            comments[i] = JiraSoapConverter.convert(remoteComments[i]);
            ++i;
        }
        return comments;
    }

    private static Comment convert(RemoteComment remoteComment) {
        Comment comment = new Comment();
        comment.setAuthor(remoteComment.getAuthor());
        comment.setComment(remoteComment.getBody());
        comment.setRoleLevel(remoteComment.getRoleLevel());
        return comment;
    }

    public static RemoteComment convert(Comment comment) {
        RemoteComment rComment = new RemoteComment();
        rComment.setAuthor(comment.getAuthor());
        rComment.setBody(comment.getComment());
        rComment.setRoleLevel(comment.getRoleLevel());
        return rComment;
    }

    protected static SecurityLevel[] convert(RemoteSecurityLevel[] remoteSecurityLevels) {
        SecurityLevel[] securityLevels = new SecurityLevel[remoteSecurityLevels.length];
        int i = 0;
        while (i < remoteSecurityLevels.length) {
            SecurityLevel securityLevel = new SecurityLevel();
            securityLevel.setId(remoteSecurityLevels[i].getId());
            securityLevel.setName(remoteSecurityLevels[i].getName());
            securityLevels[i] = securityLevel;
            ++i;
        }
        return securityLevels;
    }

    public static RemoteComponent[] convert(Component[] components) {
        RemoteComponent[] remoteComponents = new RemoteComponent[components.length];
        int i = 0;
        while (i < remoteComponents.length) {
            remoteComponents[i] = JiraSoapConverter.convert(components[i]);
            ++i;
        }
        return remoteComponents;
    }

    private static RemoteComponent convert(Component component) {
        return new RemoteComponent(component.getId(), component.getName());
    }

    public static RemoteVersion[] convert(Version[] reportedVersions) {
        RemoteVersion[] versions = new RemoteVersion[reportedVersions.length];
        int i = 0;
        while (i < versions.length) {
            versions[i] = JiraSoapConverter.convert(reportedVersions[i]);
            ++i;
        }
        return versions;
    }

    private static RemoteVersion convert(Version version) {
        Calendar releaseDate = null;
        if (version.getReleaseDate() != null) {
            releaseDate = Calendar.getInstance();
            releaseDate.setTime(version.getReleaseDate());
        }
        return new RemoteVersion(version.getId(), version.getName(), false, releaseDate, false, version.getSequence());
    }

    public static RemoteCustomFieldValue[] convert(RemoteFieldValue[] array) {
        RemoteCustomFieldValue[] fields = new RemoteCustomFieldValue[array.length];
        int i = 0;
        while (i < array.length) {
            fields[i] = JiraSoapConverter.convert(array[i]);
            ++i;
        }
        return fields;
    }

    private static RemoteCustomFieldValue convert(RemoteFieldValue remoteFieldValue) {
        return new RemoteCustomFieldValue(remoteFieldValue.getId(), null, remoteFieldValue.getValues());
    }

    public static JiraConfiguration convert(RemoteConfiguration remoteConf) {
        JiraConfiguration conf = new JiraConfiguration();
        conf.setTimeTrackingHoursPerDay(remoteConf.getTimeTrackingHoursPerDay());
        conf.setTimeTrackingDaysPerWeek(remoteConf.getTimeTrackingDaysPerWeek());
        conf.setAllowAttachments(remoteConf.isAllowAttachments());
        conf.setAllowExternalUserManagment(remoteConf.isAllowExternalUserManagment());
        conf.setAllowIssueLinking(remoteConf.isAllowIssueLinking());
        conf.setAllowSubTasks(remoteConf.isAllowSubTasks());
        conf.setAllowTimeTracking(remoteConf.isAllowTimeTracking());
        conf.setAllowUnassignedIssues(remoteConf.isAllowUnassignedIssues());
        conf.setAllowVoting(remoteConf.isAllowVoting());
        conf.setAllowWatching(remoteConf.isAllowWatching());
        return conf;
    }
}

