/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.soap;

import com.atlassian.connector.eclipse.internal.jira.core.JiraFieldType;
import com.atlassian.connector.eclipse.internal.jira.core.model.Comment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.CustomField;
import com.atlassian.connector.eclipse.internal.jira.core.model.Group;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraAction;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraConfiguration;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraVersion;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.NamedFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.ProjectRole;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.model.User;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraAuthenticationException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraCaptchaRequiredException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraInsufficientPermissionException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraServiceUnavailableException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraTimeFormat;
import com.atlassian.connector.eclipse.internal.jira.core.service.soap.JiraSoapConverter;
import com.atlassian.connector.eclipse.internal.jira.core.service.soap.JiraSoapServiceLocator;
import com.atlassian.connector.eclipse.internal.jira.core.service.soap.Messages;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.rss.JiraRssHandler;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteField;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteFieldValue;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteIssue;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteNamedObject;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteProjectRole;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteProjectRoleActors;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteSecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.beans.RemoteWorklog;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.soap.JiraSoapService;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.soap.RemoteAuthenticationException;
import com.atlassian.connector.eclipse.internal.jira.core.wsdl.soap.RemotePermissionException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.provisional.commons.soap.AbstractSoapClient;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraSoapClient
extends AbstractSoapClient {
    private static final String CONFIG_FILE = "com/atlassian/connector/eclipse/internal/jira/core/service/soap/client-config.wsdd";
    private static final String ERROR_RPC_NOT_ENABLED = "JIRA RPC services are not enabled. Please contact your JIRA administrator.";
    private static final String REMOTE_ERROR_BAD_ID = "White spaces are required between publicId and systemId.";
    private static final String REMOTE_ERROR_BAD_ENVELOPE_TAG = "Bad envelope tag:  html";
    private static final String REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG = "Content is not allowed in prolog.";
    private static final String REMOTE_ERROR_PROCESSING_INSTRUCTIONS = "Processing instructions are not allowed within SOAP messages";
    private static final String SOAP_SERVICE_URL = "/rpc/soap/jirasoapservice-v2";
    private static final long DEFAULT_SESSION_TIMEOUT = 600000L;
    private JiraSoapService soapService;
    private final Lock soapServiceLock = new ReentrantLock();
    private final LoginToken loginToken;
    private final JiraClient jiraClient;
    private boolean reauthenticate;

    public JiraSoapClient(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
        this.loginToken = new LoginToken(jiraClient.getLocation(), 600000L);
    }

    public JiraSoapService getSoapService() throws JiraException {
        this.soapServiceLock.lock();
        try {
            if (this.soapService == null) {
                JiraSoapServiceLocator locator = new JiraSoapServiceLocator((EngineConfiguration)new FileProvider(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CONFIG_FILE)), this.jiraClient);
                try {
                    this.soapService = locator.getJirasoapserviceV2(new URL(String.valueOf(this.jiraClient.getBaseUrl()) + SOAP_SERVICE_URL));
                }
                catch (ServiceException e) {
                    throw new JiraException(e);
                }
                catch (MalformedURLException e) {
                    throw new JiraException(e);
                }
                if (this.soapService == null) {
                    throw new JiraException("Initialization of JIRA Soap service failed");
                }
            }
            JiraSoapService jiraSoapService = this.soapService;
            return jiraSoapService;
        }
        finally {
            this.soapServiceLock.unlock();
        }
    }

    public User getUser(IProgressMonitor monitor, final String username) throws JiraException {
        return this.call(monitor, new Callable<User>(){

            @Override
            public User call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getUser(JiraSoapClient.this.loginToken.getCurrentValue(), username));
            }
        });
    }

    public Component[] getComponents(final String projectKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Component[]>(){

            @Override
            public Component[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getComponents(JiraSoapClient.this.loginToken.getCurrentValue(), projectKey));
            }
        });
    }

    public JiraConfiguration getConfiguration(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraConfiguration>(){

            @Override
            public JiraConfiguration call() throws Exception {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getConfiguration(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public String login(IProgressMonitor monitor) throws JiraException {
        this.loginToken.expire();
        return this.call(monitor, new Callable<String>(){

            @Override
            public String call() throws RemoteException, JiraException {
                return JiraSoapClient.this.loginToken.getCurrentValue();
            }
        });
    }

    public Group getGroup(final String name, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Group>(){

            @Override
            public Group call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getGroup(JiraSoapClient.this.loginToken.getCurrentValue(), name));
            }
        });
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws JiraException {
        ServerInfo serverInfo = this.call(monitor, new Callable<ServerInfo>(){

            @Override
            public ServerInfo call() throws RemoteException, JiraException {
                ServerInfo serverInfo = new ServerInfo();
                serverInfo.getStatistics().mark();
                try {
                    InetAddress.getByName(WebUtil.getHost((String)JiraSoapClient.this.getLocation().getUrl()));
                    serverInfo.getStatistics().record("Resolving name took {0}");
                }
                catch (Exception exception) {}
                serverInfo.getStatistics().mark();
                String session = JiraSoapClient.this.loginToken.getCurrentValue();
                serverInfo.getStatistics().record("Login via SOAP took {0}");
                serverInfo.getStatistics().mark();
                RemoteServerInfo remoteServerInfo = JiraSoapClient.this.getSoapService().getServerInfo(session);
                serverInfo.getStatistics().record("Retrieval of server info took {0}");
                return JiraSoapConverter.convert(remoteServerInfo, serverInfo);
            }
        });
        return serverInfo;
    }

    public String getKeyFromId(final String issueId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<String>(){

            @Override
            public String call() throws RemoteException, JiraException {
                RemoteIssue issue = JiraSoapClient.this.getSoapService().getIssueById(JiraSoapClient.this.loginToken.getCurrentValue(), issueId);
                return issue != null ? issue.getKey() : null;
            }
        });
    }

    public JiraAction[] getAvailableActions(final String taskKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraAction[]>(){

            @Override
            public JiraAction[] call() throws RemoteException, JiraException {
                RemoteNamedObject[] actions = JiraSoapClient.this.getSoapService().getAvailableActions(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey);
                if (actions == null) {
                    return new JiraAction[0];
                }
                JiraAction[] operations = new JiraAction[actions.length];
                int i = 0;
                while (i < actions.length) {
                    RemoteNamedObject action = actions[i];
                    operations[i] = new JiraAction(action.getId(), action.getName());
                    ++i;
                }
                return operations;
            }
        });
    }

    public String[] getActionFields(final String taskKey, final String actionId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<String[]>(){

            @Override
            public String[] call() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraSoapClient.this.getSoapService().getFieldsForAction(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey, actionId);
                if (remoteFields == null) {
                    return new String[0];
                }
                String[] fields = new String[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    fields[i] = remoteFields[i].getId();
                    ++i;
                }
                return fields;
            }
        });
    }

    public IssueField[] getEditableAttributes(final String taskKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueField[]>(){

            @Override
            public IssueField[] call() throws RemoteException, JiraException {
                RemoteField[] fields = JiraSoapClient.this.getSoapService().getFieldsForEdit(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey);
                if (fields == null) {
                    return new IssueField[0];
                }
                IssueField[] attributes = new IssueField[fields.length];
                int i = 0;
                while (i < fields.length) {
                    RemoteField field = fields[i];
                    attributes[i] = new IssueField(field.getId(), field.getName());
                    ++i;
                }
                return attributes;
            }
        });
    }

    public CustomField[] getCustomAttributes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<CustomField[]>(){

            @Override
            public CustomField[] call() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraSoapClient.this.getSoapService().getCustomFields(JiraSoapClient.this.loginToken.getCurrentValue());
                CustomField[] fields = new CustomField[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    RemoteField remoteField = remoteFields[i];
                    fields[i] = new CustomField(remoteField.getId(), null, remoteField.getName(), Collections.<String>emptyList());
                    ++i;
                }
                return fields;
            }
        });
    }

    public RemoteIssue getIssueByKey(final String key, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<RemoteIssue>(){

            @Override
            public RemoteIssue call() throws RemoteException, JiraException {
                return JiraSoapClient.this.getSoapService().getIssue(JiraSoapClient.this.loginToken.getCurrentValue(), key);
            }
        });
    }

    public Project[] getProjects(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Project[]>(){

            @Override
            public Project[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getProjectsNoSchemes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public ProjectRole[] getProjectRoles(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<ProjectRole[]>(){

            @Override
            public ProjectRole[] call() throws RemoteException, JiraException {
                RemoteProjectRole[] remoteProjectRoles = JiraSoapClient.this.getSoapService().getProjectRoles(JiraSoapClient.this.loginToken.getCurrentValue());
                return JiraSoapConverter.convert(remoteProjectRoles);
            }
        });
    }

    public JiraStatus[] getStatuses(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraStatus[]>(){

            @Override
            public JiraStatus[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getStatuses(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getSubTaskIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSubTaskIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Priority[] getPriorities(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Priority[]>(){

            @Override
            public Priority[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getPriorities(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Resolution[] getResolutions(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Resolution[]>(){

            @Override
            public Resolution[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getResolutions(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Comment[] getComments(final String issueKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Comment[]>(){

            @Override
            public Comment[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getComments(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey));
            }
        });
    }

    public Version[] getVersions(final String componentKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Version[]>(){

            @Override
            public Version[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getVersions(JiraSoapClient.this.loginToken.getCurrentValue(), componentKey));
            }
        });
    }

    public JiraWorkLog[] getWorkLogs(final String issueKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraWorkLog[]>(){

            @Override
            public JiraWorkLog[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getWorklogs(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey));
            }
        });
    }

    public void logout(IProgressMonitor monitor) throws JiraException {
        this.callOnce(monitor, new Callable<Object>(){

            @Override
            public Object call() throws RemoteException, JiraException {
                JiraSoapClient.this.loginToken.expire();
                return null;
            }
        });
    }

    public NamedFilter[] getNamedFilters(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<NamedFilter[]>(){

            @Override
            public NamedFilter[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSavedFilters(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getIssueTypes(final String projectId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                JiraSoapClient.this.getSoapService().getIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue());
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getIssueTypesForProject(JiraSoapClient.this.loginToken.getCurrentValue(), projectId));
            }
        });
    }

    public IssueType[] getSubTaskIssueTypes(final String projectId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSubTaskIssueTypesForProject(JiraSoapClient.this.loginToken.getCurrentValue(), projectId));
            }
        });
    }

    public void purgeSession() {
        this.reauthenticate = true;
    }

    static String unwrapRemoteException(RemoteException e) {
        AxisFault fault;
        Element httpErrorElement;
        if (e instanceof AxisFault && (httpErrorElement = (fault = (AxisFault)e).lookupFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE)) != null) {
            int responseCode = Integer.parseInt(httpErrorElement.getFirstChild().getTextContent());
            switch (responseCode) {
                case 500: {
                    return Messages.JiraSoapClient_Internal_Server_Error;
                }
                case 503: {
                    return ERROR_RPC_NOT_ENABLED;
                }
                case 404: {
                    return Messages.JiraSoapClient_No_JIRA_repository_found_at_location_or_proxy;
                }
                case 301: {
                    return Messages.JiraSoapClient_The_location_of_the_Jira_server_has_moved;
                }
            }
        }
        if (e.getCause() != null) {
            Throwable cause = e.getCause();
            if (cause instanceof UnknownHostException) {
                return Messages.JiraSoapClient_Unknown_host;
            }
            if (cause instanceof ConnectException) {
                return Messages.JiraSoapClient_Unable_to_connect_to_server;
            }
            if (cause instanceof SAXException && (REMOTE_ERROR_BAD_ENVELOPE_TAG.equalsIgnoreCase(cause.getMessage()) || REMOTE_ERROR_BAD_ID.equals(cause.getMessage()) || REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG.equals(cause.getMessage()) || REMOTE_ERROR_PROCESSING_INSTRUCTIONS.equals(cause.getMessage()))) {
                return ERROR_RPC_NOT_ENABLED;
            }
            return e.getCause().getLocalizedMessage();
        }
        if (e instanceof AxisFault) {
            return String.valueOf(Messages.JiraSoapClient_Server_error_) + e.getLocalizedMessage();
        }
        return e.getLocalizedMessage();
    }

    protected <T> T call(IProgressMonitor monitor, Callable<T> runnable) throws JiraException {
        try {
            return (T)super.call(monitor, runnable);
        }
        catch (JiraException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T callOnce(IProgressMonitor monitor, Callable<T> runnable) throws JiraException {
        try {
            return (T)super.callOnce(monitor, runnable);
        }
        catch (RemotePermissionException e) {
            throw new JiraInsufficientPermissionException(e.getFaultString());
        }
        catch (RemoteAuthenticationException e) {
            String msg = e.toString();
            if (msg.contains("maximum") || msg.contains("elevated security check")) {
                throw new JiraCaptchaRequiredException(e.getMessage());
            }
            throw new JiraAuthenticationException(e.getMessage());
        }
        catch (com.atlassian.connector.eclipse.internal.jira.core.wsdl.soap.RemoteException e) {
            String message = e.getMessage();
            if (message == null) {
                message = NLS.bind((String)"Service unavailabe: {0}", (Object)e.getFaultReason());
            }
            throw new JiraServiceUnavailableException(message);
        }
        catch (RemoteException e) {
            throw new JiraServiceUnavailableException(JiraSoapClient.unwrapRemoteException(e));
        }
        catch (JiraException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractWebLocation getLocation() {
        return this.jiraClient.getLocation();
    }

    protected boolean isAuthenticationException(Exception e) {
        return e instanceof JiraAuthenticationException && !(e instanceof JiraCaptchaRequiredException);
    }

    protected boolean doLogin(IProgressMonitor monitor) {
        this.loginToken.expire();
        return true;
    }

    public SecurityLevel[] getAvailableSecurityLevels(final String projectKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<SecurityLevel[]>(){

            @Override
            public SecurityLevel[] call() throws RemoteException, JiraException {
                RemoteSecurityLevel[] remoteSecurityLevels = JiraSoapClient.this.getSoapService().getSecurityLevels(JiraSoapClient.this.loginToken.getCurrentValue(), projectKey);
                if (remoteSecurityLevels == null) {
                    return new SecurityLevel[0];
                }
                SecurityLevel[] securityLevels = JiraSoapConverter.convert(remoteSecurityLevels);
                return securityLevels;
            }
        });
    }

    public JiraWorkLog addWorkLog(final String issueKey, final JiraWorkLog log, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraWorkLog>(){

            @Override
            public JiraWorkLog call() throws RemoteException, JiraException {
                JiraTimeFormat formatter = new JiraTimeFormat(JiraUtil.getWorkDaysPerWeek(JiraSoapClient.this.jiraClient), JiraUtil.getWorkHoursPerDay(JiraSoapClient.this.jiraClient));
                RemoteWorklog remoteLog = JiraSoapConverter.convert(log, formatter);
                switch (log.getAdjustEstimate()) {
                    case AUTO: {
                        remoteLog = JiraSoapClient.this.getSoapService().addWorklogAndAutoAdjustRemainingEstimate(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, remoteLog);
                        break;
                    }
                    case LEAVE: {
                        remoteLog = JiraSoapClient.this.getSoapService().addWorklogAndRetainRemainingEstimate(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, remoteLog);
                        break;
                    }
                    case SET: 
                    case REDUCE: {
                        remoteLog = JiraSoapClient.this.getSoapService().addWorklogWithNewRemainingEstimate(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, remoteLog, formatter.format(log.getNewRemainingEstimate()));
                    }
                }
                return remoteLog != null ? JiraSoapConverter.convert(remoteLog) : null;
            }
        });
    }

    public void addComment(final String issueKey, final Comment comment, IProgressMonitor monitor) throws JiraException {
        this.call(monitor, new Callable<Object>(){

            @Override
            public Object call() throws RemoteException, JiraException {
                JiraSoapClient.this.getSoapService().addComment(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, JiraSoapConverter.convert(comment));
                return null;
            }
        });
    }

    public void assignIssueTo(final String issueKey, final String user, IProgressMonitor monitor) throws JiraException {
        this.call(monitor, new Callable<Object>(){

            @Override
            public Object call() throws RemoteException, JiraException {
                RemoteFieldValue field = new RemoteFieldValue("assignee", new String[]{user});
                JiraSoapClient.this.getSoapService().updateIssue(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, new RemoteFieldValue[]{field});
                return null;
            }
        });
    }

    public User[] getProjectRoleUsers(final Project project, final ProjectRole projectRole, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<User[]>(){

            @Override
            public User[] call() throws Exception {
                RemoteProjectRoleActors actors = JiraSoapClient.this.getSoapService().getProjectRoleActors(JiraSoapClient.this.loginToken.getCurrentValue(), JiraSoapConverter.convert(projectRole), JiraSoapConverter.convert(project));
                return JiraSoapConverter.convert(actors.getUsers());
            }
        });
    }

    public void deleteIssue(final String issueKey, IProgressMonitor monitor) throws JiraException {
        this.call(monitor, new Callable<Object>(){

            @Override
            public Object call() throws RemoteException, JiraException {
                JiraSoapClient.this.getSoapService().deleteIssue(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey);
                return null;
            }
        });
    }

    public boolean addAttachmentsToIssue(final String issueKey, final String[] filenames, final byte[][] files, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Boolean>(){

            @Override
            public Boolean call() throws RemoteException, JiraException {
                return JiraSoapClient.this.getSoapService().addAttachmentsToIssue(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, filenames, files);
            }
        });
    }

    public boolean addAttachmentsBase64EncodedToIssue(final String issueKey, final String[] filenames, final String[] files, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Boolean>(){

            @Override
            public Boolean call() throws RemoteException, JiraException {
                return JiraSoapClient.this.getSoapService().addBase64EncodedAttachmentsToIssue(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, filenames, files);
            }
        });
    }

    public void updateIssue(final JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        this.call(monitor, new Callable<Object>(){

            @Override
            public Object call() throws RemoteException, JiraException {
                Version[] fixVersions;
                Version[] versions;
                int n;
                ArrayList<RemoteFieldValue> fields = new ArrayList<RemoteFieldValue>();
                fields.add(new RemoteFieldValue("summary", new String[]{issue.getSummary()}));
                fields.add(new RemoteFieldValue("issuetype", new String[]{issue.getType().getId()}));
                if (issue.getPriority() != null) {
                    fields.add(new RemoteFieldValue("priority", new String[]{issue.getPriority().getId()}));
                }
                if (issue.getDue() != null) {
                    DateFormat format = JiraSoapClient.this.jiraClient.getLocalConfiguration().getDateFormat();
                    fields.add(new RemoteFieldValue("duedate", new String[]{format.format(issue.getDue())}));
                } else {
                    fields.add(new RemoteFieldValue("duedate", new String[]{""}));
                }
                fields.add(new RemoteFieldValue("timetracking", new String[]{String.valueOf(Long.toString(issue.getEstimate() / 60L)) + "m"}));
                Component[] components = issue.getComponents();
                if (components != null) {
                    if (components.length == 0) {
                        fields.add(new RemoteFieldValue("components", new String[]{"-1"}));
                    } else {
                        ArrayList<String> values = new ArrayList<String>();
                        Component[] componentArray = components;
                        n = components.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component component = componentArray[n2];
                            values.add(component.getId());
                            ++n2;
                        }
                        fields.add(new RemoteFieldValue("components", values.toArray(new String[0])));
                    }
                }
                if ((versions = issue.getReportedVersions()) != null) {
                    if (versions.length == 0) {
                        fields.add(new RemoteFieldValue("versions", new String[]{"-1"}));
                    } else {
                        ArrayList<String> values = new ArrayList<String>();
                        Version[] versionArray = versions;
                        int n3 = versions.length;
                        n = 0;
                        while (n < n3) {
                            Version version = versionArray[n];
                            values.add(version.getId());
                            ++n;
                        }
                        fields.add(new RemoteFieldValue("versions", values.toArray(new String[0])));
                    }
                }
                if ((fixVersions = issue.getFixVersions()) != null) {
                    if (fixVersions.length == 0) {
                        fields.add(new RemoteFieldValue("fixVersions", new String[]{"-1"}));
                    } else {
                        ArrayList<String> values = new ArrayList<String>();
                        Version[] versionArray = fixVersions;
                        int n4 = fixVersions.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Version fixVersion = versionArray[n5];
                            values.add(fixVersion.getId());
                            ++n5;
                        }
                        fields.add(new RemoteFieldValue("fixVersions", values.toArray(new String[0])));
                    }
                }
                if (issue.getAssignee() != null) {
                    fields.add(new RemoteFieldValue("assignee", new String[]{issue.getAssignee()}));
                } else {
                    fields.add(new RemoteFieldValue("assignee", new String[]{"-1"}));
                }
                if (issue.getReporter() != null) {
                    fields.add(new RemoteFieldValue("reporter", new String[]{issue.getReporter()}));
                }
                if (issue.getEnvironment() != null) {
                    fields.add(new RemoteFieldValue("environment", new String[]{issue.getEnvironment()}));
                }
                fields.add(new RemoteFieldValue("description", new String[]{issue.getDescription()}));
                if (issue.getSecurityLevel() != null) {
                    fields.add(new RemoteFieldValue("security", new String[]{issue.getSecurityLevel().getId()}));
                } else {
                    fields.add(new RemoteFieldValue("security", new String[]{"-1"}));
                }
                JiraSoapClient.this.addCustomFields(fields, issue);
                JiraSoapClient.this.getSoapService().updateIssue(JiraSoapClient.this.loginToken.getCurrentValue(), issue.getKey(), fields.toArray(new RemoteFieldValue[fields.size()]));
                return null;
            }
        });
    }

    private void addCustomFields(List<RemoteFieldValue> fields, JiraIssue issue) {
        CustomField[] customFieldArray = issue.getCustomFields();
        int n = customFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomField customField = customFieldArray[n2];
            this.addCustomField(fields, customField);
            ++n2;
        }
    }

    private DecimalFormat getDecimalFormat() {
        DecimalFormat displayFormat = new DecimalFormat();
        displayFormat.setGroupingUsed(false);
        displayFormat.setMinimumFractionDigits(0);
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(this.jiraClient.getLocalConfiguration().getLocale());
        displayFormat.setDecimalFormatSymbols(formatSymbols);
        return displayFormat;
    }

    private void addCustomField(List<RemoteFieldValue> fields, CustomField customField) {
        for (String value : customField.getValues()) {
            String key = customField.getKey();
            if (!this.includeCustomField(key, value)) continue;
            if (value != null) {
                if (JiraFieldType.DATE.getKey().equals(key) || JiraFieldType.DATETIME.getKey().equals(key)) {
                    try {
                        Date date = JiraRssHandler.getDateTimeFormat().parse(value);
                        DateFormat format = JiraFieldType.DATE.getKey().equals(key) ? this.jiraClient.getLocalConfiguration().getDateFormat() : this.jiraClient.getLocalConfiguration().getDateTimeFormat();
                        value = format.format(date);
                    }
                    catch (ParseException parseException) {}
                } else if (JiraFieldType.FLOATFIELD.getKey().equals(key) && !this.jiraOlderThan42()) {
                    try {
                        value = this.getDecimalFormat().format(Double.parseDouble(value));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            fields.add(new RemoteFieldValue(customField.getId(), new String[]{value == null ? "" : value}));
        }
    }

    private boolean jiraOlderThan42() {
        return !this.jiraClient.getCache().hasDetails() || new JiraVersion(this.jiraClient.getCache().getServerInfo().getVersion()).compareTo(JiraVersion.JIRA_4_2) < 0;
    }

    private boolean includeCustomField(String key, String value) {
        if (key == null) {
            return true;
        }
        if (key.startsWith("com.pyxis.greenhopper.jira:greenhopper-ranking")) {
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return !key.startsWith("com.atlassian.jira.toolkit") && !key.startsWith("com.atlassian.jira.ext.charting");
    }

    public void progressWorkflowAction(final JiraIssue issue, final String actionKey, final String[] actionFields, IProgressMonitor monitor) throws JiraException {
        this.call(monitor, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ArrayList fields = new ArrayList();
                JiraSoapClient.this.addFields(fields, issue, actionFields);
                JiraSoapClient.this.getSoapService().progressWorkflowAction(JiraSoapClient.this.loginToken.getCurrentValue(), issue.getKey(), actionKey, fields.toArray(new RemoteFieldValue[fields.size()]));
                return null;
            }
        });
    }

    private void addFields(List<RemoteFieldValue> fields, JiraIssue issue, String[] actionFields) {
        String[] stringArray = actionFields;
        int n = actionFields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if ("duedate".equals(field)) {
                if (issue.getDue() != null) {
                    DateFormat format = this.jiraClient.getLocalConfiguration().getDateFormat();
                    fields.add(new RemoteFieldValue("duedate", new String[]{format.format(issue.getDue())}));
                } else {
                    fields.add(new RemoteFieldValue("duedate", new String[]{""}));
                }
            } else if (field.startsWith("customfield_")) {
                CustomField[] customFieldArray = issue.getCustomFields();
                int n3 = customFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CustomField customField = customFieldArray[n4];
                    this.addCustomField(fields, customField);
                    ++n4;
                }
            } else {
                String[] values = issue.getFieldValues(field);
                if (values != null) {
                    fields.add(new RemoteFieldValue(field, values));
                }
            }
            ++n2;
        }
    }

    public String createIssue(final JiraIssue issue, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<String>(){

            @Override
            public String call() throws Exception {
                RemoteIssue remoteIssue = new RemoteIssue();
                remoteIssue.setProject(issue.getProject().getKey());
                remoteIssue.setType(issue.getType().getId());
                remoteIssue.setSummary(issue.getSummary());
                if (issue.getPriority() != null) {
                    remoteIssue.setPriority(issue.getPriority().getId());
                }
                if (issue.getDue() != null) {
                    Calendar dueDate = Calendar.getInstance();
                    dueDate.setTime(issue.getDue());
                    remoteIssue.setDuedate(dueDate);
                }
                if (issue.getComponents() != null) {
                    remoteIssue.setComponents(JiraSoapConverter.convert(issue.getComponents()));
                }
                if (issue.getReportedVersions() != null) {
                    remoteIssue.setAffectsVersions(JiraSoapConverter.convert(issue.getReportedVersions()));
                }
                if (issue.getFixVersions() != null) {
                    remoteIssue.setFixVersions(JiraSoapConverter.convert(issue.getFixVersions()));
                }
                if (issue.getAssignee() == null) {
                    remoteIssue.setAssignee("-1");
                } else if (issue.getAssignee().length() == 0) {
                    remoteIssue.setAssignee("");
                } else {
                    remoteIssue.setAssignee(issue.getAssignee());
                }
                remoteIssue.setReporter(JiraSoapClient.this.jiraClient.getUserName());
                remoteIssue.setEnvironment(issue.getEnvironment() != null ? issue.getEnvironment() : "");
                remoteIssue.setDescription(issue.getDescription() != null ? issue.getDescription() : "");
                ArrayList fields = new ArrayList();
                JiraSoapClient.this.addCustomFields(fields, issue);
                remoteIssue.setCustomFieldValues(JiraSoapConverter.convert(fields.toArray(new RemoteFieldValue[0])));
                remoteIssue = issue.getSecurityLevel() != null ? JiraSoapClient.this.getSoapService().createIssueWithSecurityLevel(JiraSoapClient.this.loginToken.getCurrentValue(), remoteIssue, Long.parseLong(issue.getSecurityLevel().getId())) : JiraSoapClient.this.getSoapService().createIssue(JiraSoapClient.this.loginToken.getCurrentValue(), remoteIssue);
                if (remoteIssue != null && issue.getEstimate() != 0L) {
                    JiraSoapClient.this.getSoapService().updateIssue(JiraSoapClient.this.loginToken.getCurrentValue(), remoteIssue.getKey(), new RemoteFieldValue[]{new RemoteFieldValue("timetracking", new String[]{String.valueOf(Long.toString(issue.getEstimate() / 60L)) + "m"})});
                }
                return remoteIssue != null ? remoteIssue.getKey() : null;
            }
        });
    }

    private class LoginToken {
        private final long timeout;
        private String token;
        private long lastAccessed;
        private final AbstractWebLocation location;
        private AuthenticationCredentials credentials;

        public LoginToken(AbstractWebLocation location, long timeout) {
            this.location = location;
            this.timeout = timeout;
            this.lastAccessed = -1L;
        }

        public synchronized String getCurrentValue() throws JiraException, RemoteAuthenticationException, com.atlassian.connector.eclipse.internal.jira.core.wsdl.soap.RemoteException, RemoteException {
            AuthenticationCredentials newCredentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
            if (newCredentials == null) {
                this.expire();
                return "";
            }
            if (!newCredentials.equals((Object)this.credentials) || JiraSoapClient.this.reauthenticate) {
                JiraSoapClient.this.reauthenticate = false;
                this.expire();
                this.credentials = newCredentials;
            }
            if (System.currentTimeMillis() - this.lastAccessed >= this.timeout || this.token == null) {
                this.expire();
                this.token = JiraSoapClient.this.getSoapService().login(this.credentials.getUserName(), this.credentials.getPassword());
                this.lastAccessed = System.currentTimeMillis();
            }
            return this.token;
        }

        public synchronized void expire() {
            if (this.token != null) {
                try {
                    JiraSoapClient.this.getSoapService().logout(this.token);
                }
                catch (RemoteException remoteException) {
                }
                catch (JiraException jiraException) {}
                this.token = null;
                this.lastAccessed = -1L;
            }
        }

        public synchronized boolean isValidToken() {
            return this.token != null && System.currentTimeMillis() - this.lastAccessed < this.timeout;
        }

        public String toString() {
            long expiresIn = (this.timeout - (System.currentTimeMillis() - this.lastAccessed)) / 1000L;
            return "[credentials=" + this.credentials + ", timeout=" + this.timeout + ", valid=" + this.isValidToken() + ", expires=" + expiresIn + "]";
        }
    }
}

