/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.rest;

import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import com.atlassian.connector.eclipse.internal.jira.core.JiraFieldType;
import com.atlassian.connector.eclipse.internal.jira.core.model.AllowedValue;
import com.atlassian.connector.eclipse.internal.jira.core.model.Attachment;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.CustomField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueLink;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraAction;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.NamedFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.Subtask;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClientCache;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.rest.JiraRestCustomFieldsParser;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.BasicIssueType;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.FavouriteFilter;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.Visibility;
import com.atlassian.jira.rest.client.domain.Worklog;
import com.atlassian.jira.rest.client.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.WorklogInput;
import com.atlassian.jira.rest.client.domain.input.WorklogInputBuilder;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.osgi.util.NLS;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRestConverter {
    private JiraRestConverter() throws Exception {
        throw new Exception("Utility class");
    }

    public static Project[] convertProjects(Iterable<BasicProject> allProjects) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (BasicProject basicProject : allProjects) {
            projects.add(JiraRestConverter.convert(basicProject));
        }
        return projects.toArray(new Project[projects.size()]);
    }

    private static Project convert(BasicProject basicProject) {
        Project project = new Project();
        project.setName(basicProject.getName());
        project.setKey(basicProject.getKey());
        project.setId(basicProject.getId().toString());
        return project;
    }

    public static Resolution[] convertResolutions(Iterable<com.atlassian.jira.rest.client.domain.Resolution> allResolutions) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        for (com.atlassian.jira.rest.client.domain.Resolution resolution : allResolutions) {
            resolutions.add(JiraRestConverter.convert(resolution));
        }
        return resolutions.toArray(new Resolution[resolutions.size()]);
    }

    private static Resolution convert(com.atlassian.jira.rest.client.domain.Resolution resolution) {
        return new Resolution(resolution.getId().toString(), resolution.getName(), resolution.getDescription(), null);
    }

    public static Priority[] convertPriorities(Iterable<com.atlassian.jira.rest.client.domain.Priority> allPriorities) {
        ArrayList<Priority> priorities = new ArrayList<Priority>();
        for (com.atlassian.jira.rest.client.domain.Priority priority : allPriorities) {
            priorities.add(JiraRestConverter.convert(priority));
        }
        return priorities.toArray(new Priority[priorities.size()]);
    }

    private static Priority convert(com.atlassian.jira.rest.client.domain.Priority priority) {
        Priority outPriority = new Priority(priority.getId().toString());
        outPriority.setName(priority.getName());
        outPriority.setDescription(priority.getDescription());
        outPriority.setColour(priority.getStatusColor());
        outPriority.setIcon(priority.getIconUri().toString());
        outPriority.setSelf(priority.getSelf());
        return outPriority;
    }

    public static JiraIssue convertIssue(Issue issue, JiraClientCache cache, String url, IProgressMonitor monitor) throws JiraException {
        DateTime dueDate;
        Field env;
        Field security;
        Object parent;
        JiraIssue jiraIssue = new JiraIssue();
        jiraIssue.setRawIssue(issue);
        jiraIssue.setCustomFields(JiraRestConverter.getCustomFieldsFromIssue(issue));
        jiraIssue.setEditableFields(JiraRestConverter.getEditableFieldsFromIssue(issue));
        Project project = cache.getProjectByKey(issue.getProject().getKey());
        jiraIssue.setProject(project);
        if (project != null && !project.hasDetails()) {
            cache.refreshProjectDetails(project, monitor);
        } else if (project == null) {
            throw new JiraException(NLS.bind((String)"Project with key {0} not found in local cache. Please refresh repository configuration.", (Object)issue.getProject().getKey()));
        }
        jiraIssue.setId(issue.getId().toString());
        jiraIssue.setSelf(issue.getSelf());
        jiraIssue.setKey(issue.getKey());
        jiraIssue.setSummary(issue.getSummary());
        jiraIssue.setDescription(issue.getDescription());
        if (issue.getIssueType().isSubtask() && (parent = issue.getField("parent").getValue()) instanceof JSONObject) {
            jiraIssue.setParentKey(JsonParseUtil.getOptionalString((JSONObject)((JSONObject)parent), (String)"key"));
            jiraIssue.setParentId(JsonParseUtil.getOptionalString((JSONObject)((JSONObject)parent), (String)"id"));
        }
        if (issue.getPriority() != null) {
            jiraIssue.setPriority(cache.getPriorityById(issue.getPriority().getId().toString()));
        } else if (cache.getPriorities().length > 0) {
            jiraIssue.setPriority(cache.getPriorities()[0]);
        } else {
            jiraIssue.setPriority(null);
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Found issue with empty priority: {0}", (Object)issue.getKey())));
        }
        jiraIssue.setStatus(cache.getStatusById(issue.getStatus().getId().toString()));
        BasicUser assignee = issue.getAssignee();
        if (assignee != null) {
            jiraIssue.setAssignee(assignee.getName());
            jiraIssue.setAssigneeName(assignee.getDisplayName());
        }
        if (issue.getReporter() != null) {
            jiraIssue.setReporter(issue.getReporter().getName());
            jiraIssue.setReporterName(issue.getReporter().getDisplayName());
        }
        jiraIssue.setResolution(issue.getResolution() == null ? null : cache.getResolutionById(issue.getResolution().getId().toString()));
        if (issue.getTimeTracking() != null) {
            if (issue.getTimeTracking().getOriginalEstimateMinutes() != null) {
                jiraIssue.setInitialEstimate(issue.getTimeTracking().getOriginalEstimateMinutes() * 60);
            }
            if (issue.getTimeTracking().getRemainingEstimateMinutes() != null) {
                jiraIssue.setEstimate(issue.getTimeTracking().getRemainingEstimateMinutes() * 60);
            }
            if (issue.getTimeTracking().getTimeSpentMinutes() != null) {
                jiraIssue.setActual(issue.getTimeTracking().getTimeSpentMinutes() * 60);
            }
        }
        if ((security = issue.getField("security")) != null && security.getValue() != null && security.getValue() instanceof JSONObject) {
            JSONObject json = (JSONObject)security.getValue();
            try {
                String id = json.getString("id");
                String name = json.getString("name");
                SecurityLevel securityLevel = new SecurityLevel(id, name);
                jiraIssue.setSecurityLevel(securityLevel);
            }
            catch (JSONException e) {
                throw new JiraException(e);
            }
        }
        jiraIssue.setCreated(issue.getCreationDate().toDate());
        jiraIssue.setUpdated(issue.getUpdateDate().toDate());
        if (project != null && project.getIssueTypeById(issue.getIssueType().getId().toString()) != null) {
            jiraIssue.setType(project.getIssueTypeById(issue.getIssueType().getId().toString()));
        } else {
            jiraIssue.setType(cache.getIssueTypeById(issue.getIssueType().getId().toString()));
        }
        if (issue.getSubtasks() != null) {
            jiraIssue.setSubtasks(JiraRestConverter.convert(issue.getSubtasks()));
        }
        jiraIssue.setType(JiraRestConverter.convert(issue.getIssueType()));
        jiraIssue.setUrl(String.valueOf(url) + "/browse/" + issue.getKey());
        if (issue.getComponents() != null) {
            jiraIssue.setComponents(JiraRestConverter.convertComponents(issue.getComponents()));
        }
        if ((env = issue.getField("environment")) != null && env.getValue() != null) {
            jiraIssue.setEnvironment(env.getValue().toString());
        } else {
            jiraIssue.setEnvironment("");
        }
        if (issue.getAffectedVersions() != null) {
            jiraIssue.setReportedVersions(JiraRestConverter.convertVersions(issue.getAffectedVersions()));
        }
        if (issue.getFixVersions() != null) {
            jiraIssue.setFixVersions(JiraRestConverter.convertVersions(issue.getFixVersions()));
        }
        if ((dueDate = issue.getDueDate()) != null) {
            jiraIssue.setDue(dueDate.toDate());
        } else {
            jiraIssue.setDue(null);
        }
        if (issue.getIssueLinks() != null) {
            jiraIssue.setIssueLinks(JiraRestConverter.convertIssueLinks(issue.getIssueLinks()));
        }
        if (issue.getComments() != null) {
            jiraIssue.setComments(JiraRestConverter.convertComments(issue.getComments()));
        }
        if (issue.getAttachments() != null) {
            jiraIssue.setAttachments(JiraRestConverter.convertAttachments(issue.getAttachments()));
        }
        if (issue.getWorklogs() != null) {
            jiraIssue.setWorklogs(JiraRestConverter.convertWorklogs(issue.getWorklogs()));
        }
        jiraIssue.setRank(JiraRestConverter.getRankFromIssue(issue));
        if (issue.getLabels() != null) {
            jiraIssue.setLabels(issue.getLabels().toArray(new String[issue.getLabels().size()]));
        }
        return jiraIssue;
    }

    private static CustomField[] getCustomFieldsFromIssue(Issue issue) {
        JSONObject editmeta = JsonParseUtil.getOptionalJsonObject((JSONObject)issue.getRawObject(), (String)"editmeta");
        if (editmeta != null) {
            JSONObject fieldsFromEditMeta = JsonParseUtil.getOptionalJsonObject((JSONObject)editmeta, (String)"fields");
            if (fieldsFromEditMeta != null) {
                ArrayList<CustomField> customFields = new ArrayList<CustomField>();
                for (Field field : issue.getFields()) {
                    JSONObject jsonFieldFromEditMeta;
                    if (!field.getId().startsWith("customfield") || field.getValue() == null || (jsonFieldFromEditMeta = JsonParseUtil.getOptionalJsonObject((JSONObject)fieldsFromEditMeta, (String)field.getId())) == null) continue;
                    try {
                        JSONObject schema = (JSONObject)jsonFieldFromEditMeta.get("schema");
                        if (schema != null) {
                            String longType = JsonParseUtil.getOptionalString((JSONObject)schema, (String)"custom");
                            if (longType != null) {
                                CustomField customField = JiraRestConverter.generateCustomField(field, longType);
                                if (customField == null) continue;
                                customFields.add(customField);
                                continue;
                            }
                            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to parse type information (edit meta) for field [{0}].", (Object)field.getId())));
                            continue;
                        }
                        StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to parse type information (edit meta) for field [{0}].", (Object)field.getId())));
                    }
                    catch (JSONException jSONException) {
                        StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to parse type information (edit meta) for field [{0}].", (Object)field.getId())));
                    }
                }
                return customFields.toArray(new CustomField[customFields.size()]);
            }
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", "Unable to retrieve fields' type information (edit meta). Skipping custom fields parsing."));
        } else {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", "Unable to retrieve fields' type information (edit meta). Skipping custom fields parsing."));
        }
        return new CustomField[0];
    }

    private static IssueField[] getEditableFieldsFromIssue(Issue issue) {
        ArrayList<IssueField> editableFields = new ArrayList<IssueField>();
        JSONObject editmeta = JsonParseUtil.getOptionalJsonObject((JSONObject)issue.getRawObject(), (String)"editmeta");
        if (editmeta != null) {
            try {
                JSONObject fieldsFromEditMeta = JsonParseUtil.getNestedObject((JSONObject)editmeta, (String[])new String[]{"fields"});
                if (fieldsFromEditMeta != null) {
                    Iterator keys = fieldsFromEditMeta.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        JSONObject jsonFieldFromEditMeta = fieldsFromEditMeta.getJSONObject(key);
                        if (jsonFieldFromEditMeta != null) {
                            JSONObject schema;
                            boolean required = jsonFieldFromEditMeta.getBoolean("required");
                            String name = jsonFieldFromEditMeta.getString("name");
                            IssueField editableField = new IssueField(key, name);
                            editableField.setRequired(required);
                            Optional allowedValuesObject = JsonParseUtil.getOptionalArray((JSONObject)jsonFieldFromEditMeta, (String)"allowedValues");
                            if (allowedValuesObject != null && !Optional.absent().equals((Object)allowedValuesObject)) {
                                ArrayList<AllowedValue> allowedValues = new ArrayList<AllowedValue>();
                                JSONArray alloweValuesArray = (JSONArray)allowedValuesObject.get();
                                int i = 0;
                                while (i < alloweValuesArray.length()) {
                                    JSONObject allowedValue = alloweValuesArray.getJSONObject(i);
                                    String optionalId = JsonParseUtil.getOptionalString((JSONObject)allowedValue, (String)"id");
                                    String optionalValue = JsonParseUtil.getOptionalString((JSONObject)allowedValue, (String)"value");
                                    if (optionalValue != null && optionalId != null) {
                                        allowedValues.add(new AllowedValue(optionalId, optionalValue));
                                    }
                                    ++i;
                                }
                                editableField.setAllowedValues(allowedValues);
                            }
                            if ((schema = (JSONObject)jsonFieldFromEditMeta.get("schema")) != null) {
                                String longTypeCustom = JsonParseUtil.getOptionalString((JSONObject)schema, (String)"custom");
                                String longTypeSystem = JsonParseUtil.getOptionalString((JSONObject)schema, (String)"system");
                                if (longTypeCustom != null) {
                                    editableField.setType(longTypeCustom);
                                } else if (longTypeSystem != null) {
                                    editableField.setType(longTypeSystem);
                                }
                            }
                            editableFields.add(editableField);
                            continue;
                        }
                        StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to retrieve field' type information (edit meta) for [{0}]. Skipping this one.", (Object)key)));
                    }
                } else {
                    StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to retrieve 'fields' information (edit meta) for issue [{0}]. Skipping editable fields parsing.", (Object)issue.getKey())));
                }
            }
            catch (JSONException jSONException) {
                StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to parse type information (edit meta) for issue [{0}]. Skipping editable fields parsing.", (Object)issue.getKey())));
            }
        } else {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to retrieve 'editmeta' information for issue [{0}]. Skipping editable fields parsing.", (Object)issue.getKey())));
        }
        if (editableFields.size() > 0) {
            return editableFields.toArray(new IssueField[editableFields.size()]);
        }
        return new IssueField[0];
    }

    private static CustomField generateCustomField(Field field, String longType) {
        boolean readonly = false;
        try {
            JiraFieldType fieldType = JiraFieldType.fromKey(longType);
            ImmutableList values = null;
            switch (fieldType) {
                case TEXTAREA: 
                case TEXTFIELD: 
                case URL: 
                case EPIC_LABEL: {
                    values = ImmutableList.of((Object)field.getValue().toString());
                    break;
                }
                case DATE: 
                case DATETIME: {
                    values = ImmutableList.of((Object)field.getValue().toString());
                    break;
                }
                case FLOATFIELD: {
                    values = ImmutableList.of((Object)field.getValue().toString());
                    break;
                }
                case MULTIUSERPICKER: {
                    values = ImmutableList.of((Object)StringUtils.join(JiraRestCustomFieldsParser.parseMultiUserPicker(field), (String)", "));
                    break;
                }
                case USERPICKER: {
                    values = ImmutableList.of((Object)JiraRestCustomFieldsParser.parseUserPicker(field));
                    break;
                }
                case RADIOBUTTONS: 
                case SELECT: {
                    values = ImmutableList.of((Object)JiraRestCustomFieldsParser.parseSelect(field));
                    break;
                }
                case MULTICHECKBOXES: 
                case MULTISELECT: {
                    values = JiraRestCustomFieldsParser.parseMultiSelect(field);
                    break;
                }
                case LABELSS: {
                    values = ImmutableList.of((Object)StringUtils.join(JiraRestCustomFieldsParser.parseLabels(field), (String)" "));
                    readonly = true;
                    break;
                }
                case GROUPPICKER: {
                    values = ImmutableList.of((Object)JiraRestCustomFieldsParser.parseGroupPicker(field));
                    break;
                }
                case MULTIGROUPPICKER: {
                    values = ImmutableList.of((Object)StringUtils.join(JiraRestCustomFieldsParser.parseMultiGroupPicker(field), (String)", "));
                }
            }
            if (values != null && !values.isEmpty()) {
                CustomField customField = new CustomField(field.getId(), longType, field.getName(), (List<String>)values);
                customField.setReadOnly(readonly);
                return customField;
            }
        }
        catch (JSONException e) {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", e.getMessage()));
        }
        return null;
    }

    private static Integer getRankFromIssue(Issue issue) {
        JSONObject schemaFields = JsonParseUtil.getOptionalJsonObject((JSONObject)issue.getRawObject(), (String)IssueRestClient.Expandos.SCHEMA.getFieldName());
        if (schemaFields != null) {
            for (Field field : issue.getFields()) {
                JSONObject jsonFieldFromSchema;
                if (!field.getId().startsWith("customfield") || field.getValue() == null || (jsonFieldFromSchema = JsonParseUtil.getOptionalJsonObject((JSONObject)schemaFields, (String)field.getId())) == null) continue;
                String longType = JsonParseUtil.getOptionalString((JSONObject)jsonFieldFromSchema, (String)"custom");
                if (!JiraAttribute.RANK.getType().getKey().equals(longType)) continue;
                try {
                    return Integer.valueOf(field.getValue().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", NLS.bind((String)"Unable to parse Rank value [{0}].", (Object)field.getValue().toString())));
                }
            }
        } else {
            StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", "Unable to retrieve fields' type information (schema). Skipping searching for Rank."));
        }
        return null;
    }

    private static JiraWorkLog[] convertWorklogs(Iterable<Worklog> worklogs) {
        ArrayList<JiraWorkLog> outWorkLogs = new ArrayList<JiraWorkLog>();
        for (Worklog worklog : worklogs) {
            outWorkLogs.add(JiraRestConverter.convert(worklog));
        }
        return outWorkLogs.toArray(new JiraWorkLog[outWorkLogs.size()]);
    }

    private static JiraWorkLog convert(Worklog worklog) {
        JiraWorkLog outWorklog = new JiraWorkLog();
        if (worklog.getAuthor() != null) {
            outWorklog.setAuthor(worklog.getAuthor().getDisplayName());
        }
        outWorklog.setComment(worklog.getComment());
        outWorklog.setCreated(worklog.getCreationDate().toDate());
        outWorklog.setStartDate(worklog.getStartDate().toDate());
        outWorklog.setTimeSpent(worklog.getMinutesSpent() * 60);
        if (worklog.getUpdateAuthor() != null) {
            outWorklog.setUpdateAuthor(worklog.getUpdateAuthor().getDisplayName());
        }
        outWorklog.setUpdated(worklog.getUpdateDate().toDate());
        return outWorklog;
    }

    private static Attachment[] convertAttachments(Iterable<com.atlassian.jira.rest.client.domain.Attachment> attachments) {
        ArrayList<Attachment> outAttachments = new ArrayList<Attachment>();
        for (com.atlassian.jira.rest.client.domain.Attachment attachment : attachments) {
            outAttachments.add(JiraRestConverter.convert(attachment));
        }
        return outAttachments.toArray(new Attachment[outAttachments.size()]);
    }

    private static Attachment convert(com.atlassian.jira.rest.client.domain.Attachment attachment) {
        Attachment outAttachment = new Attachment();
        outAttachment.setId(attachment.getId().toString());
        BasicUser author = attachment.getAuthor();
        if (author != null && author.getName() != null) {
            outAttachment.setAuthor(author.getName());
        } else {
            outAttachment.setAuthor("unknown");
        }
        if (author != null && author.getDisplayName() != null) {
            outAttachment.setAuthorDisplayName(author.getDisplayName());
        } else {
            outAttachment.setAuthorDisplayName("Unknown");
        }
        outAttachment.setCreated(attachment.getCreationDate().toDate());
        outAttachment.setName(attachment.getFilename());
        outAttachment.setSize(attachment.getSize());
        outAttachment.setContent(attachment.getContentUri());
        return outAttachment;
    }

    private static com.atlassian.connector.eclipse.internal.jira.core.model.Comment[] convertComments(Iterable<Comment> comments) {
        ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.Comment> outComments = new ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.Comment>();
        for (Comment comment : comments) {
            outComments.add(JiraRestConverter.convert(comment));
        }
        return outComments.toArray(new com.atlassian.connector.eclipse.internal.jira.core.model.Comment[outComments.size()]);
    }

    private static com.atlassian.connector.eclipse.internal.jira.core.model.Comment convert(Comment comment) {
        com.atlassian.connector.eclipse.internal.jira.core.model.Comment outComment = new com.atlassian.connector.eclipse.internal.jira.core.model.Comment();
        BasicUser author = comment.getAuthor();
        if (author != null && author.getName() != null) {
            outComment.setAuthor(author.getName());
        } else {
            outComment.setAuthor("unknown");
        }
        if (author != null && author.getDisplayName() != null) {
            outComment.setAuthorDisplayName(author.getDisplayName());
        } else {
            outComment.setAuthorDisplayName("Unknown");
        }
        outComment.setComment(comment.getBody());
        outComment.setCreated(comment.getCreationDate().toDate());
        outComment.setMarkupDetected(false);
        Visibility visibility = comment.getVisibility();
        if (visibility != null) {
            outComment.setRoleLevel(visibility.getValue());
        }
        return outComment;
    }

    private static IssueLink[] convertIssueLinks(Iterable<com.atlassian.jira.rest.client.domain.IssueLink> issueLinks) {
        ArrayList<IssueLink> outIssueLinks = new ArrayList<IssueLink>();
        for (com.atlassian.jira.rest.client.domain.IssueLink issueLink : issueLinks) {
            outIssueLinks.add(JiraRestConverter.convert(issueLink));
        }
        return outIssueLinks.toArray(new IssueLink[outIssueLinks.size()]);
    }

    private static IssueLink convert(com.atlassian.jira.rest.client.domain.IssueLink issueLink) {
        IssueLink outIssueLink = new IssueLink(issueLink.getTargetIssueId().toString(), issueLink.getTargetIssueKey(), issueLink.getIssueLinkType().getName(), issueLink.getIssueLinkType().getName(), issueLink.getIssueLinkType().getDescription(), "");
        return outIssueLink;
    }

    static com.atlassian.connector.eclipse.internal.jira.core.model.Version[] convertVersions(Iterable<Version> versions) {
        ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.Version> outVersions = new ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.Version>();
        for (Version version : versions) {
            outVersions.add(JiraRestConverter.convert(version));
        }
        Collections.reverse(outVersions);
        return outVersions.toArray(new com.atlassian.connector.eclipse.internal.jira.core.model.Version[outVersions.size()]);
    }

    private static com.atlassian.connector.eclipse.internal.jira.core.model.Version convert(Version version) {
        com.atlassian.connector.eclipse.internal.jira.core.model.Version outVersion = new com.atlassian.connector.eclipse.internal.jira.core.model.Version(version.getId().toString(), version.getName());
        DateTime releaseDate = version.getReleaseDate();
        if (releaseDate != null) {
            outVersion.setReleaseDate(releaseDate.toDate());
        }
        outVersion.setArchived(version.isArchived());
        outVersion.setReleased(version.isReleased());
        return outVersion;
    }

    static Component[] convertComponents(Iterable<BasicComponent> components) {
        ArrayList<Component> outComponents = new ArrayList<Component>();
        for (BasicComponent component : components) {
            outComponents.add(JiraRestConverter.convert(component));
        }
        return outComponents.toArray(new Component[outComponents.size()]);
    }

    private static Component convert(BasicComponent component) {
        Component outComponent = new Component(component.getId().toString());
        outComponent.setName(component.getName());
        return outComponent;
    }

    private static com.atlassian.connector.eclipse.internal.jira.core.model.IssueType convert(BasicIssueType issueType) {
        com.atlassian.connector.eclipse.internal.jira.core.model.IssueType outIssueType = new com.atlassian.connector.eclipse.internal.jira.core.model.IssueType(issueType.getId().toString(), issueType.getName(), issueType.isSubtask());
        return outIssueType;
    }

    private static Subtask[] convert(Iterable<com.atlassian.jira.rest.client.domain.Subtask> allSubtasks) {
        ArrayList<Subtask> subtasks = new ArrayList<Subtask>();
        for (com.atlassian.jira.rest.client.domain.Subtask subtask : allSubtasks) {
            subtasks.add(JiraRestConverter.convert(subtask));
        }
        return subtasks.toArray(new Subtask[subtasks.size()]);
    }

    private static Subtask convert(com.atlassian.jira.rest.client.domain.Subtask subtask) {
        return new Subtask(subtask.getId().toString(), subtask.getIssueKey());
    }

    public static com.atlassian.connector.eclipse.internal.jira.core.model.IssueType[] convertIssueTypes(Iterable<IssueType> allIssueTypes) {
        ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.IssueType> issueTypes = new ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.IssueType>();
        for (IssueType issueType : allIssueTypes) {
            issueTypes.add(JiraRestConverter.convert(issueType));
        }
        return issueTypes.toArray(new com.atlassian.connector.eclipse.internal.jira.core.model.IssueType[issueTypes.size()]);
    }

    private static com.atlassian.connector.eclipse.internal.jira.core.model.IssueType convert(IssueType issueType) {
        com.atlassian.connector.eclipse.internal.jira.core.model.IssueType outIssueType = new com.atlassian.connector.eclipse.internal.jira.core.model.IssueType(issueType.getId().toString(), issueType.getName(), issueType.isSubtask());
        outIssueType.setDescription(issueType.getDescription());
        outIssueType.setIcon(issueType.getIconUri().toString());
        return outIssueType;
    }

    public static List<JiraIssue> convertIssues(Iterable<? extends BasicIssue> issues) {
        ArrayList<JiraIssue> outIssues = new ArrayList<JiraIssue>();
        for (BasicIssue basicIssue : issues) {
            outIssues.add(JiraRestConverter.convert(basicIssue));
        }
        return outIssues;
    }

    private static JiraIssue convert(BasicIssue issue) {
        JiraIssue outIssue = new JiraIssue();
        outIssue.setId(issue.getId().toString());
        outIssue.setKey(issue.getKey());
        outIssue.setSelf(issue.getSelf());
        return outIssue;
    }

    public static WorklogInput convert(JiraWorkLog jiraWorklog, URI uri) {
        WorklogInputBuilder worklogInputBuilder = new WorklogInputBuilder(uri);
        switch (jiraWorklog.getAdjustEstimate()) {
            case AUTO: {
                worklogInputBuilder.setAdjustEstimateAuto();
                break;
            }
            case LEAVE: {
                worklogInputBuilder.setAdjustEstimateLeave();
                break;
            }
            case SET: {
                worklogInputBuilder.setAdjustEstimateNew(String.valueOf(jiraWorklog.getNewRemainingEstimate() / 60L) + "m");
                break;
            }
            case REDUCE: {
                worklogInputBuilder.setAdjustEstimateManual(String.valueOf(jiraWorklog.getNewRemainingEstimate() / 60L) + "m");
            }
        }
        worklogInputBuilder.setComment(jiraWorklog.getComment());
        worklogInputBuilder.setStartDate(new DateTime((Object)jiraWorklog.getStartDate()));
        worklogInputBuilder.setTimeSpent(String.valueOf(String.valueOf(jiraWorklog.getTimeSpent() / 60L)) + "m");
        return worklogInputBuilder.build();
    }

    public static com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo convert(ServerInfo serverInfo) {
        com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo serverInfoOut = new com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo();
        serverInfoOut.setBaseUrl(serverInfo.getBaseUri().toString());
        serverInfoOut.setWebBaseUrl(serverInfo.getBaseUri().toString());
        serverInfoOut.setBuildDate(serverInfo.getBuildDate().toDate());
        serverInfoOut.setBuildNumber(Integer.valueOf(serverInfo.getBuildNumber()).toString());
        serverInfoOut.setVersion(serverInfo.getVersion());
        return serverInfoOut;
    }

    public static Iterable<JiraAction> convertTransitions(Iterable<Transition> transitions) {
        ArrayList<JiraAction> actions = new ArrayList<JiraAction>();
        for (Transition transition : transitions) {
            actions.add(JiraRestConverter.convert(transition));
        }
        return actions;
    }

    private static JiraAction convert(Transition transition) {
        JiraAction action = new JiraAction(Integer.toString(transition.getId()), transition.getName());
        for (Transition.Field field : transition.getFields()) {
            IssueField outField = new IssueField(field.getId(), field.getId());
            outField.setType(field.getType());
            outField.setRequired(field.isRequired());
            action.getFields().add(outField);
        }
        return action;
    }

    public static Iterable<Version> convert(com.atlassian.connector.eclipse.internal.jira.core.model.Version[] reportedVersions) {
        ArrayList<Version> outReportedVersions = new ArrayList<Version>();
        if (reportedVersions != null) {
            com.atlassian.connector.eclipse.internal.jira.core.model.Version[] versionArray = reportedVersions;
            int n = reportedVersions.length;
            int n2 = 0;
            while (n2 < n) {
                com.atlassian.connector.eclipse.internal.jira.core.model.Version version = versionArray[n2];
                outReportedVersions.add(JiraRestConverter.convert(version));
                ++n2;
            }
        }
        return outReportedVersions;
    }

    private static Version convert(com.atlassian.connector.eclipse.internal.jira.core.model.Version version) {
        Version outVersion = new Version(null, Long.valueOf(version.getId()), version.getName(), null, false, false, null);
        return outVersion;
    }

    public static Iterable<BasicComponent> convert(Component[] components) {
        ArrayList<BasicComponent> outComponents = new ArrayList<BasicComponent>();
        if (components != null) {
            Component[] componentArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                outComponents.add(JiraRestConverter.convert(component));
                ++n2;
            }
        }
        return outComponents;
    }

    private static BasicComponent convert(Component component) {
        return new BasicComponent(null, Long.valueOf(component.getId()), component.getName(), null);
    }

    public static NamedFilter[] convertNamedFilters(Iterable<FavouriteFilter> favouriteFilters) {
        ArrayList<NamedFilter> outFilters = new ArrayList<NamedFilter>();
        for (FavouriteFilter filter : favouriteFilters) {
            outFilters.add(JiraRestConverter.convert(filter));
        }
        return outFilters.toArray(new NamedFilter[outFilters.size()]);
    }

    private static NamedFilter convert(FavouriteFilter filter) {
        NamedFilter outFilter = new NamedFilter();
        outFilter.setId(filter.getId().toString());
        outFilter.setName(filter.getName());
        outFilter.setJql(filter.getJql());
        outFilter.setViewUrl(filter.getViewUrl().toString());
        return outFilter;
    }

    public static JiraStatus[] convertStatuses(Iterable<com.atlassian.jira.rest.client.domain.Status> statuses) {
        ArrayList<JiraStatus> outStatuses = new ArrayList<JiraStatus>();
        for (com.atlassian.jira.rest.client.domain.Status status : statuses) {
            outStatuses.add(JiraRestConverter.convert(status));
        }
        return outStatuses.toArray(new JiraStatus[outStatuses.size()]);
    }

    private static JiraStatus convert(com.atlassian.jira.rest.client.domain.Status status) {
        JiraStatus outStatus = new JiraStatus(status.getId().toString());
        outStatus.setName(status.getName());
        outStatus.setDescription(status.getDescription());
        outStatus.setIcon(status.getIconUrl().toString());
        return outStatus;
    }

    public static FieldInput convert(CustomField customField) {
        JiraFieldType fieldType = JiraFieldType.fromKey(customField.getKey());
        switch (fieldType) {
            case TEXTAREA: 
            case TEXTFIELD: 
            case URL: 
            case EPIC_LABEL: {
                if (customField.getValues().size() <= 0 || customField.getValues().get(0) == null) break;
                return new FieldInput(customField.getId(), (Object)customField.getValues().get(0));
            }
            case DATE: {
                if (customField.getValues().size() <= 0 || customField.getValues().get(0) == null || customField.getValues().get(0).length() <= 0) break;
                String date = null;
                try {
                    date = new DateTime((Object)Long.valueOf(customField.getValues().get(0))).toString("yyyy-MM-dd");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    date = new DateTime((Object)customField.getValues().get(0)).toString("yyyy-MM-dd");
                }
                return new FieldInput(customField.getId(), (Object)date);
            }
            case DATETIME: {
                if (customField.getValues().size() <= 0 || customField.getValues().get(0) == null || customField.getValues().get(0).length() <= 0) break;
                String date = null;
                try {
                    date = new DateTime((Object)customField.getValues().get(0)).toString("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    date = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss").withLocale(Locale.ENGLISH).parseDateTime(customField.getValues().get(0)).toString("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                }
                return new FieldInput(customField.getId(), (Object)date);
            }
            case FLOATFIELD: {
                if (customField.getValues().size() <= 0 || customField.getValues().get(0) == null || customField.getValues().get(0).length() <= 0) break;
                return new FieldInput(customField.getId(), (Object)Float.valueOf(Float.parseFloat(customField.getValues().get(0))));
            }
            case MULTIGROUPPICKER: 
            case MULTIUSERPICKER: {
                if (customField.getValues().size() <= 0 || customField.getValues().get(0) == null) break;
                ArrayList<ComplexIssueInputFieldValue> fields = new ArrayList<ComplexIssueInputFieldValue>();
                List<String> items = Arrays.asList(customField.getValues().get(0).split(","));
                for (String item : items) {
                    fields.add(ComplexIssueInputFieldValue.with((String)"name", (Object)StringUtils.strip((String)item)));
                }
                return new FieldInput(customField.getId(), fields);
            }
            case GROUPPICKER: 
            case USERPICKER: {
                if (customField.getValues().size() <= 0 || customField.getValues().get(0) == null) break;
                return new FieldInput(customField.getId(), (Object)ComplexIssueInputFieldValue.with((String)"name", (Object)customField.getValues().get(0)));
            }
            case RADIOBUTTONS: 
            case SELECT: {
                if (customField.getValues().size() <= 0) break;
                if ("-1".equals(customField.getValues().get(0))) {
                    return new FieldInput(customField.getId(), (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)"-1"));
                }
                String value = customField.getValues().get(0);
                return new FieldInput(customField.getId(), (Object)ComplexIssueInputFieldValue.with((String)"value", (Object)value));
            }
            case MULTICHECKBOXES: 
            case MULTISELECT: {
                ArrayList<ComplexIssueInputFieldValue> values = new ArrayList<ComplexIssueInputFieldValue>();
                for (String value : customField.getValues()) {
                    values.add(ComplexIssueInputFieldValue.with((String)"value", (Object)value));
                }
                return new FieldInput(customField.getId(), values);
            }
            case LABELSS: {
                if (customField.getValues().size() <= 0) break;
                return new FieldInput(customField.getId(), customField.getValues());
            }
            default: {
                return null;
            }
        }
        return new FieldInput(customField.getId(), null);
    }
}

