/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.springsource.ide.eclipse.commons.frameworks.core.FrameworkCoreActivator;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.AbstractLegacyConverter;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.IConversionConstants;

public class LegacyWorkspaceConverter
extends AbstractLegacyConverter
implements IConversionConstants {
    private static final IPreferenceStore PREFERENCE_STORE = FrameworkCoreActivator.getDefault().getPreferenceStore();

    public boolean shouldAutoConvert() {
        return !PREFERENCE_STORE.getBoolean("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.done");
    }

    @Override
    public IStatus convert(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        IStatus[] statuses = new IStatus[]{this.copyPluginPreferences(sub), Status.OK_STATUS, this.convertRooWorkspacePreferences(sub), this.convertSTSPreferences(sub)};
        MultiStatus result = new MultiStatus("org.springsource.ide.eclipse.commons.frameworks.core", 0, statuses, "Result of converting legacy STS 2.x workspace preferences to 3.x", null);
        if (result.isOK()) {
            PREFERENCE_STORE.setValue("org.springsource.ide.eclipse.commons.frameworks.ui.legacyconversion.done", true);
        }
        return result;
    }

    private IStatus copyPluginPreferences(SubMonitor sub) {
        sub.subTask("Copying plugin preferences for legacy STS workspace");
        try {
            File prefsFolder = InternalPlatform.getDefault().getRuntimeInstance().getStateLocation().toFile();
            prefsFolder = new File(prefsFolder, ".settings");
            int i = 0;
            while (i < STS_OLD_WORKSPACE_PREFS.length) {
                if (!STS_NEW_WORKSPACE_PREFS[i].equals("???")) {
                    this.copyPreferencesFile(new File(prefsFolder, String.valueOf(STS_OLD_WORKSPACE_PREFS[i]) + ".prefs"), new File(prefsFolder, String.valueOf(STS_NEW_WORKSPACE_PREFS[i]) + ".prefs"), STS_OLD_WORKSPACE_PREFS[i], STS_NEW_WORKSPACE_PREFS[i]);
                    InstanceScope.INSTANCE.getNode(STS_NEW_WORKSPACE_PREFS[i]).sync();
                }
                ++i;
            }
        }
        catch (Exception e) {
            return new Status(4, "org.springsource.ide.eclipse.commons.frameworks.core", "Failed to convert legacy STS workspace preferences", (Throwable)e);
        }
        return new Status(0, "org.springsource.ide.eclipse.commons.frameworks.core", "Converted legacy STS plugin preferences");
    }

    private IStatus convertSTSPreferences(SubMonitor sub) {
        sub.subTask("Converting STS plugin state locations");
        try {
            this.copyPluginStateLocation("com.springsource.sts.content.core", "org.springsource.ide.eclipse.commons.content.core");
            this.copyPluginStateLocation("com.springsource.sts.core", "org.springsource.ide.eclipse.commons.core");
            this.copyPluginStateLocation("com.springsource.sts.ide.ui", "org.springsource.ide.eclipse.dashboard.ui");
            Status status = new Status(0, "org.springsource.ide.eclipse.commons.frameworks.core", "Converted legacy STS plugin state locations");
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.springsource.ide.eclipse.commons.frameworks.core", "Failed to convert legacy STS plugin state locations", (Throwable)e);
            return status;
        }
        finally {
            sub.worked(1);
        }
    }

    private IStatus convertRooWorkspacePreferences(SubMonitor sub) {
        sub.subTask("Converting Roo plugin state locations");
        try {
            this.copyPluginStateLocation("com.springsource.sts.roo.ui", "org.springframework.ide.eclipse.roo.ui");
            Status status = new Status(0, "org.springsource.ide.eclipse.commons.frameworks.core", "Converted legacy Roo plugin state locations");
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.springsource.ide.eclipse.commons.frameworks.core", "Failed to convert legacy Roo plugin state locations", (Throwable)e);
            return status;
        }
        finally {
            sub.worked(1);
        }
    }
}

