/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.AbstractLegacyConverter;
import org.springsource.ide.eclipse.commons.frameworks.core.legacyconversion.IConversionConstants;

public class LegacyProjectConverter
extends AbstractLegacyConverter
implements IConversionConstants {
    private final List<IProject> allLegacyProjects;
    private IProject[] selectedLegacyProjects;

    public LegacyProjectConverter(IProject legacyProject) {
        this.allLegacyProjects = Collections.singletonList(legacyProject);
        this.selectedLegacyProjects = new IProject[]{legacyProject};
    }

    public LegacyProjectConverter(List<IProject> legacyProjects) {
        this.allLegacyProjects = legacyProjects;
    }

    public List<IProject> getAllLegacyProjects() {
        return this.allLegacyProjects;
    }

    public IProject[] getSelectedLegacyProjects() {
        return this.selectedLegacyProjects;
    }

    public void setSelectedLegacyProjects(IProject[] selectedLegacyProjects) {
        this.selectedLegacyProjects = selectedLegacyProjects;
    }

    @Override
    public IStatus convert(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.selectedLegacyProjects.length);
        IStatus[] statuses = new IStatus[this.selectedLegacyProjects.length];
        int i = 0;
        IProject[] iProjectArray = this.selectedLegacyProjects;
        int n = this.selectedLegacyProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                sub.subTask("Converting " + project.getName());
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                statuses[i++] = this.convert(project, monitor);
            } else {
                statuses[i++] = Status.OK_STATUS;
            }
            sub.worked(1);
            ++n2;
        }
        return new MultiStatus("org.springsource.ide.eclipse.commons.frameworks.core", 0, statuses, "Result of converting legacy maven projects", null);
    }

    private IStatus convert(IProject project, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        Job.getJobManager().beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), (IProgressMonitor)sub);
        try {
            try {
                if (project.hasNature("com.springsource.sts.grails.core.nature")) {
                    this.convertGrailsProject(project, sub);
                } else if (project.hasNature("com.springsource.sts.roo.core.nature")) {
                    this.convertRooProject(project, sub);
                } else if (project.hasNature("com.springsource.sts.gradle.core.nature")) {
                    LegacyProjectConverter.convertGradleProject(project, sub);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.springsource.ide.eclipse.commons.frameworks.core", "Failed to convert " + project.getName(), (Throwable)e);
                Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                return status;
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        sub.worked(1);
        return new Status(0, "org.springsource.ide.eclipse.commons.frameworks.core", "Converted " + project.getName());
    }

    private static void convertGradleProject(IProject project, SubMonitor sub) throws Exception {
        IProjectDescription description = project.getDescription();
        String[] ids = description.getNatureIds();
        ArrayList<String> newIds = new ArrayList<String>(ids.length);
        int i = 0;
        while (i < ids.length) {
            if (!ids[i].equals("com.springsource.sts.gradle.core.nature") && !ids[i].equals("org.springsource.ide.eclipse.gradle.core.nature")) {
                newIds.add(ids[i]);
            } else {
                newIds.add("org.springsource.ide.eclipse.gradle.core.nature");
            }
            ++i;
        }
        description.setNatureIds(newIds.toArray(new String[0]));
        project.setDescription(description, (IProgressMonitor)sub);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
        int i2 = 0;
        while (i2 < classpath.length) {
            String path;
            IClasspathEntry entry = classpath[i2];
            if (entry.getEntryKind() == 5 && (path = entry.getPath().toString()).contains("com.springsource.sts.gradle")) {
                entry = JavaCore.newContainerEntry((IPath)new Path(path.replace("com.springsource.sts.gradle", "org.springsource.ide.eclipse.gradle")), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])entry.getExtraAttributes(), (boolean)entry.isExported());
            }
            newClasspath.add(entry);
            ++i2;
        }
        javaProject.setRawClasspath(newClasspath.toArray(new IClasspathEntry[0]), (IProgressMonitor)sub);
    }

    private void convertGrailsProject(IProject project, SubMonitor sub) throws Exception {
        IProjectDescription description = project.getDescription();
        String[] ids = description.getNatureIds();
        ArrayList<String> newIds = new ArrayList<String>(ids.length);
        int i = 0;
        while (i < ids.length) {
            if (!ids[i].equals("com.springsource.sts.grails.core.nature") && !ids[i].equals("org.grails.ide.eclipse.core.nature")) {
                newIds.add(ids[i]);
            } else {
                newIds.add("org.grails.ide.eclipse.core.nature");
            }
            ++i;
        }
        description.setNatureIds(newIds.toArray(new String[0]));
        project.setDescription(description, (IProgressMonitor)sub);
        IFolder preferencesFolder = project.getFolder(".settings/");
        File settingsFile = preferencesFolder.getFile("com.springsource.sts.grails.core.prefs").getLocation().toFile();
        File newSettingsFile = preferencesFolder.getFile("org.grails.ide.eclipse.core.prefs").getLocation().toFile();
        this.copyPreferencesFile(settingsFile, newSettingsFile, "com.springsource.sts.grails", "org.grails.ide.eclipse");
        InstanceScope.INSTANCE.getNode("com.springsource.sts.grails.core").sync();
        preferencesFolder.refreshLocal(1, (IProgressMonitor)sub);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newClasspath = new ArrayList<IClasspathEntry>();
        int i2 = 0;
        while (i2 < classpath.length) {
            if (classpath[i2].getPath().toString().equals("com.springsource.sts.grails.core.CLASSPATH_CONTAINER")) {
                newClasspath.add(JavaCore.newContainerEntry((IPath)new Path("org.grails.ide.eclipse.core.CLASSPATH_CONTAINER"), (IAccessRule[])classpath[i2].getAccessRules(), (IClasspathAttribute[])this.convertGrailsClasspathAttributes(classpath[i2]), (boolean)classpath[i2].isExported()));
            } else if (classpath[i2].getEntryKind() == 3) {
                newClasspath.add(JavaCore.newSourceEntry((IPath)classpath[i2].getPath(), (IPath[])classpath[i2].getInclusionPatterns(), (IPath[])classpath[i2].getExclusionPatterns(), (IPath)classpath[i2].getOutputLocation(), (IClasspathAttribute[])this.convertGrailsClasspathAttributes(classpath[i2])));
            } else {
                newClasspath.add(classpath[i2]);
            }
            ++i2;
        }
        javaProject.setRawClasspath(newClasspath.toArray(new IClasspathEntry[0]), (IProgressMonitor)sub);
    }

    private IClasspathAttribute[] convertGrailsClasspathAttributes(IClasspathEntry entry) {
        IClasspathAttribute[] oldAttributes = entry.getExtraAttributes();
        if (oldAttributes == null || oldAttributes.length == 0) {
            return new IClasspathAttribute[0];
        }
        IClasspathAttribute[] newAttributes = new IClasspathAttribute[oldAttributes.length];
        int i = 0;
        while (i < oldAttributes.length) {
            newAttributes[i] = oldAttributes[i].getName().equals("com.springsource.sts.grails.core.SOURCE_FOLDER") ? JavaCore.newClasspathAttribute((String)"org.grails.ide.eclipse.core.SOURCE_FOLDER", (String)oldAttributes[i].getValue()) : oldAttributes[i];
            ++i;
        }
        return newAttributes;
    }

    private void convertRooProject(IProject project, SubMonitor sub) throws Exception {
        IFolder preferencesFolder = project.getFolder(".settings/");
        File settingsFile = preferencesFolder.getFile("com.springsource.sts.roo.core.prefs").getLocation().toFile();
        File newSettingsFile = preferencesFolder.getFile("org.springframework.ide.eclipse.roo.core.prefs").getLocation().toFile();
        this.copyPreferencesFile(settingsFile, newSettingsFile, "com.springsource.sts.roo.core", "org.springframework.ide.eclipse.roo.core");
        InstanceScope.INSTANCE.getNode("com.springsource.sts.roo.core").sync();
        preferencesFolder.refreshLocal(1, (IProgressMonitor)sub);
    }
}

