/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.wizard.core.WizardContentAssistConverter;
import org.springframework.ide.eclipse.wizard.ui.BeanWizard;

public abstract class BeanChildDialog
extends Dialog {
    protected IDOMElement element;
    protected BeanWizard wizard;
    private CLabel messageLabel;
    private final boolean isNew;
    private final String title;

    protected BeanChildDialog(Shell parentShell, BeanWizard wizard, IDOMElement element, String title, boolean isNew) {
        super(parentShell);
        this.wizard = wizard;
        this.element = element;
        this.title = title;
        this.isNew = isNew;
    }

    protected void addListener(final Text text, final String attributeName) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanChildDialog.this.updateAttribute(attributeName, text.getText());
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.resetAttributes();
        }
        super.buttonPressed(buttonId);
    }

    protected abstract void createAttributes(Composite var1);

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (!this.isNew) {
            this.validateAttributes();
        }
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite container = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 500;
        container.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        this.messageLabel = new CLabel(container, 0);
        this.messageLabel.setText(this.getDefaultMessage());
        GridData descriptionData = new GridData(4, 4, true, false);
        descriptionData.horizontalSpan = 2;
        descriptionData.verticalIndent = 5;
        this.messageLabel.setLayoutData((Object)descriptionData);
        this.createAttributes(container);
        return container;
    }

    protected abstract boolean getCanFinish();

    protected abstract String getDefaultMessage();

    protected abstract String getMessage();

    protected void resetAttribute(String attributeName, String originalValue) {
        if (originalValue != null) {
            this.element.setAttribute(attributeName, originalValue);
        } else {
            this.element.removeAttribute(attributeName);
        }
    }

    protected abstract void resetAttributes();

    protected void updateAttribute(String attributeName, String value) {
        if (value.length() > 0) {
            this.element.setAttribute(attributeName, value);
        } else {
            this.element.removeAttribute(attributeName);
        }
        this.validateAttribute(attributeName, value);
    }

    private void updateButton() {
        this.getButton(0).setEnabled(this.getCanFinish());
    }

    protected void updateMessage() {
        String message = this.getMessage();
        if (message != null) {
            if (BeanWizard.getIgnoreError()) {
                this.messageLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            } else {
                this.messageLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
            }
            this.messageLabel.setText(message);
        } else {
            this.messageLabel.setImage(null);
            this.messageLabel.setText(this.getDefaultMessage());
        }
        this.messageLabel.redraw();
    }

    protected void validateAttribute(String attributeName, String value) {
        WizardContentAssistConverter contentAssistConverter = new WizardContentAssistConverter((IDOMNode)this.element, this.element.getAttributeNode(attributeName), this.wizard.getBeanFile(), this.wizard.getOriginalDocument());
        this.validateAttribute(attributeName, value, contentAssistConverter);
        this.updateButton();
    }

    protected abstract void validateAttribute(String var1, String var2, WizardContentAssistConverter var3);

    protected abstract void validateAttributes();
}

