/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springframework.ide.eclipse.wizard.template.IWizardPageStatusHandler;

public abstract class WizardPageArea {
    private final IWizardPageStatusHandler statusHandler;
    private IStatus validationStatus;
    private boolean isAreaComplete = true;

    public WizardPageArea(IWizardPageStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
        statusHandler.addPageArea(this);
    }

    public abstract Control createArea(Composite var1);

    protected void notifyStatusChange() {
        if (this.statusHandler != null) {
            this.statusHandler.notifyStatusChange(this);
        }
    }

    public boolean isAreaComplete() {
        return this.isAreaComplete;
    }

    protected void setAreaComplete(boolean isAreaComplete) {
        this.isAreaComplete = isAreaComplete;
    }

    protected IStatus createStatus(String message, int severity) {
        return new Status(severity, "org.springframework.ide.eclipse.wizard", message);
    }

    protected void notifyStatusChange(IStatus status, boolean isAreaComplete) {
        this.isAreaComplete = isAreaComplete;
        this.validationStatus = status;
        this.notifyStatusChange();
    }

    protected void notifyStatusChange(IStatus status) {
        this.validationStatus = status;
        this.notifyStatusChange();
    }

    public IStatus getValidationStatus(boolean refresh) {
        if (refresh) {
            this.validationStatus = this.validateArea();
        }
        return this.validationStatus;
    }

    public IStatus getValidationStatus() {
        return this.getValidationStatus(false);
    }

    protected abstract IStatus validateArea();

    public void refreshUI() {
    }
}

