/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.springframework.ide.eclipse.wizard.WizardImages;
import org.springframework.ide.eclipse.wizard.template.DownloadDescriptorJob;
import org.springframework.ide.eclipse.wizard.template.ErrorUtils;
import org.springframework.ide.eclipse.wizard.template.IWizardPageStatusHandler;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardModel;
import org.springframework.ide.eclipse.wizard.template.SimpleProject;
import org.springframework.ide.eclipse.wizard.template.TemplateContentProvider;
import org.springframework.ide.eclipse.wizard.template.TemplateUtils;
import org.springframework.ide.eclipse.wizard.template.WizardPageArea;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateElement;
import org.springframework.ide.eclipse.wizard.template.infrastructure.SimpleProjectContentManager;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.TemplateCategory;
import org.springframework.ide.eclipse.wizard.template.util.TemplatesPreferencesModel;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;
import org.springsource.ide.eclipse.commons.content.core.ContentManager;
import org.springsource.ide.eclipse.commons.content.core.ContentPlugin;
import org.springsource.ide.eclipse.commons.content.core.util.ContentUtil;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;
import org.springsource.ide.eclipse.commons.ui.StsUiImages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateSelectionPart
extends WizardPageArea {
    public static final String SIMPLE_PROJECTS_CATEGORY = "Simple Projects";
    private final List<Template> templates;
    private final IWizard wizard;
    private Label descriptionLabel;
    private StyledText descriptionText;
    private TreeViewer treeViewer;
    private Label legendImage;
    private Label legendText;
    private PropertyChangeListener contentManagerListener;
    private Button refreshButton;
    private final NewSpringProjectWizardModel model;

    public TemplateSelectionPart(IWizard wizard, NewSpringProjectWizardModel model, IWizardPageStatusHandler statusHandler) {
        super(statusHandler);
        this.wizard = wizard;
        this.model = model;
        this.templates = new ArrayList<Template>();
    }

    @Override
    public Control createArea(Composite parent) {
        this.initialiseTemplatesFromContentManager();
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(container, 0);
        label.setText("Templates:");
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        Tree tree = new Tree(container, 67584);
        tree.setLinesVisible(false);
        tree.setHeaderVisible(false);
        tree.setEnabled(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 170;
        tree.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (element instanceof ITemplateElement) {
                    return ((ITemplateElement)element).getName();
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof Template) {
                    Template template = (Template)element;
                    Image templateImage = WizardImages.getImage(WizardImages.TEMPLATE_ICON);
                    if (template instanceof SimpleProject || (template.getItem().isLocal() || TemplateUtils.hasBeenDownloaded(template)) && !template.getItem().isNewerVersionAvailable()) {
                        return templateImage;
                    }
                    ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
                    imageDescriptorArray[0] = StsUiImages.DOWNLOAD_OVERLAY;
                    return WizardImages.getImage((ImageDescriptor)new DecorationOverlayIcon(templateImage, imageDescriptorArray));
                }
                if (element instanceof TemplateCategory) {
                    return WizardImages.getImage(WizardImages.TEMPLATE_CATEGORY_ICON);
                }
                return null;
            }
        });
        this.treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof TemplateCategory && e2 instanceof Template) {
                    return -1;
                }
                if (e1 instanceof Template && e2 instanceof TemplateCategory) {
                    return 1;
                }
                if (e1 instanceof ITemplateElement && e2 instanceof ITemplateElement) {
                    ITemplateElement t1 = (ITemplateElement)e1;
                    ITemplateElement t2 = (ITemplateElement)e2;
                    if (t1.getName().equals(TemplateSelectionPart.SIMPLE_PROJECTS_CATEGORY)) {
                        return -1;
                    }
                    if (t2.getName().equals(TemplateSelectionPart.SIMPLE_PROJECTS_CATEGORY)) {
                        return 1;
                    }
                    return t1.getName().compareTo(t2.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.treeViewer.setInput(this.templates);
        Composite legendContainer = new Composite(container, 0);
        legendContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = 0;
        headerLayout.marginHeight = 0;
        legendContainer.setLayout((Layout)headerLayout);
        Composite legendComposite = new Composite(legendContainer, 0);
        GridLayout legendLayout = new GridLayout(2, false);
        legendLayout.verticalSpacing = 0;
        legendLayout.marginHeight = 0;
        legendLayout.marginBottom = 0;
        int legendControlVerticalIndent = 5;
        legendComposite.setLayout((Layout)legendLayout);
        legendComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.legendImage = new Label(legendComposite, 0);
        GridDataFactory.fillDefaults().grab(false, false).indent(0, legendControlVerticalIndent).applyTo((Control)this.legendImage);
        this.legendImage.setImage(WizardImages.getImage(StsUiImages.DOWNLOAD_OVERLAY));
        this.legendImage.setToolTipText("Templates with this icon will be downloaded after clicking the 'Next' button.");
        this.legendText = new Label(legendComposite, 0);
        this.legendText.setText("requires downloading");
        GridDataFactory.fillDefaults().grab(false, false).indent(0, legendControlVerticalIndent).applyTo((Control)this.legendText);
        Hyperlink hyperlink = new Hyperlink(legendContainer, 64);
        GridDataFactory.fillDefaults().grab(false, false).indent(0, legendControlVerticalIndent).applyTo((Control)hyperlink);
        hyperlink.setText(NLS.bind((String)"Configure templates...", null));
        Color blue = new Color(null, 0, 0, 255);
        hyperlink.setForeground(blue);
        hyperlink.setUnderlined(true);
        blue.dispose();
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"com.springsource.sts.help.ui.templatepreferencepage", null, null);
                TemplateSelectionPart.this.refreshButton.setEnabled(false);
                dialog.open();
                TemplateSelectionPart.this.downloadDescriptors();
                TemplateSelectionPart.this.refreshButton.setEnabled(!TemplateSelectionPart.this.isRefreshing());
            }
        });
        this.refreshButton = new Button(legendContainer, 8);
        this.refreshButton.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.refreshButton.setText("Refresh");
        this.refreshButton.setEnabled(!this.isRefreshing());
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentPlugin.getDefault().getManager().setDirty();
                TemplateSelectionPart.this.downloadDescriptors();
            }
        });
        this.refreshButton.setToolTipText("Refresh the list of templates. Note that the current template selection will be cleared.");
        Composite descriptionComposite = new Composite(container, 0);
        descriptionComposite.setLayout((Layout)new GridLayout());
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.descriptionLabel = new Label(descriptionComposite, 0);
        this.descriptionLabel.setText("Description:");
        this.descriptionLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.descriptionText = new StyledText(descriptionComposite, 584);
        Display display = Display.getCurrent();
        if (display != null) {
            this.descriptionText.setBackground(display.getSystemColor(22));
        }
        GridData descriptionData = new GridData(4, 4, true, true);
        descriptionData.widthHint = 200;
        descriptionData.heightHint = 80;
        this.descriptionText.setLayoutData((Object)descriptionData);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = TemplateSelectionPart.this.treeViewer.getSelection();
                if (selection instanceof TreeSelection) {
                    Object element = ((TreeSelection)selection).getFirstElement();
                    if (element instanceof Template) {
                        TemplateSelectionPart.this.setSeletectedTemplate((Template)element);
                    } else if (element instanceof TemplateCategory) {
                        TemplateSelectionPart.this.setSeletectedTemplate(null);
                    }
                }
            }
        });
        this.contentManagerListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                boolean hasTemplateContentChanged;
                ContentManager manager = event.getSource() instanceof ContentManager ? (ContentManager)event.getSource() : null;
                boolean bl = hasTemplateContentChanged = manager != null && manager.isDirty();
                if (hasTemplateContentChanged) {
                    TemplateSelectionPart.this.clearTemplateSelection();
                    TemplateSelectionPart.this.initialiseTemplatesFromContentManager();
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        TemplateSelectionPart.this.refreshPage(hasTemplateContentChanged);
                    }
                });
            }
        };
        ContentManager manager = ContentPlugin.getDefault().getManager();
        manager.addListener(this.contentManagerListener);
        this.downloadDescriptors();
        this.expandCategory(SIMPLE_PROJECTS_CATEGORY);
        return container;
    }

    protected void clearTemplateSelection() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (TemplateSelectionPart.this.treeViewer != null && !TemplateSelectionPart.this.treeViewer.getTree().isDisposed()) {
                    TemplateSelectionPart.this.treeViewer.setSelection(null);
                }
                TemplateSelectionPart.this.setSeletectedTemplate(null);
            }
        });
    }

    protected void expandCategory(String categoryName) {
        if (this.treeViewer == null || this.treeViewer.getTree().isDisposed()) {
            return;
        }
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object itemObj = item.getData();
                if (itemObj instanceof TemplateCategory && ((TemplateCategory)itemObj).getName().equals(categoryName)) {
                    this.treeViewer.expandToLevel(itemObj, 1);
                    break;
                }
                ++n2;
            }
        }
    }

    protected void downloadDescriptors() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                String[] error = new String[1];
                Exception[] e = new Exception[1];
                try {
                    TemplateSelectionPart.this.wizard.getContainer().run(true, true, (IRunnableWithProgress)new DownloadDescriptorJob());
                }
                catch (InvocationTargetException ie) {
                    e[0] = ie;
                    error[0] = ErrorUtils.getErrorMessage("Failed to download template descriptors", e[0]);
                }
                catch (InterruptedException inte) {
                    e[0] = inte;
                    error[0] = "Download of descriptors interrupted";
                }
                if (error[0] != null && e[0] != null) {
                    TemplateSelectionPart.this.setError(error[0], e[0]);
                }
            }
        });
    }

    protected void setSeletectedTemplate(Template template) {
        this.model.selectedTemplate.setValue((Object)template);
        if (template != null) {
            this.setDescription(template);
        }
        this.notifyStatusChange(this.validateArea());
    }

    @Override
    protected IStatus validateArea() {
        Template template = (Template)this.model.selectedTemplate.getValue();
        IStatus status = Status.OK_STATUS;
        if (template != null) {
            String warning = this.getWarning(template);
            if (warning != null) {
                status = this.createStatus(warning, 2);
            } else if (!(template instanceof SimpleProject)) {
                String message = "Click 'Next' to load the template contents.";
                status = this.createStatus(message, 1);
            }
            this.setAreaComplete(true);
        } else {
            this.setAreaComplete(false);
            status = this.createStatus("Please select a template.", 1);
        }
        return status;
    }

    protected void setError(String error, Throwable t) {
        this.notifyStatusChange((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", error, t), false);
    }

    protected void setError(IStatus error) {
        this.notifyStatusChange(error, false);
    }

    private void initialiseTemplatesFromContentManager() {
        this.templates.clear();
        TemplatesPreferencesModel model = TemplatesPreferencesModel.getInstance();
        Collection items = ContentPlugin.getDefault().getManager().getItemsByKind("template");
        ArrayList sortedItems = new ArrayList();
        sortedItems.addAll(items);
        Collections.sort(sortedItems, new Comparator<ContentItem>(){

            @Override
            public int compare(ContentItem o1, ContentItem o2) {
                Descriptor descriptor2;
                Descriptor descriptor1 = o1.getRemoteDescriptor();
                if (descriptor1 == null) {
                    descriptor1 = o1.getLocalDescriptor();
                }
                if ((descriptor2 = o2.getRemoteDescriptor()) == null) {
                    descriptor2 = o2.getLocalDescriptor();
                }
                return descriptor1.getVersion().compareTo(descriptor2.getVersion()) * -1;
            }
        });
        HashSet<String> templateIds = new HashSet<String>();
        for (ContentItem item : sortedItems) {
            String templateId = item.getId();
            if (templateIds.contains(templateId)) continue;
            Template template = new Template(item, null);
            this.templates.add(template);
            templateIds.add(templateId);
        }
        List<SimpleProject> simpleProjects = this.getSimpleProjects();
        this.templates.addAll(simpleProjects);
        if (model.shouldShowSelfHostedProjects()) {
            IProject[] projects;
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IFile templateFile = project.getFile("template.xml");
                IFile wizardFile = project.getFile("wizard.json");
                if (templateFile.exists() && wizardFile.exists()) {
                    String message;
                    File file = templateFile.getLocation().toFile();
                    try {
                        DocumentBuilder documentBuilder = ContentUtil.createDocumentBuilder();
                        Document document = documentBuilder.parse(file);
                        Element rootNode = document.getDocumentElement();
                        if (rootNode != null) {
                            NodeList children = rootNode.getChildNodes();
                            int i = 0;
                            while (i < children.getLength()) {
                                Node childNode = children.item(i);
                                if (childNode.getNodeType() == 1 && "descriptor".equals(childNode.getNodeName())) {
                                    Descriptor descriptor = Descriptor.read((Node)childNode);
                                    ContentItem item = new ContentItem(descriptor.getId(), project);
                                    item.setLocalDescriptor(descriptor);
                                    descriptor.setUrl(project.getName());
                                    ImageDescriptor icon = null;
                                    Template template = new Template(item, icon);
                                    this.templates.add(template);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (CoreException e) {
                        message = NLS.bind((String)"Error getting and parsing descriptors file in background {0}", (Object)e.getMessage());
                        MessageDialog.openWarning((Shell)this.wizard.getContainer().getShell(), (String)"Warning", (String)message);
                    }
                    catch (SAXException e) {
                        message = NLS.bind((String)"Error parsing tmp descriptors file at {0} in background.\n{1}", (Object)file, (Object)e.getMessage());
                        MessageDialog.openWarning((Shell)this.wizard.getContainer().getShell(), (String)"Warning", (String)message);
                    }
                    catch (IOException e) {
                        message = NLS.bind((String)"IO error on file at {0} opened in background.\n{1}", (Object)file, (Object)e.getMessage());
                        MessageDialog.openWarning((Shell)this.wizard.getContainer().getShell(), (String)"Warning", (String)message);
                    }
                }
                ++n2;
            }
        }
        Collections.sort(this.templates, new Comparator<Template>(){

            @Override
            public int compare(Template t1, Template t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
    }

    protected List<SimpleProject> getSimpleProjects() {
        final ArrayList<SimpleProject> projects = new ArrayList<SimpleProject>();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                final String[] error = new String[1];
                final Exception[] exception = new Exception[1];
                try {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                List<SimpleProject> prj = SimpleProjectContentManager.getManager().getSimpleProjects(monitor);
                                projects.addAll(prj);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    TemplateSelectionPart.this.wizard.getContainer().run(false, false, runnable);
                }
                catch (InvocationTargetException e) {
                    error[0] = ErrorUtils.getErrorMessage("Failed to load Simple Project template content", e);
                    exception[0] = e;
                }
                catch (InterruptedException e) {
                    error[0] = "Failure while loading Simple Project templates due to interrupt exception. Template content may not have been loaded correctly.";
                    exception[0] = e;
                }
                if (error[0] != null && exception[0] != null) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            TemplateSelectionPart.this.setError(error[0], exception[0]);
                        }
                    });
                }
            }
        });
        return projects;
    }

    private void refreshPage(boolean refreshAll) {
        if (refreshAll) {
            this.treeViewer.refresh(true);
            boolean needsDownload = false;
            for (Template template : this.templates) {
                if (template instanceof SimpleProject || template.getItem().isLocal()) continue;
                needsDownload = true;
                break;
            }
            this.expandCategory(SIMPLE_PROJECTS_CATEGORY);
            this.legendImage.setVisible(needsDownload);
            this.legendText.setVisible(needsDownload);
            this.descriptionText.setText("");
            this.refreshButton.setEnabled(true);
        } else {
            this.refreshSelectedTemplateInViewer();
        }
    }

    public void refreshSelectedTemplateInViewer() {
        Template selectedTemplate = (Template)this.model.selectedTemplate.getValue();
        if (selectedTemplate != null && this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.refresh((Object)selectedTemplate, true);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedTemplate), true);
        }
    }

    private void setDescription(Template template) {
        String description = null;
        if (template != null) {
            description = template.getDescription();
            if (!(template instanceof SimpleProject) && template.getItem().getRemoteDescriptor() != null) {
                description = String.valueOf(description) + "\n\nURL:" + template.getItem().getRemoteDescriptor().getUrl();
            }
        }
        if (description != null) {
            this.descriptionText.setText(description);
        } else {
            this.descriptionText.setText("");
        }
        this.descriptionText.redraw();
    }

    private String getWarning(Template template) {
        String requiredBundleStr = null;
        ContentItem contentItem = template.getItem();
        if (contentItem.getLocalDescriptor() != null) {
            requiredBundleStr = contentItem.getLocalDescriptor().getRequiresBundle();
        }
        if (requiredBundleStr == null && contentItem.getRemoteDescriptor() != null) {
            requiredBundleStr = contentItem.getRemoteDescriptor().getRequiresBundle();
        }
        StringBuilder missingBundleStr = new StringBuilder();
        if (requiredBundleStr != null) {
            String[] requiredBundles;
            String[] stringArray = requiredBundles = requiredBundleStr.split(",");
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredBundle = stringArray[n2];
                if (Platform.getBundle((String)requiredBundle.trim()) == null) {
                    if (missingBundleStr.length() > 0) {
                        missingBundleStr.append(", ");
                    }
                    missingBundleStr.append(requiredBundle.trim());
                }
                ++n2;
            }
        }
        if (missingBundleStr.length() > 0) {
            String message = NLS.bind((String)"To ensure project compiles properly, please install bundle(s) {0}.", (Object)missingBundleStr);
            return message;
        }
        return null;
    }

    public void dispose() {
        Assert.isNotNull((Object)this.contentManagerListener);
        ContentPlugin.getDefault().getManager().removeListener(this.contentManagerListener);
    }

    private boolean isRefreshing() {
        return ContentPlugin.getDefault().getManager().isRefreshing();
    }
}

