/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.springframework.ide.eclipse.wizard.template.ErrorUtils;
import org.springframework.ide.eclipse.wizard.template.IWizardPageStatusHandler;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizard;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardMessages;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardModel;
import org.springframework.ide.eclipse.wizard.template.ProjectNameLocationArea;
import org.springframework.ide.eclipse.wizard.template.SpringVersion;
import org.springframework.ide.eclipse.wizard.template.TemplateSelectionPart;
import org.springframework.ide.eclipse.wizard.template.WizardPageArea;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;

public class NewSpringProjectWizardMainPage
extends WizardPage
implements IWizardPageStatusHandler {
    private SpringVersion version;
    private TemplateSelectionPart part;
    private SpringVersionArea springArea;
    private final NewSpringProjectWizardModel model;
    private WorkingSetGroup workingSetGroup;
    private final List<WizardPageArea> wizardAreas = new ArrayList<WizardPageArea>();

    public SpringVersion getVersion() {
        return this.version;
    }

    public NewSpringProjectWizardMainPage(NewSpringProjectWizardModel model) {
        super(NewSpringProjectWizardMessages.NewProject_title, "Create a Spring project by selecting a template or simple project type.", null);
        this.model = model;
    }

    public void refreshTemplateInUI() {
        if (this.part != null) {
            this.part.refreshSelectedTemplateInViewer();
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite mainArea = new Composite(parent, 0);
        mainArea.setFont(parent.getFont());
        mainArea.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainArea);
        new ProjectNameLocationArea(this.model, this, this.getShell()).createArea(mainArea);
        this.springArea = new SpringVersionArea();
        this.springArea.createArea(mainArea);
        this.part = new TemplateSelectionPart(this.getWizard(), this.model, this);
        this.part.createArea(mainArea);
        String[] workingSetIds = new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.ui.resourceWorkingSetPage"};
        IStructuredSelection selection = ((NewSpringProjectWizard)this.getWizard()).getSelection();
        this.createWorkingSetGroup(mainArea, selection, workingSetIds);
        this.setControl((Control)mainArea);
        this.refreshUI();
    }

    public WorkingSetGroup createWorkingSetGroup(Composite composite, IStructuredSelection selection, String[] supportedWorkingSetTypes) {
        this.workingSetGroup = new WorkingSetGroup(composite, selection, supportedWorkingSetTypes);
        return this.workingSetGroup;
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup != null ? this.workingSetGroup.getSelectedWorkingSets() : new IWorkingSet[]{};
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && ((NewSpringProjectWizard)this.getWizard()).hasPages((IWizardPage)this);
    }

    protected Combo createLabeledCombo(Composite parent, String labelValue, String labelTooltip) {
        Label label = new Label(parent, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        label.setText(labelValue);
        if (labelTooltip != null) {
            label.setToolTipText(labelTooltip);
        }
        Combo combo = new Combo(parent, 2056);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)combo);
        combo.setEnabled(true);
        return combo;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected void update() {
        this.getWizard().getContainer().updateButtons();
    }

    protected void refreshUI() {
        if (this.springArea != null) {
            this.springArea.refreshUI();
        }
    }

    protected void displayStatus(WizardPageArea area) {
        IStatus status = area.getValidationStatus();
        if (status == null || status.getSeverity() == 0) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return;
        }
        if (status.getSeverity() == 4) {
            this.setMessage(null);
            String errorMessage = status.getMessage();
            if (errorMessage == null) {
                errorMessage = "Unknown error occurred in template project wizard. Unable to determine the nature of the error.";
            }
            if (ErrorUtils.isWithinWizardErrorMaximum(errorMessage)) {
                this.setErrorMessage(errorMessage);
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewSpringProjectWizardMessages.NewProject_errorMessage, null, (IStatus)status);
            }
        } else {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), status.getSeverity());
        }
    }

    public void addPageArea(WizardPageArea area) {
        if (area == null || this.wizardAreas.contains(area)) {
            return;
        }
        this.wizardAreas.add(area);
    }

    protected WizardPageArea getAreaBySeverity(int severity) {
        for (WizardPageArea area : this.wizardAreas) {
            IStatus areaStatus = area.getValidationStatus(true);
            if (areaStatus == null || areaStatus.getSeverity() != severity) continue;
            return area;
        }
        return null;
    }

    public void notifyStatusChange(WizardPageArea currentArea) {
        WizardPageArea nonOKArea = this.getAreaBySeverity(4);
        if (nonOKArea == null && (nonOKArea = this.getAreaBySeverity(2)) == null) {
            nonOKArea = this.getAreaBySeverity(1);
        }
        if (nonOKArea != null) {
            this.displayStatus(nonOKArea);
            this.setPageComplete(nonOKArea.isAreaComplete());
        } else {
            boolean isPageComplete = currentArea.isAreaComplete();
            this.setErrorMessage(null);
            IStatus status = currentArea.getValidationStatus();
            if (status == null) {
                this.setMessage(null);
            } else if (status.getMessage().equals(Status.OK_STATUS.getMessage())) {
                this.setMessage(null);
            } else {
                this.setMessage(status.getMessage());
            }
            this.setPageComplete(isPageComplete);
        }
        this.refreshUI();
    }

    public void dispose() {
        super.dispose();
        if (this.part != null) {
            this.part.dispose();
        }
    }

    protected class SpringVersionArea
    extends WizardPageArea {
        private Combo springVersionCombo;

        public SpringVersionArea() {
            super(NewSpringProjectWizardMainPage.this);
            NewSpringProjectWizardMainPage.this.setPageComplete(true);
        }

        public Control createArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            container.setLayout((Layout)layout);
            this.springVersionCombo = NewSpringProjectWizardMainPage.this.createLabeledCombo(container, "Select Spring version:", "Select a Spring version when building the project. Use 'Default' when using the template-defined Spring version. Spring version selection may not be available on all templates.");
            List<SpringVersion> versions = SpringVersion.getVersions();
            int length = versions.size();
            String[] versionValues = new String[length];
            int i = 0;
            for (SpringVersion version : versions) {
                if (i >= length) continue;
                versionValues[i++] = version.getDisplay();
            }
            this.springVersionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    List<SpringVersion> versions;
                    int selectionIndex = SpringVersionArea.this.springVersionCombo.getSelectionIndex();
                    if (selectionIndex != -1 && selectionIndex < (versions = SpringVersion.getVersions()).size()) {
                        SpringVersion selectedVersion = versions.get(selectionIndex);
                        if (SpringVersion.DEFAULT.equals(selectedVersion)) {
                            NewSpringProjectWizardMainPage.this.version = null;
                        } else {
                            NewSpringProjectWizardMainPage.this.version = selectedVersion;
                        }
                    }
                }
            });
            this.springVersionCombo.setItems(versionValues);
            this.springVersionCombo.select(0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
            return container;
        }

        public void refreshUI() {
            if (this.springVersionCombo == null || this.springVersionCombo.isDisposed()) {
                return;
            }
            String descriptorVersion = null;
            Template template = (Template)((NewSpringProjectWizard)NewSpringProjectWizardMainPage.this.getWizard()).getModel().selectedTemplate.getValue();
            if (template != null) {
                Descriptor descriptor = template.getItem().getLocalDescriptor();
                if (descriptor == null) {
                    descriptor = template.getItem().getRemoteDescriptor();
                }
                if (descriptor != null) {
                    descriptorVersion = descriptor.getSpringVersion();
                }
            }
            if (descriptorVersion != null) {
                this.springVersionCombo.setEnabled(true);
            } else {
                this.springVersionCombo.select(0);
                this.springVersionCombo.setEnabled(false);
            }
        }

        protected IStatus validateArea() {
            return Status.OK_STATUS;
        }
    }
}

