/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.guides;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.springframework.ide.eclipse.wizard.WizardImages;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentManager;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GSContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GSZipFileCodeSet;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.BuildTypeRadiosSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.ChooseTypedContentSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.CodeSetCheckBoxesSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.DescriptionSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.GSImportWizardModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.OpenUrlSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.ValidatorSection;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;

public class GSImportWizard
extends Wizard
implements IImportWizard,
INewWizard {
    private DialogCallback callback;
    private final GSImportWizardModel model = new GSImportWizardModel();
    private static final ImageDescriptor IMAGE = WizardImages.TEMPLATE_WIZARD_ICON;
    private final PageOne pageOne = new PageOne(this.model);
    private String focusItem;

    public GSImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(IMAGE);
    }

    public void openHomePage(boolean close) {
        this.model.openHomePage();
        if (close) {
            this.callback.dialog.close();
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.pageOne);
    }

    public boolean performFinish() {
        Job job = new Job("Import Getting Started Content"){

            protected IStatus run(IProgressMonitor mon) {
                try {
                    GSImportWizard.this.model.performFinish(mon);
                    return Status.OK_STATUS;
                }
                catch (Throwable e) {
                    return ExceptionUtil.status((Throwable)e);
                }
            }
        };
        job.setPriority(40);
        job.setUser(true);
        job.schedule();
        return true;
    }

    public static int open(Shell shell, GSContent guide) {
        return GSImportWizard.open(shell, guide, null, true, false);
    }

    public static int open(Shell shell, String focusItem) {
        return GSImportWizard.open(shell, null, focusItem, true, true);
    }

    private static int open(Shell shell, GSContent guide, String focusItem, boolean synchronous, boolean enableOpenHomepage) {
        GSImportWizard wiz = new GSImportWizard();
        wiz.setEnableOpenHomePage(enableOpenHomepage);
        if (guide != null) {
            wiz.setItem(guide);
        }
        if (focusItem != null) {
            wiz.setFocusItem(focusItem);
        }
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wiz);
        dialog.setBlockOnOpen(synchronous);
        wiz.callback = new DialogCallback();
        wiz.callback.dialog = dialog;
        return dialog.open();
    }

    public void setEnableOpenHomePage(boolean enable) {
        this.model.getEnableOpenHomePage().setValue((Object)enable);
    }

    public static int open(Shell shell, ContentManager cm, GSZipFileCodeSet content) {
        GSImportWizard wiz = new GSImportWizard();
        wiz.setContentManager(cm);
        wiz.setItem(content);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wiz);
        dialog.setBlockOnOpen(true);
        return dialog.open();
    }

    private void setContentManager(ContentManager cm) {
        this.model.setContentManager(cm);
    }

    public void setItem(GSContent guide) {
        this.model.setItem(guide);
        if (guide != null) {
            this.pageOne.setFilterText(guide.getDisplayName());
        }
    }

    public void setFocusItem(String focusItem) {
        this.focusItem = focusItem;
    }

    private static class DialogCallback {
        WizardDialog dialog;

        private DialogCallback() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PageOne
    extends WizardPageWithSections {
        private final GSImportWizardModel model;
        private ChooseTypedContentSection contentChooser;

        protected PageOne(GSImportWizardModel model) {
            super("Page One", "Import Getting Started Content", IMAGE);
            this.model = model;
        }

        protected List<WizardPageSection> createSections() {
            ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
            sections.add(this.getContentChooser());
            this.contentChooser.setCategory(GSImportWizard.this.focusItem);
            sections.add(new ValidatorSection((IPageWithSections)this, this.model.downloadStatus));
            sections.add(new DescriptionSection((IPageWithSections)this, this.model.description));
            sections.add((WizardPageSection)new BuildTypeRadiosSection(this, this.model.getBuildTypeModel()));
            sections.add(new CodeSetCheckBoxesSection(this, this.model.validCodesetNames, this.model.getCodeSetModel()));
            sections.add(new OpenUrlSection(GSImportWizard.this, this, "Home Page", this.model.homePage, this.model.getEnableOpenHomePage()));
            return sections;
        }

        private ChooseTypedContentSection getContentChooser() {
            if (this.contentChooser == null) {
                this.contentChooser = new ChooseTypedContentSection((IPageWithSections)this, this.model.getGSContentSelectionModel(), this.model.getRawSelection(), this.model.getContentManager());
            }
            return this.contentChooser;
        }

        public void setFilterText(String text) {
            this.getContentChooser().setFilterText(text);
        }
    }
}

