/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.content;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.BuildType;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.CodeSet;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GithubRepoContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.Repo;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialGuide
extends GithubRepoContent {
    protected Repo repo;
    private List<CodeSet> codesets;
    private final String springGuidesUrl;
    public static final String GUIDE_DESCRIPTION_TEXT = "A longer tutorial building a larger project in multiple steps. It has an 'initial' code set, several 'numbered' codesets.The numbered 'codeset' represent the solution at the end ofa tutorial step.";
    private static final String CODE_SET_METADATA = ".codesets.json";

    public TutorialGuide(StsProperties props, Repo repo, DownloadManager dl) {
        super(dl);
        this.springGuidesUrl = props.get("spring.guides.url");
        this.repo = repo;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.getName() + ")";
    }

    @Override
    public List<CodeSet> getCodeSets() throws UIThreadDownloadDisallowed {
        if (this.codesets == null) {
            CodeSet root = CodeSet.fromZip("ROOT", this.getZip(), this.getRootPath());
            if (root.hasFile(CODE_SET_METADATA)) {
                try {
                    CodeSetMetaData[] metadata = root.readFileEntry(CODE_SET_METADATA, new CodeSet.Processor<CodeSetMetaData[]>(){

                        @Override
                        public CodeSetMetaData[] doit(CodeSet.CodeSetEntry e) throws Exception {
                            InputStream in = e.getData();
                            try {
                                ObjectMapper mapper = new ObjectMapper();
                                CodeSetMetaData[] codeSetMetaDataArray = (CodeSetMetaData[])mapper.readValue(in, CodeSetMetaData[].class);
                                return codeSetMetaDataArray;
                            }
                            finally {
                                in.close();
                            }
                        }
                    });
                    if (metadata == null) {
                        metadata = new CodeSetMetaData[]{};
                    }
                    CodeSet[] array = new CodeSet[metadata.length];
                    int i = 0;
                    while (i < array.length) {
                        String name = metadata[i].name;
                        String dir = metadata[i].dir;
                        Assert.isLegal((name != null ? 1 : 0) != 0, (String)".codesets.json objects must specify at least a 'name'.");
                        if (dir == null) {
                            dir = name;
                        }
                        IPath zipPath = this.getRootPath().append(dir);
                        array[i] = CodeSet.fromZip(name, this.getZip(), zipPath);
                        ++i;
                    }
                    this.codesets = Arrays.asList(array);
                    return this.codesets;
                }
                catch (Throwable e) {
                    WizardPlugin.log(e);
                }
            }
            this.codesets = Arrays.asList(this.defaultCodeSets(root));
        }
        return this.codesets;
    }

    private CodeSet[] defaultCodeSets(CodeSet root) {
        ArrayList<CodeSet> codesets = new ArrayList<CodeSet>();
        codesets.add(CodeSet.fromZip("initial", this.getZip(), this.getRootPath().append("initial")));
        int number = 1;
        while (root.hasFolder((IPath)new Path("" + number))) {
            Path codePath = new Path(String.valueOf(number) + "/complete");
            if (root.hasFolder((IPath)new Path(String.valueOf(number) + "/complete"))) {
                codesets.add(CodeSet.fromZip(String.valueOf(number) + "-complete", this.getZip(), this.getRootPath().append((IPath)codePath)));
            }
            ++number;
        }
        return codesets.toArray(new CodeSet[codesets.size()]);
    }

    @Override
    public Repo getRepo() {
        return this.repo;
    }

    public ValidationResult validateBuildType(BuildType bt) throws UIThreadDownloadDisallowed {
        for (CodeSet cs : this.getCodeSets()) {
            ValidationResult result = cs.validateBuildType(bt);
            if (result.isOk()) continue;
            return result;
        }
        return ValidationResult.OK;
    }

    private String beatify(String name) {
        if (name.startsWith("tut-")) {
            name = name.substring(4);
        }
        String[] words = name.split("\\-");
        StringBuilder buf = new StringBuilder();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (w.length() > 0) {
                buf.append(w.substring(0, 1).toUpperCase());
                buf.append(w.substring(1));
            }
            buf.append(' ');
            ++n2;
        }
        return buf.toString();
    }

    @Override
    public URL getHomePage() {
        try {
            String gsGuideName = this.getName();
            if (gsGuideName.startsWith("tut-")) {
                String guideName = gsGuideName.substring(4);
                return new URL(String.valueOf(this.springGuidesUrl) + "/tutorials/" + guideName);
            }
        }
        catch (MalformedURLException e) {
            WizardPlugin.log(e);
        }
        return super.getHomePage();
    }

    @Override
    public String getDisplayName() {
        return this.beatify(this.getName());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CodeSetMetaData {
        @JsonProperty
        public String name;
        @JsonProperty
        public String dir;
        @JsonProperty
        public String description;

        public CodeSetMetaData() {
        }

        public CodeSetMetaData(String name) {
            this.name = name;
            this.dir = name;
        }

        public CodeSetMetaData desciption(String d) {
            this.description = d;
            return this;
        }

        public String toString() {
            return "CodeSetMD(name = " + this.name + ", dir = " + this.dir + ")";
        }
    }
}

