/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.springframework.ide.eclipse.wizard.WizardImages;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.CheckBoxesSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.NewSpringBootWizardModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioGroup;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioInfo;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.WorkingSetSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.ChooseOneSectionCombo;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.DescriptionSection;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.ui.GroupSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.ProjectLocationSection;
import org.springsource.ide.eclipse.commons.livexp.ui.StringFieldSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageWithSections;

public class NewSpringBootWizard
extends Wizard
implements INewWizard,
IImportWizard {
    private static final ImageDescriptor IMAGE = WizardImages.TEMPLATE_WIZARD_ICON;
    private NewSpringBootWizardModel model;
    private IStructuredSelection selection;
    private WorkingSetSection workingSetSection;

    public NewSpringBootWizard() throws Exception {
        this.setDefaultPageImageDescriptor(IMAGE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.model = new NewSpringBootWizardModel();
            this.selection = selection;
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)"Error opening the wizard", (String)(String.valueOf(ExceptionUtil.getMessage((Throwable)e)) + "\n\n" + "Note that this wizard uses a webservice and needs internet access.\n" + "A more detailed error message may be found in the Eclipse error log."));
            WizardPlugin.log(e);
            throw new Error(e);
        }
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new PageOne());
        this.addPage((IWizardPage)new PageTwo());
    }

    private WizardPageSection createRadioGroupsSection(WizardPageWithSections owner) {
        boolean notEmpty = false;
        ArrayList<ChooseOneSectionCombo<RadioInfo>> radioSections = new ArrayList<ChooseOneSectionCombo<RadioInfo>>();
        for (RadioGroup radioGroup : this.model.getRadioGroups().getGroups()) {
            if (radioGroup.getRadios().length <= 1) continue;
            radioSections.add(new ChooseOneSectionCombo<RadioInfo>((IPageWithSections)owner, radioGroup.getLabel(), radioGroup.getSelection(), radioGroup.getRadios()));
            notEmpty = true;
        }
        if (notEmpty) {
            return new GroupSection(owner, null, radioSections.toArray(new WizardPageSection[radioSections.size()])).columns(2);
        }
        return null;
    }

    public boolean performFinish() {
        this.model.setWorkingSets(this.workingSetSection.getWorkingSets());
        Job job = new Job("Import Getting Started Content"){

            protected IStatus run(IProgressMonitor mon) {
                try {
                    NewSpringBootWizard.this.model.performFinish(mon);
                    return Status.OK_STATUS;
                }
                catch (Throwable e) {
                    return ExceptionUtil.status((Throwable)e);
                }
            }
        };
        job.setPriority(40);
        job.setUser(true);
        job.schedule();
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PageOne
    extends WizardPageWithSections {
        protected PageOne() {
            super("page1", "New Spring Starter Project", null);
        }

        protected List<WizardPageSection> createSections() {
            ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
            FieldModel<String> projectName = NewSpringBootWizard.this.model.getProjectName();
            sections.add((WizardPageSection)new StringFieldSection((IPageWithSections)this, projectName));
            WizardPageSection radios = NewSpringBootWizard.this.createRadioGroupsSection(this);
            if (radios != null) {
                sections.add(radios);
            }
            for (FieldModel<String> fieldModel : ((NewSpringBootWizard)NewSpringBootWizard.this).model.stringInputs) {
                if (projectName == fieldModel) continue;
                sections.add((WizardPageSection)new StringFieldSection((IPageWithSections)this, fieldModel));
            }
            sections.add(new CheckBoxesSection<String>((IPageWithSections)this, ((NewSpringBootWizard)NewSpringBootWizard.this).model.style).columns(4));
            return sections;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PageTwo
    extends WizardPageWithSections {
        protected PageTwo() {
            super("page2", "New Spring Starter Project", null);
        }

        protected List<WizardPageSection> createSections() {
            ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
            FieldModel<String> projectName = NewSpringBootWizard.this.model.getProjectName();
            sections.add((WizardPageSection)new ProjectLocationSection((IPageWithSections)this, NewSpringBootWizard.this.model.getLocation(), (LiveExpression)projectName.getVariable(), NewSpringBootWizard.this.model.getLocationValidator()));
            WorkingSetSection workingSetSection = new WorkingSetSection((IPageWithSections)this, NewSpringBootWizard.this.selection);
            NewSpringBootWizard.this.workingSetSection = workingSetSection;
            sections.add(workingSetSection);
            sections.add((WizardPageSection)new GroupSection((WizardPageWithSections)this, "Site Info", new WizardPageSection[]{new StringFieldSection((IPageWithSections)this, "Base Url", ((NewSpringBootWizard)NewSpringBootWizard.this).model.baseUrl, ((NewSpringBootWizard)NewSpringBootWizard.this).model.baseUrlValidator), new DescriptionSection((IPageWithSections)this, (LiveExpression<String>)((NewSpringBootWizard)NewSpringBootWizard.this).model.downloadUrl).label("Full Url").readOnly(false)}));
            return sections;
        }
    }
}

