/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveSet;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSelectionFieldModel<T> {
    private Class<T> type;
    private String name;
    private String label;
    private LiveSet<T> variable = new LiveSet();
    private LiveExpression<ValidationResult> validator;
    private Map<T, String> labelMap = new LinkedHashMap<T, String>();

    public MultiSelectionFieldModel(Class<T> type, String name) {
        this.type = type;
        this.name = name;
        this.label = name;
        this.variable = new LiveSet();
        this.validator = Validator.OK;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabel(T value) {
        return this.labelMap.get(value);
    }

    public String getName() {
        return this.name;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    public MultiSelectionFieldModel<T> validator(LiveExpression<ValidationResult> v) {
        this.validator = v;
        return this;
    }

    public LiveSet<T> getSelecteds() {
        return this.variable;
    }

    public void add(T v) {
        this.getSelecteds().add(v);
    }

    public void remove(T v) {
        this.getSelecteds().remove(v);
    }

    public MultiSelectionFieldModel<T> choice(String label, T value) {
        Assert.isLegal((this.labelMap.get(value) == null ? 1 : 0) != 0, (String)("Duplicate choice " + value + " already added"));
        this.labelMap.put(value, label);
        return this;
    }

    public MultiSelectionFieldModel<T> label(String label) {
        this.label = label;
        return this;
    }

    public synchronized T[] getChoices() {
        Set<Object> values = this.labelMap.keySet();
        return values.toArray((Object[])Array.newInstance(this.getType(), values.size()));
    }
}

