/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorDescriptionPart;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.HeaderPart;
import org.springsource.ide.eclipse.dashboard.internal.ui.util.IdeUiUtils;

public class StsTaskPage
extends AbstractTaskEditorPage {
    public static final String PAGE_ID = "com.springsource.sts.ide.ui.editors.page.task";
    protected boolean addQuery;

    public StsTaskPage(TaskEditor editor) {
        super(editor, "jira");
        this.setNeedsSubmitButton(true);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        LinkedHashSet<TaskEditorPartDescriptor> descriptors = new LinkedHashSet<TaskEditorPartDescriptor>();
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.summary"){

            public AbstractTaskEditorPart createPart() {
                return new HeaderPart("Please use this form to provide feedback on the Spring Tool Suite, or report a bug.");
            }
        }.setPath("header"));
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attributes"){

            public AbstractTaskEditorPart createPart() {
                return new AttributesPart();
            }
        }.setPath("attributes"));
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.descriptions"){

            public AbstractTaskEditorPart createPart() {
                TaskEditorDescriptionPart part = new TaskEditorDescriptionPart();
                if (StsTaskPage.this.getModel().getTaskData().isNew()) {
                    part.setExpandVertically(true);
                    part.setSectionStyle(320);
                }
                return part;
            }
        }.setPath("comments"));
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.actions"){

            public AbstractTaskEditorPart createPart() {
                return new ActionPart();
            }
        }.setPath("actions"));
        return descriptors;
    }

    private class ActionPart
    extends AbstractTaskEditorPart {
        private ActionPart() {
        }

        public void createControl(Composite parent, FormToolkit toolkit) {
            Composite composite = toolkit.createComposite(parent);
            composite.setLayout((Layout)new GridLayout(1, false));
            IdeUiUtils.getBugsQuery();
            Button submitButton = toolkit.createButton(composite, "Submit", 0);
            submitButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_SUBMIT));
            submitButton.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    StsTaskPage.this.doSubmit();
                }
            });
        }
    }

    private class AttributesPart
    extends AbstractTaskEditorPart {
        private AbstractAttributeEditor summaryEditor;

        private AttributesPart() {
        }

        private AbstractAttributeEditor addAttribute(Composite composite, FormToolkit toolkit, String attributeId, boolean span) {
            AbstractAttributeEditor editor = this.createAttributeEditor(this.getTaskData().getRoot().getMappedAttribute(attributeId));
            editor.createLabelControl(composite, toolkit);
            editor.createControl(composite, toolkit);
            if (span) {
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo(editor.getControl());
            } else {
                GridDataFactory.fillDefaults().applyTo(editor.getControl());
                toolkit.createLabel(composite, "");
            }
            if (editor.getLayoutHint() != null && editor.getLayoutHint().rowSpan == LayoutHint.RowSpan.MULTIPLE) {
                ((GridData)editor.getControl().getLayoutData()).heightHint = 50;
            }
            return editor;
        }

        public void createControl(Composite parent, FormToolkit toolkit) {
            Composite composite = toolkit.createComposite(parent);
            composite.setLayout((Layout)new GridLayout(3, false));
            this.summaryEditor = this.addAttribute(composite, toolkit, "task.common.summary", true);
            this.addAttribute(composite, toolkit, "task.common.priority", false);
            TaskAttribute attribute = this.getTaskData().getRoot().getMappedAttribute("attribute.jira.affectsversions");
            if (attribute != null) {
                if ("".equals(attribute.getValue())) {
                    String value = IdeUiUtils.getVersion().toString();
                    for (Map.Entry entry : attribute.getOptions().entrySet()) {
                        if (!((String)entry.getValue()).equals(value)) continue;
                        attribute.setValue((String)entry.getKey());
                        this.getModel().attributeChanged(attribute);
                        break;
                    }
                }
                this.addAttribute(composite, toolkit, "attribute.jira.affectsversions", false);
            }
            toolkit.paintBordersFor(composite);
            this.setControl((Control)composite);
        }

        public void setFocus() {
            this.summaryEditor.getControl().setFocus();
        }
    }
}

