/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.actions;

import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraTimeFormat;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.JiraUiUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.JiraEditorUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.editor.Messages;
import java.text.ParseException;
import java.util.GregorianCalendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LogJiraTimeDialog
extends MessageDialog {
    public static final int SKIP_LOGGING = 1;
    private static final String[] buttons = new String[]{Messages.LogJiraTimeDialog_Stop_And_Log, Messages.LogJiraTimeDialog_Stop_Only, IDialogConstants.CANCEL_LABEL};
    private JiraWorkLog workLog;
    private long workDoneAmountInSeconds = 0L;
    private final TaskRepository repository;
    private Text descriptionText;
    private DateTime dateWidget;
    private DateTime timeWidget;
    protected JiraWorkLog.AdjustEstimateMethod adjustEstimate;
    private Text setRemainigEstimateText;
    protected long remainingEstimateInSeconds;
    private Text timeSpentText;
    private final TaskData taskData;
    private Text reduceRemainigEstimateText;

    public LogJiraTimeDialog(Shell parentShell, TaskData taskData, ITask iTask, long seconds) {
        super(parentShell, String.valueOf(Messages.WorkLogPart_Log_Work_Done) + " " + iTask.getTaskKey(), null, null, 0, buttons, 0);
        this.taskData = taskData;
        this.workDoneAmountInSeconds = seconds;
        this.repository = TasksUi.getRepositoryManager().getRepository(iTask.getConnectorKind(), iTask.getRepositoryUrl());
        this.adjustEstimate = JiraUiUtil.getAdjustEstimateOption(this.repository);
    }

    protected Control createMessageArea(Composite composite) {
        super.createMessageArea(composite);
        this.createTimeComponents(composite);
        this.createDisableTimeTrackingLink(composite);
        return composite;
    }

    private void createTimeComponents(Composite composite) {
        Composite c1 = new Composite(composite, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 10;
        gl.verticalSpacing = 10;
        gl.marginWidth = 0;
        c1.setLayout((Layout)gl);
        Label time = new Label(c1, 0);
        time.setText(Messages.WorkLogPart_Time_Spent);
        this.timeSpentText = new Text(c1, 2048);
        String wdhmTime = JiraUtil.getTimeFormat((TaskRepository)this.repository).format((Object)new Long(this.workDoneAmountInSeconds));
        this.timeSpentText.setText(wdhmTime);
        GridDataFactory.fillDefaults().applyTo((Control)this.timeSpentText);
        new Label(c1, 0).setText("");
        this.timeSpentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogJiraTimeDialog.this.validateSettings();
            }
        });
        this.timeSpentText.setToolTipText(this.getTimeSpentTooltipText(wdhmTime));
        Label startDate = new Label(c1, 0);
        startDate.setText(Messages.WorkLogPart_Start_Date);
        Composite dateTimeComposite = new Composite(c1, 0);
        GridLayout dateTimeLayout = new GridLayout(2, false);
        dateTimeLayout.horizontalSpacing = 0;
        dateTimeLayout.marginWidth = 0;
        dateTimeLayout.marginHeight = 0;
        dateTimeComposite.setLayout((Layout)dateTimeLayout);
        GregorianCalendar now = new GregorianCalendar();
        this.dateWidget = new DateTime(dateTimeComposite, 2080);
        this.dateWidget.setYear(now.get(1));
        this.dateWidget.setMonth(now.get(2));
        this.dateWidget.setDay(now.get(5));
        this.timeWidget = new DateTime(dateTimeComposite, 2176);
        this.timeWidget.setHours(now.get(11));
        this.timeWidget.setMinutes(now.get(12));
        this.timeWidget.setSeconds(now.get(13));
        GridDataFactory.fillDefaults().indent(4, 0).applyTo((Control)this.timeWidget);
        new Label(c1, 0).setText("");
        Label adjust = new Label(c1, 0);
        adjust.setText(Messages.WorkLogPart_Adjust_Estimate);
        Composite adjustComposite = new Composite(c1, 0);
        adjustComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 5).spacing(0, 5).create());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)adjustComposite);
        Button autoAdjustButton = new Button(adjustComposite, 16);
        autoAdjustButton.setText(Messages.WorkLogPart_Auto_Adjust);
        autoAdjustButton.setToolTipText(Messages.WorkLogPart_Auto_Adjust_Explanation_Tooltip);
        autoAdjustButton.setSelection(this.adjustEstimate == JiraWorkLog.AdjustEstimateMethod.AUTO);
        autoAdjustButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LogJiraTimeDialog.this.adjustEstimate = JiraWorkLog.AdjustEstimateMethod.AUTO;
                LogJiraTimeDialog.this.validateSettings();
                JiraUiUtil.updateAdjustEstimateOption(LogJiraTimeDialog.this.adjustEstimate, LogJiraTimeDialog.this.repository);
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)autoAdjustButton);
        Button leaveAdjustButton = new Button(adjustComposite, 16);
        leaveAdjustButton.setText(Messages.WorkLogPart_Leave_Existing_Estimate);
        leaveAdjustButton.setSelection(this.adjustEstimate == JiraWorkLog.AdjustEstimateMethod.LEAVE);
        leaveAdjustButton.setToolTipText(Messages.WorkLogPart_Leave_Existing_Explanation_Tooltip);
        leaveAdjustButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LogJiraTimeDialog.this.adjustEstimate = JiraWorkLog.AdjustEstimateMethod.LEAVE;
                LogJiraTimeDialog.this.validateSettings();
                JiraUiUtil.updateAdjustEstimateOption(LogJiraTimeDialog.this.adjustEstimate, LogJiraTimeDialog.this.repository);
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)leaveAdjustButton);
        final Button setRemainingTimeButton = new Button(adjustComposite, 16);
        setRemainingTimeButton.setText(Messages.LogJiraTimeDialog_Set_estimated_time_remaining);
        setRemainingTimeButton.setSelection(this.adjustEstimate == JiraWorkLog.AdjustEstimateMethod.SET);
        setRemainingTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LogJiraTimeDialog.this.adjustEstimate = JiraWorkLog.AdjustEstimateMethod.SET;
                LogJiraTimeDialog.this.setRemainigEstimateText.setEnabled(setRemainingTimeButton.getSelection());
                LogJiraTimeDialog.this.validateSettings();
                JiraUiUtil.updateAdjustEstimateOption(LogJiraTimeDialog.this.adjustEstimate, LogJiraTimeDialog.this.repository);
            }
        });
        this.setRemainigEstimateText = new Text(adjustComposite, 2048);
        this.setRemainigEstimateText.setEnabled(setRemainingTimeButton.getSelection());
        this.setRemainigEstimateText.setToolTipText(this.getTimeSpentTooltipText());
        this.setRemainigEstimateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogJiraTimeDialog.this.validateSettings();
            }
        });
        GridDataFactory.fillDefaults().indent(10, -1).applyTo((Control)this.setRemainigEstimateText);
        final Button reduceRemainingTimeButton = new Button(adjustComposite, 16);
        reduceRemainingTimeButton.setText(Messages.LogJiraTimeDialog_Reduce_estimated_time_by);
        reduceRemainingTimeButton.setSelection(this.adjustEstimate == JiraWorkLog.AdjustEstimateMethod.REDUCE);
        reduceRemainingTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LogJiraTimeDialog.this.adjustEstimate = JiraWorkLog.AdjustEstimateMethod.REDUCE;
                LogJiraTimeDialog.this.reduceRemainigEstimateText.setEnabled(reduceRemainingTimeButton.getSelection());
                LogJiraTimeDialog.this.validateSettings();
                JiraUiUtil.updateAdjustEstimateOption(LogJiraTimeDialog.this.adjustEstimate, LogJiraTimeDialog.this.repository);
            }
        });
        this.reduceRemainigEstimateText = new Text(adjustComposite, 2048);
        this.reduceRemainigEstimateText.setEnabled(reduceRemainingTimeButton.getSelection());
        this.reduceRemainigEstimateText.setToolTipText(this.getTimeSpentTooltipText());
        this.reduceRemainigEstimateText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogJiraTimeDialog.this.validateSettings();
            }
        });
        GridDataFactory.fillDefaults().indent(10, -1).applyTo((Control)this.reduceRemainigEstimateText);
        Label description = new Label(c1, 0);
        description.setText(Messages.WorkLogPart_Work_Description);
        Composite descComposite = new Composite(c1, 0);
        descComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).create());
        GridData descGD = new GridData();
        descGD.widthHint = 350;
        descGD.horizontalSpan = 2;
        descComposite.setLayoutData((Object)descGD);
        this.descriptionText = new Text(descComposite, 2626);
        GridDataFactory.fillDefaults().grab(true, true).hint(150, 100).applyTo((Control)this.descriptionText);
    }

    protected void validateSettings() {
        boolean ok = true;
        boolean controlIsOk = true;
        JiraTimeFormat formatter = JiraUtil.getTimeFormat((TaskRepository)this.repository);
        this.timeSpentText.setToolTipText(this.getTimeSpentTooltipText());
        try {
            this.workDoneAmountInSeconds = formatter.parse(this.timeSpentText.getText());
            if (this.workDoneAmountInSeconds <= 0L) {
                controlIsOk = false;
            }
        }
        catch (ParseException parseException) {
            controlIsOk = false;
        }
        if (controlIsOk) {
            JiraEditorUtil.showTimeSpentDecorator(this.timeSpentText, this.repository, false);
        } else {
            JiraEditorUtil.showTimeSpentDecorator(this.timeSpentText, this.repository, true);
            ok = false;
        }
        JiraEditorUtil.showTimeSpentDecorator(this.reduceRemainigEstimateText, this.repository, false);
        JiraEditorUtil.showTimeSpentDecorator(this.setRemainigEstimateText, this.repository, false);
        if (this.adjustEstimate == JiraWorkLog.AdjustEstimateMethod.SET) {
            try {
                this.remainingEstimateInSeconds = formatter.parse(this.setRemainigEstimateText.getText());
            }
            catch (ParseException parseException) {
                controlIsOk = false;
            }
            if (!controlIsOk || this.remainingEstimateInSeconds < 0L) {
                JiraEditorUtil.showTimeSpentDecorator(this.setRemainigEstimateText, this.repository, true);
                ok = false;
            }
        } else if (this.adjustEstimate == JiraWorkLog.AdjustEstimateMethod.REDUCE) {
            TaskAttribute estimate = this.taskData.getRoot().getAttribute("attribute.jira.estimate");
            if (estimate == null) {
                estimate = this.taskData.getRoot().getAttribute("attribute.jira.initialestimate");
            }
            long estimateLong = estimate == null ? 0L : Long.parseLong(estimate.getValue());
            try {
                this.remainingEstimateInSeconds = estimateLong - formatter.parse(this.reduceRemainigEstimateText.getText());
            }
            catch (ParseException parseException) {
                controlIsOk = false;
            }
            if (!controlIsOk) {
                JiraEditorUtil.showTimeSpentDecorator(this.reduceRemainigEstimateText, this.repository, true);
                ok = false;
            } else if (this.remainingEstimateInSeconds < 0L) {
                JiraEditorUtil.showTimeSpentDecorator(this.reduceRemainigEstimateText, this.repository, NLS.bind((String)Messages.LogJiraTimeDialog_cant_reduce_estimate_below_zero, (Object)formatter.format((Object)estimateLong)), true);
                ok = false;
            }
        }
        this.getButton(0).setEnabled(ok);
    }

    private GregorianCalendar collectDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(this.dateWidget.getYear(), this.dateWidget.getMonth(), this.dateWidget.getDay(), this.timeWidget.getHours(), this.timeWidget.getMinutes(), this.timeWidget.getSeconds());
        return cal;
    }

    private void collectWorkLog() {
        GregorianCalendar cal = this.collectDate();
        JiraWorkLog tempworkLog = new JiraWorkLog();
        tempworkLog.setAuthor(this.repository.getUserName());
        tempworkLog.setComment(this.descriptionText.getText());
        tempworkLog.setStartDate(cal.getTime());
        tempworkLog.setTimeSpent(this.workDoneAmountInSeconds);
        tempworkLog.setAdjustEstimate(this.adjustEstimate);
        tempworkLog.setNewRemainingEstimate(this.remainingEstimateInSeconds);
        this.workLog = tempworkLog;
    }

    private void createDisableTimeTrackingLink(Composite composite) {
        Link link = new Link(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)link);
        link.setText("<a>" + Messages.WorkLogTime_Disable_Time_Tracking + "</a> " + Messages.LogJiraTimeDialog_not_show_dialog);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogJiraTimeDialog.this.setReturnCode(1);
                LogJiraTimeDialog.this.close();
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.mylyn.tasks.ui.preferences", null, null);
                if (prefDialog != null) {
                    prefDialog.open();
                } else {
                    String message = Messages.LogJiraTimeDialog_Unable_to_find_Time_Tracking_preference;
                    MessageDialog.openError((Shell)shell, (String)"Atlassian JIRA Connector", (String)message);
                    StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.jira.ui", message));
                }
            }
        });
    }

    public JiraWorkLog getWorkLog() {
        return this.workLog;
    }

    private String getTimeSpentTooltipText() {
        String timeSpendTooltip = NLS.bind((String)Messages.WorkLogPart_Time_Spent_Explanation_Tooltip, (Object)JiraUtil.getWorkDaysPerWeek((TaskRepository)this.repository), (Object)JiraUtil.getWorkHoursPerDay((TaskRepository)this.repository));
        return timeSpendTooltip;
    }

    private String getTimeSpentTooltipText(String wdhmTime) {
        StringBuilder tooltip = new StringBuilder(this.getTimeSpentTooltipText());
        if (wdhmTime != null && wdhmTime.length() > 0) {
            tooltip.append("\n\n");
            tooltip.append(NLS.bind((String)Messages.WorkLogPart_Auto_Filled, (Object)wdhmTime));
        }
        return tooltip.toString();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.workDoneAmountInSeconds >= 60L) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
        this.validateSettings();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.collectWorkLog();
        }
        super.buttonPressed(buttonId);
    }
}

